#include <iostream.h>
#include "estimateDelayTimer.h"
#include "../controlAgent.h"
#include "../global.h"

EstimateDelayTimer::EstimateDelayTimer(ControlAgent *controlAgentPtrIn){
  controlAgentPtr=controlAgentPtrIn;
}

EstimateDelayTimer::~EstimateDelayTimer(){
}

void EstimateDelayTimer::Expire(void){
  controlAgentPtr->SendPeriodicEstimateDelay();
}

void EstimateDelayTimer::PrintTimerInfo(){
  if(verbosity > 1)
    cout << "\n" << GetCurrTime() << ": Timer - Estimate Delay Timer of " << 
      GetNameByAddr(controlAgentPtr->GetMyAddr());
}
