#include <stdio.h>
#include "../vrtEntry.h"
#include "../vrt.h"
#include <iostream.h>
#include "../METRICS/routingMetric.h"
#include "../METRICS/bwLatencyMetric.h"
#include "../METRICS/latencyMetric.h"
#include "../METRICS/bwMetric.h"
#include "../path.h"
#include "../gossipPayLoad.h"
#include "../performanceAgent.h"
#include "../connectivityAgent.h"
#include "../neighborTable.h"

int GOSSIP_PORT =500;
const int MAX_ADDRESSES=100;
ProtocolMetricType protocolMetric=BW_LATENCY;
int perPacketVerbosity=0;
EventQueue *eventQueue=NULL;

RoutingMetric *CreateNewRoutingMetric(){
  return(new BWLatencyMetric());
}

BWLatencyMetric *CreateBWLatencyMetric(int bw, int latency){
  BWMetric *bwMetric=new BWMetric(bw);
  LatencyMetric *latencyMetric = new LatencyMetric(latency);
  BWLatencyMetric *dualMetric = new BWLatencyMetric(bwMetric,
						    latencyMetric);
  return(dualMetric);
}

Path *CreatePath(int pathLen, int *pathArray){
  Path *path = new Path();

  Path *path1 = new Path();
  path1->SetZeroPath();

  for(int i=pathLen-1; i >= 0; i--){
    path->Merge(pathArray[i],path1);
    delete path1;
    path1=path->Duplicate();
  }

  delete path1;
  return(path);
}

int MAX_SOURCE_RATE = 1200;
int PROPAGATION_DELAY_FLAG=0;
int localCongestionSignal=0;
int verbosity=1;
int currTime=0;

char str[100];

char *GetNameByAddr(int addr){
  sprintf(str,"%d",addr);
  return(str);
}

long GetCurrTime(){
  return(currTime);
}

void MyError(char *str){
  printf("%s",str);
  exit(0);
}

void main(){

  int myAddr=0;
  int nbr=1;
  int nbr1=2;

  VirtualRoutingTable *vrt=new VirtualRoutingTable(100,0);

  NbrTable *nbrTable = new NbrTable();
  nbrTable->AddNbr(nbr,0);
  nbrTable->AddNbr(nbr1,0);

  PerformanceAgent *perfAgent=new PerformanceAgent(NULL,
						   NULL,
						   vrt,
						   nbrTable);

  VRTEntryType *routeToNbr=vrt->AddRoute(nbr);
  VRTEntryType *routeToNbr1=vrt->AddRoute(nbr1);

  routeToNbr->IntegrateBWResult(400,BW_RESULT_LB);
  routeToNbr->IntegrateDelayResult(130);
  currTime += 2 * 60 * 1000;
  routeToNbr1->IntegrateBWResult(1020,BW_RESULT_LB);
  routeToNbr1->IntegrateDelayResult(10);
  currTime += 5 * 60 * 1000 + 1;

  perfAgent->ScheduleBWTestToNbrs();
  exit(0);

  UpdateRecord *recordPtr=new UpdateRecord[4];

  recordPtr[0].SetAddr(10);
  recordPtr[0].SetLastControlSeqNum(100);
  RoutingMetric *rm = CreateBWLatencyMetric(1020,2);
  recordPtr[0].SetRoutingMetric(rm);
  int pathArr[]={5,8,10};
  Path *path=CreatePath(3,pathArr);
  recordPtr[0].SetPath(path);

  recordPtr[1].SetAddr(15);
  recordPtr[1].SetLastControlSeqNum(200);
  rm = CreateBWLatencyMetric(1020,10);
  recordPtr[1].SetRoutingMetric(rm);
  int pathArr1[]={7,9,15};
  path=CreatePath(3,pathArr1);
  recordPtr[1].SetPath(path);

  recordPtr[2].SetAddr(20);
  recordPtr[2].SetLastControlSeqNum(300);
  rm = CreateBWLatencyMetric(-2,-2);
  recordPtr[2].SetRoutingMetric(rm);
  int pathArr2[]={6,20};
  path=CreatePath(2,pathArr2);
  recordPtr[2].SetPath(path);

  recordPtr[3].SetAddr(0);
  recordPtr[3].SetLastControlSeqNum(1000);
  rm = CreateBWLatencyMetric(1020,20);
  recordPtr[3].SetRoutingMetric(rm);
  int pathArr3[]={0};
  path=CreatePath(1,pathArr3);
  recordPtr[3].SetPath(path);

  ControlUpdateMsg *msg=new ControlUpdateMsg(10,4,recordPtr);
  //  msg->Print();
  //cout << "\n \n";


  VRTEntryType *nbrRoute=vrt->AddRoute(nbr);
  nbrRoute->IntegrateDelayResult(20);
  nbrRoute->IntegrateBWResult(1020,BW_RESULT_LB);

  vrt->UpdateTable(4,recordPtr,1,0);
  //  vrt->Print();



  recordPtr=new UpdateRecord[5];

  recordPtr[0].SetAddr(10);
  recordPtr[0].SetLastControlSeqNum(97);
  rm = CreateBWLatencyMetric(300,70);
  recordPtr[0].SetRoutingMetric(rm);
  int pathArr0[]={4,7};
  path=CreatePath(2,pathArr0);
  recordPtr[0].SetPath(path);

  recordPtr[1].SetAddr(15);
  recordPtr[1].SetLastControlSeqNum(208);
  rm = CreateBWLatencyMetric(300,30);
  recordPtr[1].SetRoutingMetric(rm);
  int pathArr11[]={0,17,19,15};
  path=CreatePath(3,pathArr11);
  recordPtr[1].SetPath(path);

  recordPtr[2].SetAddr(20);
  recordPtr[2].SetLastControlSeqNum(301);
  rm = CreateBWLatencyMetric(-2,-2);
  recordPtr[2].SetRoutingMetric(rm);
  int pathArr21[]={16,201};
  path=CreatePath(2,pathArr21);
  recordPtr[2].SetPath(path);

  recordPtr[3].SetAddr(0);
  recordPtr[3].SetLastControlSeqNum(1000);
  rm = CreateBWLatencyMetric(1020,20);
  recordPtr[3].SetRoutingMetric(rm);
  int pathArr31[]={0};
  path=CreatePath(1,pathArr31);
  recordPtr[3].SetPath(path);

  recordPtr[4].SetAddr(7);
  recordPtr[4].SetLastControlSeqNum(1800);
  rm = CreateBWLatencyMetric(1020,70);
  recordPtr[4].SetRoutingMetric(rm);
  int pathArr41[]={14,6};
  path=CreatePath(1,pathArr41);
  recordPtr[4].SetPath(path);

  msg=new ControlUpdateMsg(10,5,recordPtr);
  //  msg->Print();
  //cout << "\n \n";

  VRTEntryType *nbr1Route=vrt->AddRoute(nbr1);
  nbr1Route->IntegrateDelayResult(40);
  nbr1Route->IntegrateBWResult(1020,BW_RESULT_LB);

  vrt->UpdateTable(5,recordPtr,2,0);
  //  vrt->Print();


  VRTEntryType *route=vrt->GetRoute(10);
  route->IntegrateBWResult(1020,BW_RESULT);
  route->IntegrateDelayResult(20);
  route->UpdateOnRTProbe();

  route=vrt->GetRoute(15);
  //  route->IntegrateBWResult(300,BW_RESULT);
  route->IntegrateDelayResult(10);
  currTime=60000;
  route->UpdateOnRTProbe();

  route=vrt->GetRoute(20);
  route->IntegrateBWResult(600,BW_RESULT);
  //  route->IntegrateDelayResult(18);
  currTime=120000;
  route->UpdateOnRTProbe();
  
  currTime=300000;

  //vrt->Print();

  
  cout << "\n\n";

  for(route=vrt->GetNextRouteInit(); route != NULL; route=vrt->GetNextRoute()){
    int addr=route->GetAddr();
    RoutingMetric *routeMetric=route->GetRoutingMetric();
  
    cout << "\n Addr: " << addr << " ";
    routeMetric->Print();
  }
  
   cout << "\n \n";



  ProbeResponseRecord *recPtr=new ProbeResponseRecord[4];

  recPtr[0].SetAddr(10);
  recPtr[0].SetLastControlSeqNum(100);
  rm = CreateBWLatencyMetric(1020,5);
  recPtr[0].SetRoutingMetric(rm);


  recPtr[1].SetAddr(15);
  recPtr[1].SetLastControlSeqNum(200);
  rm = CreateBWLatencyMetric(1020,5);
  recPtr[1].SetRoutingMetric(rm);


  recPtr[2].SetAddr(20);
  recPtr[2].SetLastControlSeqNum(300);
  rm = CreateBWLatencyMetric(300,40);
  recPtr[2].SetRoutingMetric(rm);

  recPtr[3].SetAddr(0);
  recPtr[3].SetLastControlSeqNum(1000);
  rm = CreateBWLatencyMetric(1020,10);
  recPtr[3].SetRoutingMetric(rm);


  int probeNode=7;



 /**************
int selectArr[100];
selectArr[10]=0;
selectArr[15]=0;
selectArr[20]=0; 

  for(int i=1; i <= 500; i++){
    int node=perfAgent->ProbeSelect();
    selectArr[node]++;
  }

  cout << " 10: " << selectArr[10]
       << " 15: " << selectArr[15]
       << " 20: " << selectArr[20];

 ****************************/

  //  VRTEntryType *probeRoute=vrt->AddRoute(probeNode);
  VRTEntryType *probeRoute=vrt->GetRoute(probeNode);
  probeRoute->IntegrateDelayResult(6);
  probeRoute->IntegrateBWResult(300,BW_RESULT);

   currTime +=  22 * 60 * 1000;
  
  ProbeResponseMsg *probeMsg=new ProbeResponseMsg(100,
						  currTime - 10,
						  LOW,
						  4,
						  recPtr);
  
  cout << "\n \n Probe RESPONSE.....";
  probeMsg->Print();

  cout << "\n Receiving Probe Response.... " 
       << GetCurrTime()
       << " sent at.." << probeMsg->GetTime();
  perfAgent->RecvProbeResponse(probeNode,GOSSIP_PORT,probeMsg);

			     


  /**********************
  int nbr=5;
  int other=10;
  int myAddr=0;
  int nbr1=6;

  VRTEntryType *route=new VRTEntryType(nbr,0);
  currTime=800;
  route->UpdateOnRTProbe();
  
  currTime=100;
  cout << "\n Num Probes: " << route->GetNumRTProbes();
  cout << "\n time: " << route->GetTimeSinceLastRTProbe();

  exit(0);

  VRTEntryType *routeNbr=new VRTEntryType(nbr,0);
  VRTEntryType *routeOther=new VRTEntryType(other,0);

  VRTEntryType *routeNbrToNbr=new VRTEntryType(nbr,1);
  RoutingMetric *metricFromNbrToNbr=routeNbrToNbr->GetRoutingMetric();
  cout <<"\n Self metric is ";
  metricFromNbrToNbr->Print();

  Path *zeroPath=new Path();
  zeroPath->SetZeroPath();
 
  routeNbr->IntegrateDelayResult(40);
  routeNbr->IntegrateBWResult(800,BW_RESULT);
  RoutingMetric *linkMetricNbr=routeNbr->GetLinkMetric();

  routeNbr->UpdateRoutingInformation(nbr,
				     0,
				     linkMetricNbr,
				     metricFromNbrToNbr,
				     myAddr,
				     zeroPath);
  routeNbr->Print();

  cout << "\n\n";

  routeNbr->IntegrateBWResult(2000,BW_RESULT);
  routeNbr->Print();
  exit(0);
  

  LatencyMetric *latencyMetric=new LatencyMetric(10);
  BWMetric *bwMetric=new BWMetric(600);
  RoutingMetric *metricFromNbrToOther=new BWLatencyMetric(bwMetric,
							  latencyMetric);



  Path *pathFromNbrToOther=new Path();
  pathFromNbrToOther->Merge(other,zeroPath);

  routeOther->UpdateRoutingInformation(nbr,
				       0,
				       linkMetricNbr,
				       metricFromNbrToOther,
				       myAddr,
				       pathFromNbrToOther);
  routeOther->Print();

  cout << " \n \n END OF FIRST UPDATE \n \n ";

  VRTEntryType *routeNbr1=new VRTEntryType(nbr1,0);

  RoutingMetric *linkMetricNbr1=routeNbr1->GetLinkMetric();
  routeNbr1->IntegrateDelayResult(10);
  routeNbr1->IntegrateBWResult(900,BW_RESULT);

  LatencyMetric *latencyMetric1=new LatencyMetric(45);
  BWMetric *bwMetric1=new BWMetric(1020);
  RoutingMetric *metricFromNbr1ToOther=new BWLatencyMetric(bwMetric1,
							  latencyMetric1);

  Path *pathFromNbr1ToOther=new Path();
  pathFromNbr1ToOther->Merge(myAddr,routeOther->GetPath());

  routeOther->UpdateRoutingInformation(nbr1,
				       0,
				       linkMetricNbr1,
				       metricFromNbr1ToOther,
				       myAddr,
				       pathFromNbr1ToOther);

  routeOther->Print();

  cout << "\n \n END OF UPDATE 2 !!!  \n \n";


  //  pathFromNbrToOther->Merge(myAddr,routeOther->GetPath());
  //  metricFromNbrToOther->SetBest();
  //routeNbr->IntegrateBWResult(20,BW_RESULT);
  routeOther->UpdateRoutingInformation(nbr,
				       0,
				       linkMetricNbr,
				       metricFromNbrToOther,
				       myAddr,
				       pathFromNbrToOther);
  routeOther->Print();

  cout << "\n \n END OF UPDATE 3 !!!  \n \n";


  pathFromNbr1ToOther->Merge(nbr,pathFromNbrToOther);
  metricFromNbr1ToOther->SetBest();
  
  routeOther->UpdateRoutingInformation(nbr1,
				       1,
				       linkMetricNbr1,
				       metricFromNbr1ToOther,
				       myAddr,
				       pathFromNbr1ToOther);

  routeOther->Print();

  
  cout << "\n Hello !!!!!!!!";
  routeOther->Print();
  RoutingMetric *f=routeOther->GetLinkMetric();
  cout << "\n \n Wonder !!!!!!!";
  f->SetBest();
  cout << "\n \n";
  f->Print();
  routeOther->Print();
  *******************/

}


                          
