#include <stdio.h>
#include "../partitionAgent.h"
#include "../vrt.h"
#include "../vrtEntry.h"
#include "../neighborTable.h"
#include "../global.h"
#include "../path.h"
#include "../METRICS/latencyMetric.h"

const int MAX_ADDRESSES = 3001;
int localCongestionSignal=0;

char *GetNameByAddr(int addr){
  char *str = new char[100];
  sprintf(str,"%d",addr);
  return(str);
}

long GetCurrTime(){
  return(0);
}

TimerImp *GetTimerImplementation(Timer *timer){

  return(NULL);

}

void MyError(const char *format, ...) {
  exit(0);
}

void MyWarning(const char *format, ...) {

}


MyPath *CreatePath(int pathLen, int *pathArray){
  MyPath *path = new MyPath();

  MyPath *path1 = new MyPath();
  path1->SetZeroPath();
  
  for(int i=pathLen-1; i >= 0; i--){
    path->Merge(pathArray[i],path1);
    delete path1;
    path1=path->Duplicate();
  }
  
  delete path1;
  return(path);
}



void main(){
  PartitionTest();
}



void PartitionTest(){

  protocolMetric=LATENCY_ONLY;

  int *arr=new int[5];
  arr[0]=5;
  arr[1]=1;
  arr[2]=2;
  arr[3]=3;
  arr[4]=4;
  VirtualRoutingTable *vrtPtr=
    new VirtualRoutingTable(100,15,5,arr);

  NbrTable *nbrTabPtr=
    new NbrTable();

  PartitionAgent *paPtr = new PartitionAgent(NULL,
					     NULL,
					     vrtPtr,
					     nbrTabPtr);

  paPtr->RefreshPartitionList();
  paPtr->PrintPartitionList();

  
  int nbr=1;
  nbrTabPtr->AddNbr(nbr,0);
  
  MyPath *zeroPath=new MyPath();
  zeroPath->SetZeroPath();
 
  LatencyMetric *metricFromNbrToNbr=new LatencyMetric(0);


  VRTEntryType *route=vrtPtr->GetRoute(nbr);
  route->IntegrateDelayResult(10);
  RoutingMetric *metricToNbr=route->GetLinkMetric();
  
  route->UpdateRoutingInformation(nbr,
				  0,
				  metricToNbr,
				  metricFromNbrToNbr,
 				  15,
				  zeroPath);
  
  printf("\n Refresh happens...!!! \n");

  paPtr->RefreshPartitionList();
  paPtr->PrintPartitionList();
  
  UpdateRecord *recordPtr=new UpdateRecord[4];

  recordPtr[0].SetAddr(3);
  recordPtr[0].SetLastControlSeqNum(100);
  LatencyMetric *rm=new LatencyMetric(-2);
  recordPtr[0].SetRoutingMetric(rm);
  int pathArr[]={6,9,11};
  MyPath *path=CreatePath(3,pathArr);
  recordPtr[0].SetPath(path);

  recordPtr[1].SetAddr(4);
  recordPtr[1].SetLastControlSeqNum(100);
  rm=new LatencyMetric(40);
  recordPtr[1].SetRoutingMetric(rm);
  int pathArr1[]={2,13};
  path=CreatePath(2,pathArr1);
  recordPtr[1].SetPath(path);
  
  recordPtr[2].SetAddr(5);
  recordPtr[2].SetLastControlSeqNum(200);
  rm=new LatencyMetric(-1);
  recordPtr[2].SetRoutingMetric(rm);
  int pathArr2[]={6,13};
  //path=CreatePath(2,pathArr2);
  path = new MyPath();
  recordPtr[2].SetPath(path);


  recordPtr[3].SetAddr(2);
  recordPtr[3].SetLastControlSeqNum(200);
  rm=new LatencyMetric(20);
  recordPtr[3].SetRoutingMetric(rm);
  int pathArr3[]={2};
  path=CreatePath(1,pathArr3);
  recordPtr[3].SetPath(path);


  vrtPtr->UpdateTable(4,
		      recordPtr,
		      nbr,
		      0);
  
  //  vrtPtr->Print();
  
  printf("\n\n Another refresh!!! \n\n");
  fflush(stdout);

  paPtr->RefreshPartitionList();
  paPtr->PrintPartitionList();

  recordPtr[2].SetAddr(5);
  recordPtr[2].SetLastControlSeqNum(200);
  rm=new LatencyMetric(50);
  recordPtr[2].SetRoutingMetric(rm);
  // int pathArr2[]={6,13};
  path=CreatePath(2,pathArr2);
  recordPtr[2].SetPath(path);
  // recordPtr[2].SetPath(zeroPath);


  recordPtr[3].SetAddr(2);
  recordPtr[3].SetLastControlSeqNum(200);
  rm=new LatencyMetric(-1);
  recordPtr[3].SetRoutingMetric(rm);
  path=new MyPath();
  recordPtr[3].SetPath(path);

  
  vrtPtr->UpdateTable(4,
		      recordPtr,
		      nbr,
		      0);
  
  // vrtPtr->Print();

  printf("\n\n YET Another refresh!!! \n\n");
  fflush(stdout);

  paPtr->RefreshPartitionList();
  paPtr->PrintPartitionList();

}

/*****************
void PartitionTest1(){
  int i;

  PartitionAgent *paPtr = new PartitionAgent(NULL,
					     NULL,
					     NULL,
					     NULL);
  
  paPtr->InsertInPartitionList(5);
  paPtr->InsertInPartitionList(13);
  paPtr->InsertInPartitionList(8);

  i=paPtr->IsInPartitionList(8);
  printf("IsInPartitionList:8 %d",i);

  i=paPtr->IsInPartitionList(3);
  printf("IsInPartitionList:3 %d",i);

  paPtr->PrintPartitionList();
  printf("Num Partitioned Nodes: %d",paPtr->numPartitionedNodes);


  int j;
  PartitionAgent::PartitionList *pl,*pl1;

  for(j=0; j < 1000; j++){
    pl=paPtr->GetRandomElement();
    printf("\n Random: %d",pl->addr);
  }


  pl=paPtr->GetNodeGivenAddr(13);
  pl1=paPtr->GetNodeGivenAddr(8);
  paPtr->DeleteFromPartitionList(pl,pl1);

  paPtr->PrintPartitionList();
  printf("Num Partitioned Nodes: %d",paPtr->numPartitionedNodes);

  exit(0);

  paPtr->DeleteFromPartitionList(13);
  paPtr->DeleteFromPartitionList(8);

  paPtr->InsertInPartitionList(7);
  paPtr->DeleteFromPartitionList(8);
  paPtr->DeleteFromPartitionList(7);
  paPtr->DeleteFromPartitionList(5);
  paPtr->InsertInPartitionList(3);

  paPtr->PrintPartitionList();
  printf("Num Partitioned Nodes: %d",paPtr->numPartitionedNodes);

}
**********************/

  
