#include <assert.h>
#include <iostream.h>

#include <Util/inputSerializableStream.h>
#include <Util/outputSerializableStream.h>
#include "nullMetric.h"
#include "../vrtEntry.h"


void NullMetric::SanityChecks(NullMetric *nullMetric){

  assert(
	 nullMetric->IsNoRoute() ||
	 nullMetric->IsTempRoute() ||
	 nullMetric->IsValidRoute()
	 );
}

NullMetric::NullMetric(){
  state=NO_ROUTE;
}

NullMetric::NullMetric(int stateIn){
  state=stateIn;
}

NullMetric* NullMetric::Merge(RoutingMetric *otherMetric){
  NullMetric *other = (NullMetric *)(otherMetric);
  
  SanityChecks(this);
  SanityChecks(other);
  
  assert(!this->IsNoRoute());
  assert(!other->IsNoRoute());
  
  int newState=VALID_ROUTE;
  
  if(
     this->IsTempRoute() ||
     other->IsTempRoute()
     ){
    newState=TEMPORARY_ROUTE;
  }
  
  NullMetric *mergedMetric=new NullMetric(newState);
  return(mergedMetric);
}


int NullMetric::Compare(RoutingMetric *otherMetric){
  
  NullMetric *other= (NullMetric *)(otherMetric);
  
  SanityChecks(this);
  SanityChecks(other);
  
  assert(!this->IsNoRoute());
  assert(!other->IsNoRoute());

  if(this->IsTempRoute()){
    if (other->IsTempRoute()){
      return(0);
    }
    else{
      return(1);
    }
  }

  if(this->IsValidRoute()){
    if (other->IsTempRoute()){
      return(-1);
    }
    else{
      return(0);
    }
  }

  assert(0);
  /*** XXXXXXX
       MyError("Should not reach here!!");
       return(0);
  *****/
}    

void NullMetric::SetNoRoute(){
  state=NO_ROUTE;
}

void NullMetric::SetTempRoute(){
  state=TEMPORARY_ROUTE;
}

void NullMetric::SetMetric(RoutingMetric *otherMetric){
  NullMetric *other = (NullMetric *)(otherMetric);
  state=other->state;
}

void NullMetric::SetBest(){
  state=VALID_ROUTE;
}

int NullMetric::IsNoRoute(){
  if(state == NO_ROUTE){
    return(1);
  }
  else{
    return(0);
  }
}

int NullMetric::IsTempRoute(){
  if(state == TEMPORARY_ROUTE){
    return(1);
  }
  else{
    return(0);
  }
}

int NullMetric::IsValidRoute(){
  if(state == VALID_ROUTE){
    return(1);
  }
  else{
    return(0);
  }
}

int NullMetric::IsBest(){
  return(state == VALID_ROUTE);
}


float 
NullMetric::ComputeUtilityGain(RoutingMetric *linkMetricToProbedNode,
			       RoutingMetric *routingMetricToProbedNode){
  
  return(0);
}

float NullMetric::ComputeLinkQuality(){
  return(0);
}

void NullMetric::PhysicalToRouting(VRTEntryType *vrtEntryPtr){
  state=0; // hack to initialize linkMetric
  return;
}

NullMetric *NullMetric::Duplicate(){
  NullMetric *newNullMetric= new NullMetric(state);
  return(newNullMetric);
}

void NullMetric::Print(){
  cout << "\n state = " << state;
}

int NullMetric::Size(){
  return(sizeof(state));
}

void NullMetric::ReadFromStream(InputSerializableStream *osPtr){
  state=osPtr->ReadInt();

}

void NullMetric::WriteToStream(OutputSerializableStream *isPtr){
  isPtr->WriteInt(state);
}


