#ifndef BW_METRIC_H
#define BW_METRIC_H

#include "routingMetric.h"

class VRTEntryType;
class BWLevelMgr;

class BWMetric:public RoutingMetric{
 private:
  static const int NO_ROUTE=-1;
  static const int TEMPORARY_ROUTE=-2;
  static const int UNKNOWN_BW = -3;

  int bw;

  void SanityChecks(BWMetric *bwMetric);
  
  void CreateBWLevelMgr();
  static BWLevelMgr *bwLevelMgr;
  


  // factor beyond next bandwidth level, that is required to
  // increment bandwidth level
  static const float BETA = 0.5; 
  static const float BETA_MAX=0.1;
  int hysteresisFlag;
  int ComputeNewRoutingBW(int physicalBW);

 public:

  BWMetric();
  BWMetric(int bwIn);

  BWMetric *Merge(RoutingMetric *otherMetric);
  int Compare(RoutingMetric *otherMetric);

  void SetNoRoute();
  void SetTempRoute();
  void SetMetric(RoutingMetric *otherMetric);
  void SetBest();
  
  int IsNoRoute();
  int IsTempRoute();
  int IsValidRoute();
  int IsBest();
  int IsKnown();
  int IsUnKnown();


  float ComputeUtilityGain(RoutingMetric *linkMetricToProbedNode,
			   RoutingMetric *routingMetricToProbedNode);
  
  float ComputeLinkQuality(); // Returns fraction between 0 and 1
  
  void PhysicalToRouting(VRTEntryType *vrtEntryPtr);
  
  BWMetric *Duplicate();
  void Print();
  int Size();
  int GetBW();
  void ReadFromStream(InputSerializableStream *osPtr);
  void WriteToStream(OutputSerializableStream *isPtr); 
};

#endif






