/*
 *  Team 1
 *  CS575: Software Design
 *  Project Phase I
 *  Pipe-and-Filter style
 *  PNFSorter.java
 */

/**
 *  <p>Intended as the sorting encapsulation for the
 *  Pipe-and-Filter style implementation of the KWIC program.
 *
 *  <p>This filter will take in a data collection and will sort it using its 
 *  current sorting algorithm.  Once the collection is sorted it will teturn it.
 *  
 *  <p><b>PRE:</b> expects to receive the data object as a Vector of Sentences
 *  <br><b>POST:</b> if the data is empty, return it as is; otherwise, returns
 *  the data sorted alphanumerically
 *
 *  @author Lisa Anthony
 */

public class PNFSorter  {

    // class instance variables
    //    private SentenceCollection data = null;

    /**
     * <p> <b>Test driver</b></p>
     */
    public static void main(String[] args) throws KWICException {
        SentenceCollection inData = new SentenceCollection();
        inData.addKWICRow(new Object[] {"This", "is", "just", "some", "Test", "input"});
        inData.addKWICRow(new Object[] {"The", "Cat", "is", "in", "the", "Hat"});
        inData.addKWICRow(new Object[] {"Cat", "is", "in", "the", "Hat", "The"}); 
        inData.addKWICRow(new Object[] {"is", "in", "the", "Hat", "The", "Cat"});
        inData.addKWICRow(new Object[] {"in", "the", "Hat", "The", "Cat", "is"});
        inData.addKWICRow(new Object[] {"the", "Hat", "The", "Cat", "is", "in"});
        inData.addKWICRow(new Object[] {"Hat", "The", "Cat", "is", "in", "the"});

        PNFSorter sorter = new PNFSorter();
        SentenceCollection outData = sorter.sortData(inData);

        // print the data collection
        System.out.println();
        outData.startKWICRowIterator();
        while (outData.hasNextKWICRow()) {
            Object[] temp = outData.getNextKWICRow();
            int count = temp.length;
            for (int i=0; i<count; i++) {
                System.out.print(temp[i].toString() + " ");
            }
            System.out.println();
        }
    }

    /**
     * Default constructor.
     */
    public PNFSorter (/*SentenceCollection data*/) {
	//this.data = data;

	//sortData();
    }

    /**
     * Sorts a SentenceCollection object via an insertion sort algorithm.
     *
     * @param     data          SentenceCollection to be sorted
     * @return                  the sorted SentenceCollection
     * @exception KWICException If an accessing error occurred (empty words/sentences/etc).
     */
    public SentenceCollection sortData (SentenceCollection data) throws KWICException {
	// sort data via insertion sort algorithm
	return insertionSort (data);
    }
    
    private SentenceCollection insertionSort (SentenceCollection data) throws KWICException {
	// if empty, returns without operating on data
	// otherwise sorts data alphanumerically (Unicode)
	if (data.isEmpty())
	    return data;
	else {
	    // sorts the data by direct insertion
	    int n = data.size();
	    for (int i=1; i<n; i++) {
                int temp = i;
		for( int j = i-1; j >= 0; j-- ){
                    if( data.isGreaterThan(data.getKWICRowAt(j), data.getKWICRowAt(temp))) {
                        // the key is smaller, so Sentence at j has to be moved one position up
                        data.swapKWICRows(temp, j);
                        temp = j;
                    }
                }
	    }
	    return data;
	}
    }    
} // end of class PNFSorter
