/*
 *  Team 1
 *  CS575: Software Design
 *  Project Phase I
 *  Pipe-and-Filter style
 *  PNFShifter.java
 */

import java.util.Vector;

/**
 *  <p>Shifter class for the Pipe and Filter KWIC system.
 * 
 *  <p>This class represents a filter that takes in a SentenceCollection and
 *  shifts all the sentences in that collection.  The sentences are inserted as shifted
 *  sentences.  This shifted collection is then returned.  The original sentences 
 *  remain in the collection.  
 *
 *  <p><b>PRE:</b> expects to receive SentenceCollection data object
 * (no assumptions are made about how much data is in it.)
 *  <br><b>POST:</b> after execution, all the sentences will have been shifted
 * and inserted into the outgoing SentenceCollection data object
 *
 *  @author Diana Tetelman
 */

public class PNFShifter
{
    private SentenceCollection shiftedData;
    
    /**
     * <p> <b>Test driver</b></p>
     * <p>Should have the following output if working properly</p>
     * 
     *       <br>The Cat is in the Hat 
     *       <br>Cat is in the Hat The 
     *       <br>is in the Hat The Cat
     *       <br>in the Hat The Cat is
     *       <br>the Hat The Cat is in
     *       <br>Hat The Cat is in the
     *       <br>This is just some Test input 
     *       <br>is just some Test input This 
     *       <br>just some Test input This is 
     *       <br>some Test input This is just 
     *       <br>Test input This is just some 
     *       <br>input This is just some Test 
     */
    public static void main(String[] args) throws KWICException
    {
        SentenceCollection inData = new SentenceCollection();
        inData.addKWICRow(new String[] {"The", "Cat", "is", "in", "the", "Hat"});
        inData.addKWICRow(new String[] {"This", "is", "just", "some", "Test", "input"});

        PNFShifter shifter = new PNFShifter();
        SentenceCollection outData = shifter.shiftData(inData);

        // print the data collection
        System.out.println();
        outData.startKWICRowIterator();
        while( outData.hasNextKWICRow() == true )
        {
            Object[] temp = outData.getNextKWICRow();
            int count = temp.length;
            for( int i=0; i<count; i++ )
            {
                System.out.print(temp[i].toString() + " ");
            }
            System.out.println();
        }
    }
    
    /**
     * Constructor
     */
    public PNFShifter(){
    }
    
    /**
     * <p> This method will shift the incoming data and return a SentenceCollection
     * data object with all of the new shifted data in it.
     *
     * @param       data             SentenceCollection data object
     * @return                      SentenceCollection data object filled with shifted data (if any was processed)
     * @exception   KWICException   thrown if any errors occur
     */
    public SentenceCollection shiftData( SentenceCollection data ) throws KWICException
    {
        shiftedData = new SentenceCollection();
        data.startKWICRowIterator();
        while( data.hasNextKWICRow() == true )
        {
            Object[] words = data.getNextKWICRow();
			shiftedData.addKWICRow(words);
            int numOfWords = words.length;
			int position = shiftedData.size()-1;
            
			for( int wIndex=1; wIndex < numOfWords; wIndex++ )
			{
				shiftedData.addKWICShift(position, wIndex);				
			}
        }
        return shiftedData;
    }
}