/*
 *  Team 1
 *  CS575: Software Design
 *  Project Phase I
 *  Pipe-and-Filter style
 *  PNFOutput.java
 */

/**
 *  <p>Intended as the output encapsulation for the Pipe-and-Filter
 *  style implementation of the KWIC program.
 *
 *  <p>This class represents a filter that outputs a give SentenceCollection to 
 *  the standard I/O.  It takes in a SentenceCollection, without making any assumptions
 *  about the size of it or it's contents.  It will simply output the collection as follows:
 *  one sentence per line, with the words seperated by white spaces.  The SentenceCollection
 *  will not be changed by this filter.
 * 
 *  <p><b>PRE:</b> expects to receive access to a data object as a Vector of
 *  KWICRows
 *  <br><b>POST:</b> if data was empty, prints "Empty"; otherwise sends each
 *  KWICRow to the output stream
 *
 *  @author Lisa Anthony
 */


import java.io.*;

public class PNFOutput {

    // class instance variables
    private BufferedOutputStream bos = null;
    //    private KWICRowCollection data = null;

    /**
     * <p> <b>Test driver</b></p>
     */
    public static void main(String[] args) throws KWICException {
	SentenceCollection inData = new SentenceCollection();
        inData.addKWICRow(new Object[] {"The", "Cat", "is", "in", "the", "Hat"});
        inData.addKWICRow(new Object[] {"This", "is", "just", "some", "Test", "input"});

        PNFOutput output = new PNFOutput();
	output.printData(inData);
    }

    /**
     * Default constructor which initializes this.os to standard output if no other stream is specified.
     */
    public PNFOutput (/*KWICRowCollection data*/) {
	//	this.data = data;
	this.bos = new BufferedOutputStream (System.out);

	//	printData();
    }

    /**
     * Constructor which initializes this.os to the given OutputStream.
     *
     * @param  bos  Intended destination OutputStream.
     */
    public PNFOutput (OutputStream bos/*, KWICRowCollection data*/) {
	//	this.data = data;
	this.bos = new BufferedOutputStream (bos);

	//	printData();
    }

    /**
     * Prints a KWICRowCollection object to the OutputStream.
     *
     * @param     data          KWICRowCollection to be sorted
     * @exception KWICException If an accessing error occurred (empty words/KWICRows/etc).
     */
    public void printData (SentenceCollection data) throws KWICException {
	// if empty, prints empty message
	// otherwise prints each KWICRow in the data
	
	// create PrintWriter for easier output
	PrintWriter pw = new PrintWriter (bos);
	
	if (data.isEmpty()) {
	    pw.write ("Input file(s) was (were) empty.\n");
	} else {
	    // iterate through data by KWICRows and Words
	    data.startKWICRowIterator();
	    while (data.hasNextKWICRow()) {
		String[] words = data.toString(data.getNextKWICRow());
		for (int i=0; i<words.length; i++) {
		    // send to output stream
		    pw.write (words[i] + " ");
		}
                pw.write('\n');
	    }
	}
	// close output stream
	pw.close();
    }    

} // end of class PNFOutput
