/*
 *  Team 1
 *  CS575: Software Design
 *  Project Phase I
 *  Pipe-and-Filter style
 *  PNFMain.java
 */

/**
 *  <p>Intended as the main calling program for the
 *  Pipe-and-Filter style implementation of the KWIC program.
 *
 *  <p>This class coordinates all the filters.  It orders them in a way that suits
 *  the requirements.  It also creates the collection that is passed to the first filter.
 *  This class also contains the main method for project.  It parses the command line arguments.
 * 
 *  <p><b>PRE:</b> expects to receive the name(s) of the input file(s)
 *  <br><b>POST:</b> after execution, all 4 filter modules will have been
 *  instantiated and called.
 *
 *  @author Lisa Anthony
 */

import java.util.Vector;

public class PNFMain {

    /**
     * Default constructor.
     */
    PNFMain () {
    }

    /**
     * Main method of the Pipe-and-Filter implementation of the KWIC project.
     *
     * @param  args[]  the command line arguments
     */
    public static void main (String args[]) 
	{
		Vector inFiles = new Vector();
		Vector noiseFiles = new Vector();
	
		// command line parsing + usage clause
		int optind;   // option index
        if (args.length < 1) {
            System.out.println("Usage: java PNFMain [-n [noisefile1]] [infile1] [infile2]");
            System.exit(1);
        } 
		else {                
            noiseFiles.add("noiseWords");

            for (optind=0; optind < args.length; optind++) 
            {
                if( args[optind].equalsIgnoreCase("-n") )
                {
                    noiseFiles.removeAllElements();
					optind++;
					noiseFiles.addElement(args[optind]);
                    continue;
                }
                
				inFiles.add (args[optind]);                
            }
		}

		//System.out.println (noiseFiles.toString());

		try {
		    // create & initialize data object
		    SentenceCollection data = new SentenceCollection();
		    
		    // filter calls
		    PNFInput in = new PNFInput(' ', '\n');
		    PNFShifter shifter = new PNFShifter();
			PNFNoise noise = new PNFNoise(' ', '\n');
		    PNFSorter sorter = new PNFSorter();
		    PNFOutput out = new PNFOutput();
		    	   
	        out.printData (
				sorter.sortData (
					noise.getNoiseWords ( noiseFiles, 
						shifter.shiftData (
							in.getData (inFiles, new SentenceCollection())))));
		        
		} catch (KWICException ke) {
		    System.err.println (ke.getMessage());
		}
    }
    

} // end of class PNFMain
