/*
 *  Team 1
 *  CS575: Software Design
 *  Project Phase I
 *  Object-Oriented style
 *  OOSorter.java
 */

import java.io.*;
import java.util.Vector;

/**
 *  <p>Sorter class for the Object Oriented style implementation of the KWIC system.</p>
 *
 *  <p><b>PRE:</b> expects to receive the data collection object
 *  <br><b>POST:</b> if the data is empty, return it as it is; otherwise, returns the
 *  data collection sorted alphanumerically
 *
 *  <br>For consistency, code resembles PNFSorter by Lisa Anthony
 *  where possible.
 *
 *  @author Luiza da Silva
 */
public class OOSorter
{
    /**
     * <p><b>Test driver</b></p?
     */
    public static void main(String[] args) throws KWICException {
        SentenceCollection inData = new SentenceCollection();
        inData.addKWICRow(new Object[] {"This", "is", "just", "some", "Test", "input"});
        inData.addKWICRow(new Object[] {"The", "Cat", "is", "in", "the", "Hat"});
        inData.addKWICRow(new Object[] {"Cat", "is", "in", "the", "Hat", "The"}); 
        inData.addKWICRow(new Object[] {"is", "in", "the", "Hat", "The", "Cat"});
        inData.addKWICRow(new Object[] {"in", "the", "Hat", "The", "Cat", "is"});
        inData.addKWICRow(new Object[] {"the", "Hat", "The", "Cat", "is", "in"});
        inData.addKWICRow(new Object[] {"Hat", "The", "Cat", "is", "in", "the"});

        OOSorter sorter = new OOSorter();
        SentenceCollection outData = sorter.sortData(inData);
        
        // print the data collection
        System.out.println();
        outData.startKWICRowIterator();
        while (outData.hasNextKWICRow()) {
            Object[] temp = outData.getNextKWICRow();
            int count = temp.length;
            for (int i=0; i<count; i++) {
                System.out.print(temp[i].toString() + " ");
            }
            System.out.println();
        }
    }
    /**
     * Default constructor
     */
    public OOSorter () {/*empty*/}
    
    /**
     * Sorts a SentenceCollection object via an insertion sort algorithm.
     *
     * @param     data          SentenceCollection to be sorted
     * @return                  the sorted SentenceCollection
     * @exception KWICException If an accessing error occurrs
     */
    public SentenceCollection sortData(SentenceCollection data) throws KWICException
    {
        return insertionSort (data);
    }
    
    private SentenceCollection insertionSort (SentenceCollection data) throws KWICException
    {
        if (data.isEmpty())
            return data;
        else
        {
            // sorts the data by direct insertion
            int n = data.size();
            for (int i=1; i<n; i++) {
                int temp = i;
                for( int j = i-1; j >= 0; j-- ){
                    if( data.isGreaterThan(data.getKWICRowAt(j), data.getKWICRowAt(temp))) {
                         // the key is smaller, so Sentence at j has to be moved one position up
                         data.swapKWICRows(temp, j);
                         temp = j;
                    }
                }
            }
            return data;   
        }
    }
}// end of class OOSorter