/*
 *  Team 1
 *  CS575: Software Design
 *  Project Phase I
 *  Object-Oriented style
 *  OOShifter.java
 */

import java.util.Vector;
import java.util.StringTokenizer;

/**
 *  <p>Shifter class for the Object Oriented KWIC system.
 *
 *  <p>Module should be able to perform shift operations on a String 
 *  object.
 *  <br>For consistency, code resembles PNFShifter by Diana Tetelman 
 *  where possible.
 *
 *  @author Erik Hayes
 */

public class OOShifter {

    /**
     * <p> <b>Test Driver<\b><\p>
     * <p> The output of this driver should be every possible shift of the
     * two sentences:
     *      <br>The cat is in the hat
     *      <br>This is just some Test input
     *
     */
    public static void main(String[] args) throws KWICException {
	Vector test = new Vector();
	test.add(new String("The cat is in the hat"));
	test.add(new String("This is just some Test input"));
	OOShifter shifter = new OOShifter();
	Vector results = shifter.shiftStrings(test);
	for (int i = 0; i < results.size(); i++) {
	    System.out.println((String)results.elementAt(i));
	}
    }
    
    /**
     * Constructor
     */
    public OOShifter(){
    }
    
    /**
     * <p> This method will produce every possible shift on a string.
     *
     * @params     data     String containing the String to be shifted
     * @return              Vector of all the possible shifts of data
     */
    public Vector shiftString(String data) {
	Vector stringShifts = new Vector();
	Vector lineWords = new Vector();
	StringTokenizer st = new StringTokenizer(data);
	while(st.hasMoreTokens()) {
	    lineWords.add(st.nextToken());
	}
	for (int i = 0; i < lineWords.size(); i++) {
	    String iteration = new String();
	    for (int j = i; j < lineWords.size(); j++) {
		iteration += (String)lineWords.elementAt(j);
		if (j != lineWords.size()) {
		    iteration += " ";
		}
	    }
	    for (int j = 0; j < i; j++) {
		iteration += (String)lineWords.elementAt(j);
		if (j!= i-1) {
		    iteration += " ";
		}
	    }
	    stringShifts.add(iteration);
	}
	return stringShifts;
    }

    /**
     * <p> This method will produce every possible shift of a collection of strings.
     *
     * @params     data     Vector containing all of the Strings to be shifted
     * @return              Vector containing all of the possible shifts on all the input Strings
     */
    public Vector shiftStrings(Vector data) {
	Vector stringShifts = new Vector();
	for (int i = 0; i < data.size(); i++) {
	    Vector temp = this.shiftString((String)data.elementAt(i));
	    for (int j = 0; j < temp.size(); j++) {
		stringShifts.add((String)temp.elementAt(j));
	    }
	}
	return stringShifts;
    }

    /**
     * <p> Performs shift operations on every string within a SentenceCollection.
     *
     * @params    data    SentenceCollection to be shifted
     * @return            SentenceCollection resulting from the shifts
     */
    public SentenceCollection shiftSentenceCollection(SentenceCollection data) 
	throws KWICException {
	int size = data.size();
	SentenceCollection shiftedData = data;
	for (int i = 0; i < size; i++)
	    for (int j = 1; j < data.getNumberOfKWICObjects(i); j++) {
		shiftedData.addKWICShift(i, j);
	    }
	return shiftedData;
    }
}









