/*
 *  Team 1
 *  CS575: Software Design
 *  Project Phase I
 *  Object-Oriented style
 *  OOOutput.java
 */

import java.io.*;
import java.util.Vector;

/**
 *  <p>Output class for the Object Oriented style implementation of the KWIC system.</p>
 *
 *  <p><b>PRE:</b> expects to receive the data collection object as a Vector of KWICRows
 *  <br><b>POST:</b> if data was empty, print "Empty."; otherwise sends each KWICRow to
 *  the output stream
 *
 * <p><br>For consistency, code resembles PNFOutput by Lisa Anthony
 *  where possible.
 *
 *  @author Luiza da Silva
 */
public class OOOutput 
{
    //class instance variables
    private BufferedOutputStream bos = null;
    
    /**
     * <p> <b>Test driver</b></p>
     */
    public static void main(String[] args) throws KWICException {
        SentenceCollection inData = new SentenceCollection();
        inData.addKWICRow(new Object[] {"The", "Cat", "is", "in", "the", "Hat"});
        inData.addKWICRow(new Object[] {"This", "is", "just", "some", "Test", "input"});

        OOOutput output = new OOOutput();
	output.printData(inData);
    }
    
    /**
     * Default constructor which initializes this.out to standard output 
     * if no other stream is specified.
     */
    public OOOutput() 
    {
        //class instance variables
        this.bos = new BufferedOutputStream(System.out);
    }
    
    /**
     * Constructor which initializes this.out to the given OutputStream.
     *
     * @param out Intended destination OutputStream.
     */
    public OOOutput(OutputStream out)
    {
        this.bos = new BufferedOutputStream(out);
    }
    
    /**
     * Prints a KWICRowCollection object to the Output Stream.
     *
     * @param     data          KWICRowCollection to be sorted
     * @exception KWICException If an accessing error occurs.
     */
    public void printData(SentenceCollection data) throws KWICException
    {
     //if empty, prints empty message
     //otherwise prints each KWICRow in the data

     if (data.isEmpty())
     {
         System.out.println("Input file(s) were empty.\n");
     }
     else
     {
        //iterates through data by KWICRows and Words
        data.startKWICRowIterator();
        while(data.hasNextKWICRow() == true)
        {
          try{
     
                Object[] temp = data.getNextKWICRow();
		int count = temp.length;
                for(int i=0; i<count; i++)
                {
                    System.out.print(temp[i].toString() + " ");
                }
		System.out.println();
            }
            catch (KWICException e) {}
        }
     }
     
    }
} // end of class OOOutput
