/*
 *  Team 1
 *  CS575: Software Design
 *  Project Phase I
 *  Object-Oriented style
 *  OOMain.java 
 */

import java.io.*;
import java.util.Vector;

/**
 *  <p>Main class for the Object Oriented style implementation of the KWIC system.</p>
 *
 *  <p><b>PRE:</b> expects to receive the name(s) of the input files(s)
 *  <br><b>POST:</b> after execution, all modules will have been used.
 *
 *  <br>For consistency, code resembles PNFMain by Diana Tetelman
 *  where possible.
 *
 *  @author Luiza da Silva
 */

public class OOMain {
    //class instance variables
    private static Vector inFiles = null;
    private static String noiseFile = null;
    
    /**
     * Default Constructor.
     */
    OOMain ()
    {
        //Initializes vector that will contain input file names, and the
        //one that will contain the noise file names
        inFiles = new Vector();
        noiseFile = new String();
    }
    
    /**
     * Main method of the Object-Oriented implementation of the KWIC project.
     *
     * @param args[]  command line parameters
     * @exception KWICException exception class of the KWIC system.
     */
    
    public static void main (String[] args) throws KWICException
    {
        //Instantiates OOMain class.
        OOMain main = new OOMain();
    
     //************ Input *************//
     
      //command line parsing and usage clause
        int optind; 
        if (args.length < 1)
        {
            System.out.println("Usage: java OOMain [-n noisefile] [infile1] [infile2] ... [infilen]");
            System.exit(1);
        }
        else
        {
	    boolean noise = false;
            noiseFile = "noiseWords";
            
            for (optind=0; optind < args.length; optind++)
            {
                if (args[optind].equalsIgnoreCase("-n"))
                {
                    noise = true;
                    continue;
                }
                if (noise == false)
                    inFiles.add(args[optind]);
                else
		{
                    noiseFile = args[optind];
		    noise = false;
		}
		
            }
        }
        
	OOInput inNoise = new OOInput(noiseFile);
	Vector noiseWords = new Vector();
	String line = inNoise.readLine();
	while (line != null) {
	    noiseWords.addElement(line);
	    line = inNoise.readLine();
	}
	
        try
        {
            SentenceCollection data = new SentenceCollection();
            SentenceCollection shifteddata;
            
            String temp;
            OOInput in = new OOInput(inFiles);
	    data = in.readSentenceCollection();
            
       //*********** Shifting **************//
            //Instantiates OOShifter class
            OOShifter shift = new OOShifter();
            
            shifteddata = shift.shiftSentenceCollection(data);
            
     //********* Sorting ************//
            
           //Instantiates OOSorter class
            OOSorter sort = new OOSorter();
            
            //Invokes sorting method from OOSorter class
            sort.sortData(shifteddata);
            
            
     //********* Output *************//
	    shifteddata.setNoiseWords(noiseWords.toArray());

            //Instantiates OOOutput class
	    OOOutput out = new OOOutput();
            
            //Invokes output method
	    out.printData(shifteddata);
        }
        catch (KWICException ke) {
	    System.err.println (ke.getMessage());
	}
    }
} // end of class OOMain
