/*
 *  Team 1
 *  CS575: Software Design
 *  Project Phase I
 *  Object-Oriented style
 *  OOInput.java
 */

import java.io.*;
import java.util.StringTokenizer;
import java.util.Vector;

/**
 *  <p>Input class for the Object Oriented KWIC system.</p>
 *
 *  <p>Module should be able to read information from the appropriate
 *  source.
 *  <br>For consistency, code resembles PNFInput by Diana Tetelman
 *  where possible.
 *
 *  @author Erik Hayes
 */

public class OOInput {
    private BufferedReader in;
    private Vector inputFiles;
    
    /**
     * <p> <b>Test Driver</b></p>
     * <p> The correct output of it should be the contents of the files KWICInput.txt
     * and KWICInput2.txt.  If the contents of KWICInput.txt have not been changed, 
     * then the output should resemble the following:</p>
     * 
     *       <br>The cat is in the hat
     *       <br>This is an input file
     *       <br>The cat is in the hat
     *       <br>This is an input file
     *
     */
    //Note that this function is for testing only and does not catch thrown exceptions
    public static void main(String[] args) throws KWICException {
	Vector files = new Vector();
	files.add(new String("KWICInput.txt"));
	files.add(new String("KWICInput2.txt"));
        OOInput input = new OOInput(files);
	String temp;
	do {
	    temp = input.readLine();
	    if (temp != null) {
		System.out.println(temp);
	    }
	} while(temp != null);
    }

    /**
     * <p> Default Constructor: creates object ready to get input from some yet unspecified source.
     */
    public OOInput() {
	inputFiles = new Vector();
    }

    /**
     * <p> Constructor that allows for the specification of a source file on instantiation.
     * Use of this constructor eliminates the need for the open function.
     *
     * @params     filename       String which contains the name of the file to be parsed
     * @exception  KWICException  thrown if the file cannot be found
     */
    public OOInput(String filename) throws KWICException {
	inputFiles = new Vector();
	inputFiles.add(filename);
	this.open(inputFiles);
    }

    /**
     * <p> Constructor that allows for the specification of multiple source files on instantiation.
     * Use of this constructor eliminates the need for the open function.
     *
     * @params     filenames      Vector of strings which contain the names of the files to be parsed
     * @exception  KWICException  thrown if the file cannot be found
     */
    public OOInput(Vector filenames) throws KWICException {
	inputFiles = new Vector();
	inputFiles = (Vector)filenames.clone();
	this.open(inputFiles);
    }
    
    /**
     * <p> This method will open an file for the specified information source.
     * This method name may later be overloaded for different sources of input.
     *
     * @params     filenames      Vector of strings which contain the names of the files to be parsed
     * @exception  KWICException  thrown if the file cannot be found
     */
    public void open(Vector filenames) throws KWICException {
	try {
	    in = new BufferedReader(new FileReader((String)filenames.elementAt(0)));
	    filenames.remove(0);
	} catch(FileNotFoundException e) {
	    e.printStackTrace();
	    throw new KWICException((String)filenames.elementAt(0)+" not found!");
	}
    }

    /**
     * <p> This method will read one line from the file the object was initialized with.
     * 
     * @return                String containing next line from source or null if end of input is reached
     */
    public String readLine() throws KWICException {
	try {
	    String temp = in.readLine();
	    if ((temp == null) && (!(inputFiles.isEmpty()))) {
		this.open(inputFiles);
		temp = in.readLine();
	    }
	    return temp;
	} catch(IOException e) {
	    e.printStackTrace();
	    throw new KWICException("Input readLine error!");
	}
    }

    /**
     * <p> Performs reading from all specified sources and places data into
     * a SentenceCollection object.
     *
     * @return            SentenceCollection containing all of the input data
     */
    public SentenceCollection readSentenceCollection() throws KWICException {
	String tempLine;
	SentenceCollection data = new SentenceCollection();
	do {
	    Vector words = new Vector();
	    tempLine = this.readLine();
	    if (tempLine != null) {
		StringTokenizer st = new StringTokenizer(tempLine);
		while (st.hasMoreTokens())
		    words.addElement(st.nextToken());
		data.addKWICRow(words.toArray());
	    }
	} while (tempLine!=null);
	return data;
    }

    /**
     * <p> This is simply a close on the input source.
     *
     * @exception    KWICExcetption   thrown if there is an error closing the source
     */
    public void close() throws KWICException {
	try {
	    in.close();
	} catch(IOException e) {
	    e.printStackTrace();
	    throw new KWICException("Input error closing source!");
	}
    }
    
}




