/*
 *  Team 1
 *  CS575: Software Design
 *  Project Phase I
 *  All styles
 *  SentenceCollection.java
 */

import java.util.Vector;

/**
 *  <p>This is the virtual machine wrapper for the ObjectCollection object for the KWIC system.</p>
 *
 *  <p>This class is used to tailor the behavior of the ObjectCollection class to the
 * needs of the KWIC system.  This includes converting the objects to strings and also filtering 
 * the collection as it appears to its users when needed. 
 *
 *  @author Diana Tetelman
 */

public class SentenceCollection extends ObjectCollection
{
    private String[] noiseWords;
    
    private String[] nextRow;

    /**
     * Default Constructor.  The filter words list will be initialized as empty therefore, no
     * filtering will be performed.
     */
    public SentenceCollection()
    { 
        super();
        noiseWords = new String[] {};
    }
    
    /**
     * Constructor to be used when it is desired to filter the words of the collection
     *
     * @param   _noiseWords     Object array containing strings of all the words
     * statring with which sentences are to be filtered out
     */
    public SentenceCollection(Object[] _noiseWords)
    {
		noiseWords = new String[_noiseWords.length];
        String[] temp = toString(_noiseWords);
        try{
            for(int i = 0; i<temp.length; i++)
                noiseWords[i] = temp[i];        
        }
        catch( Exception e )
        {
            e.printStackTrace();
        }
    }
    
    public void setNoiseWords(Object[] _noiseWords)
    {   
		noiseWords = new String[_noiseWords.length];
        try{
            for(int i = 0; i<_noiseWords.length; i++)
                noiseWords[i] = _noiseWords[i].toString();        
        }
        catch( Exception e )
        {
            e.printStackTrace();
        }
    }        
    
//--------------------------------------------------------------------------

    /**
     * must be called only after startKWICRowIterator,
     * retruns the next object in the list
     * if no more objects in the list throws KWICException
     */
    public Object[] getNextKWICRow() throws KWICException
    {
        if( nextRow != null )
            return (Object[])(nextRow);
        
        boolean ignore = false;
        
        String[] sentence = toString(super.getNextKWICRow());
        // compare the first word of the sentence with every word in the filter list
        do{
            if( shouldIgnore(sentence[0]) )
            {
                // if found change ignore to true and get the next word
                ignore = true; 
                if( super.hasNextKWICRow() )
                    sentence = toString(super.getNextKWICRow());
                else
                    throw new KWICException("No more objects in the collection!");                
            }                    
        }
        while( ignore == true );
        
        return (Object[])(sentence);
    }
    
    /**
     * can only be called after getFirstKWICRow or getNextKWICRow
     * returns true if there are more objects in the list
     * false if the list is done
     */
    public boolean hasNextKWICRow()
    {
        try{
            nextRow = null;
            boolean ignore = true;

            while( ignore && super.hasNextKWICRow() )
            {            
                nextRow = toString(super.getNextKWICRow());
                if( !shouldIgnore(nextRow[0]) )
                    return true;
            }
        }
        catch( KWICException e )
        {
            e.printStackTrace();
        }
        
        // if no ignore this one, store it in the temp nextKWICRow object 
        nextRow = null;
        return false;
    }

    private boolean shouldIgnore(String word)
    {
        for( int i = 0; i<noiseWords.length; i++)
            if( word.compareToIgnoreCase(noiseWords[i]) == 0)
            {
                // if found change ignore to true and get the next word
                return true; 
            }        
        return false;
    }

//--------------------------------------------------------------------------
    
    /**
     * Converts the Object array of Strings to a String array
     *
     * @param   sentence    Object array that contains Strings
     * @return  String[]    String array containing all of the words from the Object array
     */
    public String[] toString(Object[] sentence)
    {
        String[] temp = new String[sentence.length];
        for( int i = 0; i < sentence.length; i++ )
            temp[i] = sentence[i].toString();
        
        return temp;
    }
    
    /**
     * Method for comparison of 2 sentences
     *
     * @param   first       Object array with all the words in the first sentence to be compared
     * @param   second      Object array with all the words in the second sentence to be compared
     *
     * @return true     when the first words is greater than the second word
     * @return false    when the first word is less than or equal to the second word
     */
    public boolean isGreaterThan(Object[] _first, Object[] _second)
    {
       boolean flag = false;
       String[] first = toString(_first);
       String[] second = toString(_second);
       
       int minLength = Math.min(first.length, second.length);

       for (int i=0; i<minLength && flag==false; i++) {
	   if( (first[i]).compareToIgnoreCase(second[i]) == 0 )
           {
               flag = false;
               continue;
           }

           if( (first[i]).compareToIgnoreCase(second[i]) > 0 )
               return true;
           else
               return false;           
       }
       // if the second one is longer than the first, it means that it is greater
       if( ! flag && second.length == minLength )
           return false;
       else if( ! flag && first.length == second.length )
           return false;
       else
           return true;
    } 
}
