/*
 * Team 1
 * CS575: Software Design
 * All styles
 * KWICRow.java
 *
 * Created on October 22, 2001, 1:36 PM
 */

import java.util.Vector;

/**
 * <p>This is the bottom layer of the data structure used to store KWIC system information.
 * It is responsible for keeping track of a single row/line.
 *
 * @author  Dina
 * @version 
 */
public class KWICRow {

    Vector KWICObjectVector;

    /** Creates new KWICRow */
    public KWICRow() {
        KWICObjectVector = new Vector(); 
    }
    
    /**
     * Returns true if this KWICRow contains no elements. 
     */
    public boolean isEmpty() 
    {
        if( KWICObjectVector.size() > 0 )
            return false;
        else
            return true;
    }

    /**
     * Removes the object at the index location
     * throws KWICException if index out of bounds
     */
    public boolean removeKWICObjectAt(int wIndex) throws KWICException
    {
        if( wIndex > -1 && wIndex < KWICObjectVector.size() )
        {
            KWICObjectVector.removeElementAt(wIndex);
            return true;
        }
        
        throw new KWICException("Index out of bounds in removeKWICObjectAt!");
    }        
    
    /**
     * returns the number of objects currently in the KWICRow
     */
    public int size()
    {
        return KWICObjectVector.size();
    }
    
    /** 
     * returns an object from the list at the specified index
     * if index is improper, 
     */
    public Object getKWICObjectAt(int wIndex) throws KWICException
    {
        if( wIndex >= 0 && wIndex < KWICObjectVector.size() )
        {
            return KWICObjectVector.elementAt(wIndex);
        }
        
        throw new KWICException("Array Index out of Bounds in getKWICObjectAt");
    } 

    /**
     * Inserts the given KWICObject at the end of the specified KWICRow
     * Parameters:
     * KWICObject - object to be inserted
     */
    public void addKWICObject(Object KWICObject) throws KWICException
    {
        try{
            KWICObjectVector.addElement(KWICObject);
        }
        catch( Exception e ){ 
            throw new KWICException("Problem occured during addKWICObject!");
        }
    }   
    
    /**
     * adds the KWICObject object at the specified location
     * if problem occurs KWICException will be thrown
     */
    public void addKWICObjectAt(int index, Object KWICObject) throws KWICException
    {
        if( index > -1 && index <= KWICObjectVector.size() )
            KWICObjectVector.add(index, KWICObject);
    
        throw new KWICException("KWICObject index out of bounds in addKWICObjectAt!");
    }

    
    /**
     * Parameters: 
     * wIndex - KWICObject to return index
     * returns true if removed ok, otherwise KWIC Exception is thrown
     */
    public boolean removeKWICObject(int wIndex) throws KWICException
    { 
        if( wIndex >= 0 && wIndex < KWICObjectVector.size() )            
        {
            try {
                KWICObjectVector.removeElementAt(wIndex);
                return true;
            }
            catch( Exception e ){}
        }
        
        throw new KWICException("Problem in removeKWICObject!");
    }        
    
    /**
     * Removes all the KWICObjects in the KWICRow
     * returns true if removed successfully, throws KWICException if not.
     */
    public boolean removeAllKWICObjects() throws KWICException
    {
        try{
            KWICObjectVector.removeAllElements();
            return true;
        }
        catch( Exception e )
        {
            throw new KWICException("Problem in removeAllKWICObjects!");
        }
    }
    
}
