/*
 *  Team 1
 *  CS575: Software Design
 *  Project Phase II
 *  Implicit Invocation style
 *  KWICListener.java
 */

/**
 *  <p>KWICListener interface for the Imlicit Invocation KWIC system.
 *
 *  <p>This interface simply contains 2 methods that each KWICListener
 *  must implement.  The first is eventArrived, which will be used by the
 *  broadcaster to post messages to the listeners.  The sencond is getName
 *  which will be used by the broadcaster to see who is sending the message.  
 *  </p>
 *
 *  <p>The KWICListeners must be registered by a third party class by calling the
 *  addListener method; the broadcaster cannot register them on its own.
 *  </p>
 *
 *  <p>First, the constructor of the class must be called.  After that, the class will 
 *  simply wait for messages to come in to its eventBroadcast() method.  These events
 *  will then be reported to all the listeners on the list.  
 *  </p>
 *
 *  @author Diana Tetelman
 */
public interface KWICListener
{
    /**
     * Gets called by a broadcaster when an event is broadcasted
     * @param   KWICEvent   event broadcasted
     */
    public void eventArrived(KWICEvent event);

    /**
     * Should return name of class or module listener represents or belongs to
     * @return   String   the name in String format
     */
	public String getName();
}
