/*
 *  Team 1
 *  CS575: Software Design
 *  Project Phase II
 *  Implicit Invocation style
 *  KWICEvent.java
 */

/**
 *  <p>KWICEvent class for the Imlicit Invocation KWIC system.
 *
 *  <p>This class represents an event that is communicated within the system
 *  using the KWICBroadcaster and KWICListeners framework.    
 *  </p>
 *
 *  <p>The KWICListeners must create the events and fill them with the appropriate 
 *  information.  Then they are to post those events to the broadcaster they are 
 *  given.  The broadcaster will then pass those created events to all other listeners
 *  who will pull out the appropriate iformation that is of interest to them from the event. 
 *  </p>
 *
 *  <p>The constructor of the class must be called with all the information.  
 *  It must have the event source, which means the name of the listener that created it.
 *  It must have the event type, which must be selected from one of the constants defined 
 *  for this class. Also, it must have the even pay load, which is any data or information 
 *  that is to be passed with that event.  
 *  </p>
 * 
 *  <p>To add new event types to the framework, you must simply add a new constant to the list.
 *  </p>
 *
 *  @author Diana Tetelman
 */

public class KWICEvent
{	
    /**
     * list of currently available event types
     */
    static final int    SENTENCE_INPUTED = 0;
    static final int    SENTENCE_SHIFTED = 1;
    static final int    INPUT_DONE = 2;
    static final int    SHIFTER_DONE = 3;
    static final int    SORTER_DONE = 4;
    static final int    OUTPUT_DONE = 5;
    static final int    INPUT_DATA = 6;
    static final int    EXCEPTION = 7;
	static final int	INPUT_NOISE = 8;
	static final int	SET_NOISE = 9;
	static final int	INPUT_NOISE_DONE = 10;
      
    /**
     * contains the event type
     */
    private int type;
	
    /**
     * contains the payLoad of the event
     */
    private Object payLoad;
	
    /**
     * contains the name of the class or module that created the event
     */
    private String source;

    /**
     * Constructor
     * 
     * @param _source	name of module or class that created the event
     * @param _type		event type, must be one the types in the list
     * @param _payLoad	Object reference to the contents of the event 
     */
    public KWICEvent(String _source, int _type, Object _payLoad)
    {
		type = _type;
		payLoad = _payLoad;
		source = _source;
    }

    /**
     * accessor method for the source variable 
     */
    public String getSource() { return source; }

    /**
     * accessor method for the event type variable 
     */
	public int getEventType() { return type; }
	
    /**
     * accessor method for the event pay load variable 
     */
    public Object getPayLoad() { return payLoad; }
}
