/*
 *  Team 1
 *  CS575: Software Design
 *  Project Phase II
 *  Implicit Invocation style
 *  IIOuput.java
 */

import java.io.*;
import java.util.Vector;

/**
 *  <p>Output class for the Implicit Invocation KWIC system.</p>
 *
 *  <p>Listens for events that enable it to output data to the standard I/O stream.
 *  Once that event is received, it will output all the data in the given collection.
 *  It will broadcast messages to inform others of the progress it is making.</p>
 *
 *  <p>This class implements the KWICListener interface which enables it to 
 *  receive message sent by a KWICBroadcaster it is registered with. The class must 
 *  registered by a third party class; it cannot register on its own.
 *  </p>
 *
 *  <p>First, the constructor of the class must be called.  After that, the class will 
 *  simply wait for message to come in to its eventArrived() method.  These events
 *  will indicate what the class should do.  Those events that are not of importance to 
 *  this class will simply be ignored by the event handling processing of this class.
 *  </p>
 *
 *  <p>This class is capable of performing the following function.  It can traverse 
 *  a data collection and output the data in to the standard I/O stream.  
 *  The format of the output is assumed to be of the following 
 *  nature: single sentence per line.  This functionality will be invoked when a message is
 *  received with a collection to be outputed. 
 *  </p> 
 *  @author Luiza da Silva
 */

public class IIOutput implements KWICListener
{    
    /**
     * KWICBroadcaster object which allows this module to interact with the 
     * rest of the system
     */
    KWICBroadcaster broadcaster;
    
    /**
     * SentenceCollection object that is maintained by this class.
     */
    SentenceCollection collection;
    
    /**
     * Default Constructor
     */
    public IIOutput(KWICBroadcaster _broadcaster) 
    {
        broadcaster = _broadcaster;
    }

    /**
     * Implements the KWICListener interface method.  This method will receive events and 
     * process them accordingly base on their content.
     * @param   event       KWICEvent which has been broadcasted
     */
    public void eventArrived(KWICEvent event) 
    {
        try{
            if( event.getEventType() == KWICEvent.SORTER_DONE )
            {
                collection = (SentenceCollection)(event.getPayLoad());
                output();
            }
        }
        catch( KWICException e )
        {
            broadcaster.eventBroadcast(new KWICEvent(
                        "Output",
                        KWICEvent.EXCEPTION,
                        new Object()));
        }
    }    

    /**
     * This method will output the received collection
     */ 
    public void output() throws KWICException
    {
         try 
        {
            collection.startKWICRowIterator();
            while( collection.hasNextKWICRow() == true )
            {
                Object[] temp = collection.getNextKWICRow();
                int count = temp.length;
                for( int i=0; i<count; i++ )
                {
                        System.out.print(temp[i].toString() + " ");
                }
                System.out.println();
            }
        }            
        catch( Exception e )
        {
            throw new KWICException(e.toString());
        }
    
        broadcaster.eventBroadcast(new KWICEvent(
            "Output",
            KWICEvent.OUTPUT_DONE,
            new Object()));
    }
    
    /** 
     * Returns the name of the class.  Used for broadcasting purposes.
     * @return  "Output"
     */
    public String getName() 
    {
        return "Output";
    }    
}