;; Xuan Thuy Tran

;; GAME Initialize - This function is called by Mike's Java code.      
(defun setup-session (?numgames ?numagents)
  (setf *print-right-margin* 1000)
  (defparameter *max-numagents*               6) 


 ;; (with-open-file (s "GameHistory.text" 
;;		     :direction :input :if-does-not-exist :error)
;;		  (read s t nil t)
 ;;		  (truename s))

  ;; make sure ?numagent are not more than *max-numagents*
  (cond 
   ;; if numagents is greater than *max-numagents*
   ((> ?numagents *max-numagents*) (format t "~%COMMAND:too-many-agents:END~%"))
   (t              
    (defparameter *numagents*       ?numagents)                       
    (defparameter *numgames*        ?numgames)
    (defparameter *current-game*    0)
    (init-history)
    (io-start-game))
   )
  )

;; Tell the engine to start the new game.
(defun io-start-game ()
  (setf *current-game* (1+ *current-game*))
  (format t "~%currentgame = ~d~%" *current-game*)  
  (update-history)
  (format t "~%COMMAND:IO:REFEREE:(io-start-game ~d '~s):END~%" *numagents* nil)
  )

;; Get move from referee and put it in the GameHistory.
(defun write-move (?agent ?move) 
  
  (with-open-file (s "GameHistory.text" 
		     :direction :output :if-exists :append :if-does-not-exist :error)
		  (format s "~&~s ~s~%" ?agent ?move)
 		  (truename s))
  )

;; Get the standings from Referee and put it in the GameHistory.
(defun end-of-game (?standings)
  (format t "~%entersendendgame ~%") 
  (with-open-file (s "GameHistory.text" 
		     :direction :output :if-exists :append :if-does-not-exist :error)
		  (format s "-----------------------~%")
		  (loop for c from 0 to (1- (length ?standings))
			while c
			do (format s "~&~d th place: ~s ~%" (1+ c) (nth c ?standings) )
			)
		  (truename s))
  (if (< *current-game* *numgames*) (io-start-game) (end-of-session))
  )

;; Update History, write history header for every game.
(defun update-history ()
(format t "~%enterupdatehistory~%") 
  (with-open-file (s "GameHistory.text" 
		     :direction :output :if-exists :append :if-does-not-exist :error)
		  (format s "~&~2%Game#~d ~2%Game History:~%" *current-game*)
		  (truename s))
  )

(defun init-history ()
(format t "~%enterinithistory~%") 
  (with-open-file (s "GameHistory.text" 
		     :direction :output :if-exists :supersede :if-does-not-exist :create)
		  (format s "~&GAME HISTORY FOR ACQUIRE SESSION~%")
		  (truename s))
  )

;; DISCONNECTION
;; Send message to Mike for end of session
(defun end-of-session ()
  (format t "~%COMMAND:END~%")  
  )