/*
  UserController.java
  - The program which runs the user controller.
  3 May 2001
  Programmer: Michael Czajkowski
*/

// Package

// Imports

// <UserController>

public class UserController{

    // ------ Private Data Fields ------

    // ------ Constructors ------

    public UserController(){
	// PRE: Takes nothing.
	// POST: Returns type UserController.

    } // UserController

    // ------ Public Methods ------

    // ------ Protected Methods ------

    // ------ Private Methods ------

    // ------ Public Static Void Main ------

    public static void main(String args[]){
	// PRE: Takes (String[]:+
	/*
	   args[0] - The DNS name of the game server.
	   args[1] - The port of the game server.
	   args[2] - Number of Agents.
	   args[3] - Number of Games.
	   args[4] - The location of LISP on the machine.
	*/
	// POST: Returns nothing.

	int gameport = 0;
	int agents = 6;
	int games = 1;

	try{
	    Integer gp = new Integer(args[1]);
	    gameport = gp.intValue();
	    Integer ag = new Integer(args[2]);
	    agents = ag.intValue();
	    Integer ga = new Integer(args[3]);
	    games = ga.intValue();
	} // try
	catch(NumberFormatException e){
	    // Input of a wrong number.	    
	    System.err.println("Error. Invalid port as input. This error is terminal :: "+e);
	    System.exit(1);
	} // catch

	// Make a user controller connector with the above info.

	UserControllerConnector uc = new UserControllerConnector(args[0],gameport,agents,games,args[4]);
	
	// uc.sendCommandToGameServer("HI GAME SERVER, ITS THE USER CLIENT!");

	try{Thread.sleep(20000000);}catch(Exception e){}
	uc.killUserControllerConnection();
	
	System.out.println("UserController is Done.");

    } // public static void main

    // ------ Test Method ------

    public void test(){
	// PRE: Takes nothing.
	// POST: Returns nothing.
	
	// Description:
	// This method outputs information about itself to System.out.

	System.out.println("Testing method of class: "+toString());
    
    } // test()

} // class UserController



