/*
  SocketHandler.java
  - A thread which handles input from a socket.
  28 April 2001
  Programmer: Michael Czajkowski
*/

// Package

// Imports

import java.io.*;
import java.net.*;

// <SocketHandler>

public class SocketHandler extends Thread{

    // ------ Private Data Fields ------

    private Socket socket_;
    private Connector connector_;
    private BufferedReader net_input_stream_;
    private BufferedWriter net_output_stream_;
    private boolean listening_;
    private String connector_type_;

    // ------ Constructors ------

    public SocketHandler(Socket SOCKET, Connector CONNECTOR, BufferedReader READER, BufferedWriter WRITER, String CONNECTORTYPE){
	// PRE: Takes (java.net.Socket:+), 
	//  (Connector:+),(java.io.BufferedReader:+),
	//  (java.io.BufferedWriter:+),
	//  (String:+("USER CONTROLLER"||"PRIVATE SERVER"||
	//       "GAME SERVER"||AGENTHOSTNAME))
	// POST: Returns type SocketHandler.
	
	socket_ = SOCKET;
	connector_ = CONNECTOR;
	net_input_stream_ = READER;
	net_output_stream_ = WRITER;
	connector_type_ = CONNECTORTYPE;

	listening_ = false;

    } // SocketHandler

    // ------ Public Methods ------

    public synchronized void sendCommand(String COMMAND){
	// PRE: Takes (String:+)
	// POST: Returns nothing.

	// Sends COMMAND to the Socket's other end. We have
	// to then send a new line accross the socket too.

	try{
	    net_output_stream_.write(COMMAND,0,COMMAND.length());
	    net_output_stream_.newLine();
	    net_output_stream_.flush();
	} // try
	catch(Exception e){
	    // Error sending the line.
	    System.err.println("Error sending line: "+COMMAND+" to Socket :: "+e);
	} // catch

    } // sendCommand(String)

    public String getConnectionType(){
	// PRE: Takes nothing.
	// POST: Returns (String:+)
	
	return connector_type_;

    } // getConnectionType()

    public void run(){
	// PRE: Takes nothing.
	// POST: Returns nothing.
	
	String line = "";
	listening_ = true;

	while(listening_){
	    // Pull a line off of the network.
	    try{
		line = net_input_stream_.readLine();
		if(line.equals(null) || line.equals("")){
		    // Don't do anything.
		} // if
		else{
		    // Do something.
		    connector_.handleNetCommand(this,line);
		} // else
	    } // try
	    catch(Exception e){
		// Error reading the line.
		System.err.println("Error. Cannot read from Net Socket :: "+e);
		listening_ = false;
	    } // catch
	} // while

    } // run

    public void killSocketHandler(){
	// PRE: Takes nothing.
	// POST: Returns nothing.
	
	// This method ends the thread by making listening_ go
	// to false. This way there is no more socket listening at all.

	listening_ = false;

	// Kill the socket.
       
	try{
	    socket_.close();
	} // try
	catch(Exception e){
	    // Any problem closing socket.
	    System.err.println("Error. Could not close socket :: "+e);
	} // catch

	// We will then kill the two streams which read and write
	// to the net socket.

	try{
	    net_input_stream_.close();
	    net_output_stream_.close();
	} // try
	catch(IOException e){
	    System.err.println("Error. Cannot close Socket streams :: "+e);
	} // catch

    } // killSocketHandler;

    // ------ Protected Methods ------

    // ------ Private Methods ------

    // ------ Public Static Void Main ------

    // ------ Test Method ------

    public void test(){
	// PRE: Takes nothing.
	// POST: Returns nothing.
	
	// Description:
	// This method outputs information about itself to System.out.

	System.out.println("Testing method of class: "+toString());
    
    } // test()

} // class xxx



