/*
  ServerSocketHandler.java
  - An object which controls connections to the server.
  200x
  Programmer: Michael Czajkowski
*/

// Package

// Imports

import java.net.*;
import java.io.*;

// <ServerSocketHandler>

public class ServerSocketHandler extends Thread{

    // ------ Private Data Fields ------

    private ServerSocket socket_;
    private ServerConnector connector_;
    private boolean listening_;      // Are we listening for connections?

    // ------ Constructors ------

    public ServerSocketHandler(ServerSocket SOCKET, ServerConnector CONNECTOR){
	// PRE: Takes (java.net.ServerSocket:+),(ServerConnector:+)
	// POST: Returns type ServerSocketHandler

	socket_ = SOCKET;
	connector_ = CONNECTOR;

	listening_ = false; 

    } // ServerSocketHandler

    // ------ Public Methods ------

    public void run(){
	// PRE: Takes nothing.
	// POST Returns nothing.

	// Run this thread in a while loop looking for connections.

	listening_ = true;

	while(listening_){

	    try{
		Socket connection = socket_.accept();
		connector_.handleNewConnection(connection);
	    } // try
	    catch(IOException e){
		// Could not accept connections, major issue.
		System.err.println("Error. Could not accept connections on the server. This error is Terminal. :: " +e);
	    } // catch

	} // while

    } // run

    public void killServerSocketHandler(){
	// PRE: Takes nothing.
	// POST: Returns nothing.
	
	// This method ends the thread by making listening_ go
	// to false. This way there is no more socket listening at all.

	listening_ = false;

    } // killSocketHandler;

    // ------ Protected Methods ------

    // ------ Private Methods ------

    // ------ Public Static Void Main ------

    // ------ Test Method ------

    public void test(){
	// PRE: Takes nothing.
	// POST: Returns nothing.
	
	// Description:
	// This method outputs information about itself to System.out.

	System.out.println("Testing method of class: "+toString());
    
    } // test()

} // class xxx





