/*
	LocalSystem.java
	- This function runs a local version of the system on one output.
	18 May 2001
	Michael Czajkowski
*/

// ------- Package --------

// ------- Imports --------

import java.util.Vector;

// ------- <LocalSystem> --------

public class LocalSystem{

    // ------- Class Variables: -------

    // ------- Class Constructors: -------

    // ------- Class Public Methods: -------

    public static void main(String args[]){
	// PRE: Takes (String[]:+) which is:
	//  args 0 - the local machine name.
	//  args 1 - starting port range number.
	//  args 2 - server's lisp
	//  args 3 - agent's lisp
	//  args 4 - user controllers's lisp
	//  args 5 - number of agents.
	//  args 6 - number of games.
	// POST: Returns nothing.

	// We first convert any strings to integers. These are
	// args 1, 5, 6.

	Integer port,agents,games;
	int p,a,g;

	p = 8888;
	a = 2;
	g = 1;

	try{
	    port = new Integer(args[1]);
	    agents = new Integer(args[5]);
	    games = new Integer(args[6]);
	    
	    p = port.intValue();
	    a = agents.intValue();
	    g = games.intValue();
	} // try
	catch(NumberFormatException e){
	    // Means user put in a non int for these values.
	    System.err.println("Error. You put a non-integer in for a parameter that requires an integer :: "+e);
	    System.exit(1);
	} // catch
	
	// Now take these values and we will make a series of
	// processes. Agent processes have to be put in a vector.

	LocalProcessHandler gs,ps,uc;
	Process gameserver,privateserver,usercontroller;
	Vector agentprocesses = new Vector();
	Vector agentprocesshandlers = new Vector();

	try{
	    // Begin by setting up the servers.
	    System.out.println("Executing: java -classpath . Server "+args[0]+" "+p+" "+args[2]);
	    gameserver = Runtime.getRuntime().exec("java -classpath . Server "+args[0]+" "+p+" "+args[2]);
	    System.out.println("Game Server set up.");
	    gs = new LocalProcessHandler(gameserver);
	    gs.start();

	    p++;  // The next number is the player engine's port.
	    
	    System.out.println("Executing: java -classpath . Server "+args[0]+" "+p+" "+args[2]);
	    privateserver = Runtime.getRuntime().exec("java -classpath . Server "+args[0]+" "+p+" "+args[2]);	   
	    System.out.println("Player Server set up.");
	    ps = new LocalProcessHandler(privateserver);
	    ps.start();

	} // try
	catch(Exception e){
	    // Problem making server.
	    gameserver = null;
	    privateserver = null;
	    System.err.println("Error. Problem in making server :: "+e);
	    System.exit(1);
	} // catch

	try{
	    // First wait 3 seconds for the servers to start.

	    Thread.sleep(3000);

	    // Now go for the user controller.
	    System.out.println("Executing: java -classpath . UserController "+args[0]+" "+(p-1)+" "+a+" "+g+" "+args[4]);
	    usercontroller = Runtime.getRuntime().exec("java -classpath . UserController "+args[0]+" "+(p-1)+" "+a+" "+g+" "+args[4]);	    
	    System.out.println("IO set up.");

	    uc = new LocalProcessHandler(usercontroller);
	    uc.start();

	} // try 
	catch(Exception e){
	    // Problem with making controller.
	    usercontroller = null;
	    System.err.println("Error. Problem with making user controller :: "+e);
	    System.exit(1);
	} // catch

	try{
	    // Now wait 3 seconds for the servers to start.

	    Thread.sleep(3000);

	    // Now go for the agents.
	    for(int i=0;i<a;i++){
		// Make agents one by one.
		System.out.println("Executing: java -classpath . Agent "+args[0]+" "+p+" "+args[0]+" "+(p-1)+" "+args[3]);
		Process pr = Runtime.getRuntime().exec("java -classpath . Agent "+args[0]+" "+p+" "+args[0]+" "+(p-1)+" "+args[3]);
		System.out.println("Agent set up.");
		agentprocesses.addElement(pr);
		
		LocalProcessHandler lp = new LocalProcessHandler(pr);
		lp.start();
		agentprocesshandlers.addElement(lp);

		Thread.sleep(1000);
	    } // for

	// Now we just let them run their course.
	// Just wait on the user controller process. When it dies the system
	// is done :-)

	    usercontroller.waitFor();
	    
	} // try	
	catch(Exception e){
	    // Problem with any agent.
	    System.err.println("Error. Problem with making agent :: "+e);
	    System.exit(1);
	} // catch

	System.out.println("The System is Done. Results are in GameHistory.txt");
	// Kill all processes manually.

	usercontroller.destroy();
	gameserver.destroy();
	privateserver.destroy();

	for(int i=0;i<agentprocesses.size();i++){
	    Process deadman = (Process)agentprocesses.elementAt(i);
	    deadman.destroy();
	} // for

	// Die.

	System.exit(0);

    } // main
	
    // ------- Class Protected Methods: -------

    // ------- Class Private Methods: -------

} // LocalSystem

