/*
	LocalProcessHandler.java
	- Handles a local process on this machine.
	19 May 2001
	Michael Czajkowski
*/

// ------- Package --------

// ------- Imports --------

import java.io.*;

// ------- <LocalProcessHandler.java> --------

public class LocalProcessHandler extends Thread{

    // ------- Class Variables: -------

    private BufferedReader input_stream_;
    private BufferedWriter output_stream_;

    private Process this_process_;

    // ------- Class Constructors: -------

    public LocalProcessHandler(Process PROCESS){
	// PRE: Takes (Process:+);
	// POST: Returns type LocalProcessHandler.

	// First, gut the process for its input and output streams.

	InputStream i = PROCESS.getInputStream();
	OutputStream o = PROCESS.getOutputStream();

	input_stream_ = new BufferedReader(new InputStreamReader(i));
	output_stream_ = new BufferedWriter(new OutputStreamWriter(o));

	this_process_ = PROCESS;

    } // LocalProcessHandler

    // ------- Class Public Methods: -------
	
    public void run(){
	// PRE: Takes nothing.
	// POST: Returns nothing.

	// This method handles the input stream and will just output
	// what is handed to it.

	String line = "";
	boolean listening_ = true;

	while(listening_){
	    // Pull a line off of the network.
	    try{
		line = input_stream_.readLine();
		if(line.equals(null) || line.equals("")){
		    // Don't do anything.
		} // if
		else{
		    // Do something.
		    if(line.equals("Closing the stream.")||line.equals("Destroying Lisp Process.")||line.equals("Error. Cannot read from Net Socket :: java.lang.NullPointerException")){
			// Kill this process.
			// System.out.println("DESTROYING THE PROCESS");
			this_process_.destroy();
			listening_ = false;
			// System.out.println("PROCESS DEAD, THREAD DONE.");
		    } // if
		    else{
			Character brak = new Character(line.charAt(0));
			if(brak.equals(new Character('M'))){
			    System.out.println(line);
			}
			else{
			    // System.out.println(line);
			}
		    } // else
		} // else
	    } // try
	    catch(Exception e){
		// Error reading the line.
		System.err.println("Error. Cannot read from Process :: "+e);
		listening_ = false;
	    } // catch
	} // while
   
    } // run

    // ------- Class Protected Methods: -------

    // ------- Class Private Methods: -------

}

