/*
  LispWriter.java
  - An object which controls output to Lisp
  28 April, 2001
  Programmer: Michael Czajkowski
*/

// Package

// Imports

import java.io.*;

// <LispWriter>

public class LispWriter{

    // ------ Private Data Fields ------

    private Connector connection_;
    private BufferedWriter lisp_stream_;

    // ------ Constructors ------

    public LispWriter(Connector CONNECTION, BufferedWriter WRITER){
	// PRE: Takes (Connection:+),(java.io.BufferedWriter:+)
	// POST: Returns type LispWriter
	
	connection_ = CONNECTION;
	lisp_stream_ = WRITER;

    } // connection(Connection,BufferedWriter)

    // ------ Public Methods ------

    public void sendCommand(String COMMAND){
	// PRE: Takes (String:+)
	// POST: Returns nothing.

	// Sends the String COMMAND to the stream.

	System.out.println("Sending this command to LISP: " + COMMAND);

	try{
	    lisp_stream_.write(COMMAND,0,COMMAND.length());
	    lisp_stream_.newLine();
	    lisp_stream_.flush();
	} // try
	catch(Exception e){
	    // Some problem sending the command.
	    System.err.println("Error sending command: "+COMMAND+" to lisp :: "+ e);
	} // catch

    } // sendCommand(String)

    // ------ Protected Methods ------

    // ------ Private Methods ------

    // ------ Public Static Void Main ------

    // ------ Test Method ------

    public void test(){
	// PRE: Takes nothing.
	// POST: Returns nothing.
	
	// Description:
	// This method outputs information about itself to System.out.

	System.out.println("Testing method of class: "+toString());
    
    } // test()

} // class LispWriter





