/*
  LispReader.java
  - Reads commands from the Lisp Interpretor and calls
  arguments based on their commands.
  28 April 2001
  Programmer: Michael Czajkowski
*/

// Package

// Imports

import java.io.*;

// <LispReader>

public class LispReader extends Thread{

    // ------ Private Data Fields ------

    private Connector connection_;
    private BufferedReader lisp_stream_;
    private boolean listening_;

    // ------ Constructors ------

    public LispReader(Connector CONNECTION, BufferedReader READER){
	// PRE: Takes (Connection:+),(java.io.BufferedReader:+).
	// POST: Returns type LispReader.

	connection_ = CONNECTION;
	lisp_stream_ = READER;

	listening_ = false;

    } // constructor(Connection,BufferedReader)
       	
    // ------ Public Methods ------

    public void run(){
	// PRE: Takes nothing.
	// POST: Returns nothing.

	// Run in a loop forever.

	String line = "";
	listening_ = true;

	while(listening_){
	    try{
		line = lisp_stream_.readLine();
		if (line.equals(null) || line.equals("")){
		    // Do nothing.
		} // if
		else{
		    // Do something. Handle the LISP command.
		    connection_.handleLispCommand(line);
		} // else
	    } // try
	    catch(Exception e){
		// Some error has occurred reading a line.
		System.out.println("Error reading line from lisp :: "+e);
		e.printStackTrace();
	    } // catch
	
	} // while 

    } // run()

    public void killLispReader(){
	// PRE: Takes nothing.
	// POST: Returns nothing.

	// System.out.println("Setting listen to false.");

	listening_ = false;

	System.out.println("Closing the stream.");

	try{
	    lisp_stream_.close();
	} // try
	catch(Exception e){
	    System.err.println("Error when closing input stream from LISP :: "+e);
	} // catch
	
	System.out.println("Stream closed. Exiting");

    } // killLispReader();

    // ------ Protected Methods ------

    // ------ Private Methods ------

    // ------ Public Static Void Main ------

    // ------ Test Method ------

    public void test(){
	// PRE: Takes nothing.
	// POST: Returns nothing.
	
	// Description:
	// This method outputs information about itself to System.out.

	System.out.println("Testing method of class: "+toString());
    
    } // test()

} // class LispReader



