/*
  AgentConnector.java
  - A connector object for the dignified Agent. :-)
  28 April, 2001
  Programmer: Michael Czajkowski
*/

// Package

// Imports

import java.net.*;
import java.io.*;
import java.util.Vector;

// <AgentConnector>

public class AgentConnector extends Connector{

    // ------ Private Data Fields ------

    private Socket game_socket_ = null;
    private Socket private_socket_ = null;

    private SocketHandler game_socket_handler_ = null;
    private SocketHandler private_socket_handler_ = null;

    // ------ Constructors ------

    public AgentConnector(String LOCALHOST, String GAMEHOST, int LOCALPORT, int GAMEPORT, String LISPLOCATION){
	// PRE: Takes (String:+),(String:+),(int:+),(int:+)
	// POST: Returns type AgentConnector.
	
	super(LISPLOCATION);

	try{
	    // First we make a couple InetAddress to set up the sockets.

	    InetAddress local = InetAddress.getByName(LOCALHOST);
	    InetAddress game = InetAddress.getByName(GAMEHOST);

	    // Now we make the sockets and hope they bind ;-)
	    // System.out.println("Making Socket to game server: "+game.getHostAddress()+" "+game.getHostName()+" at port: "+GAMEPORT);
	    game_socket_ = new Socket(game,GAMEPORT);	    
	    // System.out.println("Making Socket to game server: "+local.getHostAddress()+" "+local.getHostName()+" at port: "+LOCALPORT);
	    private_socket_ = new Socket(local,LOCALPORT);

	} // try
	catch(UnknownHostException e){
	    // Illegal InetAddress;
	    System.err.println("Error. Cannot make connection to address specified. :: "+e);
	} // catch
	catch(ConnectException e){
	    // Had a connection Exception
	    System.err.println("Error. Could not make connection. Localized Message :: "+e.getLocalizedMessage()+" Stack Trace: ");
	    e.printStackTrace(System.err);
	} // catch
	catch(IOException e){
	    // Problem with socket creation.
	    System.err.println("Error. Could not make socket. :: "+e);
	} // catch
	
	// Now make the SocketHandlers for the two connections.
	
	InputStream gamei = null;
	InputStream privatei = null;
	OutputStream gameo = null;
	OutputStream privateo = null;

	try{
	    gamei = game_socket_.getInputStream();
	    gameo = game_socket_.getOutputStream();
	} // try
	catch(Exception e){
	    System.err.println("Error. Problem getting stream from game server socket. Terminal Error :: "+e);
	    System.exit(1);
	} // catch

	BufferedReader BRgamei = new BufferedReader(new InputStreamReader(gamei));
	BufferedWriter BWgameo = new BufferedWriter(new OutputStreamWriter(gameo));
	
        try{
	    privatei = private_socket_.getInputStream();
	    privateo = private_socket_.getOutputStream();
	} // try
	catch(Exception e){
	    System.err.println("Error. Problem getting stream from game server socket. Terminal Error :: "+e);
	    System.exit(1);
	} // catch
	
	BufferedReader BRprivatei = new BufferedReader(new InputStreamReader(privatei));
	BufferedWriter BWprivateo = new BufferedWriter(new OutputStreamWriter(privateo));

	game_socket_handler_ = new SocketHandler(game_socket_,this,BRgamei,BWgameo,"GAME SERVER");
	private_socket_handler_ = new SocketHandler(private_socket_,this,BRprivatei,BWprivateo,
"PRIVATE SERVER");

	// And now start their threads for listening.

	game_socket_handler_.start();
	// private_socket_handler_.start();

	// Send the following commands to lisp

	sendLispCommand("(load \"../agent/agent_2.lisp\")");

	try{
	    Thread.sleep(1000);
	}
	catch(Exception e){}

	// Send the registration request.

	game_socket_handler_.sendCommand("REGISTER_PLAYER");
	private_socket_handler_.sendCommand("REGISTER_PLAYER");

    } // constructor(String,String,int,int);

    // ------ Public Methods ------

    public void sendCommandToGameServer(String COMMAND){
	// PRE: Takes (String:+)
	// POST: Returns nothing.

	// This method is public because in the future a GUI might
	// be built on top of this class to emulate what the Agent sees
	// to its two servers, and allow it to send messages to the servers.

	game_socket_handler_.sendCommand(COMMAND);

    } // sendMessage(String)

    public void sendCommandToPrivateServer(String COMMAND){
	// PRE: Takes (String:+)
	// POST: Returns nothing.

	// This method is public because in the future a GUI might
	// be built on top of this class to emulate what the Agent sees
	// to its two servers, and allow it to send messages to the servers.

	private_socket_handler_.sendCommand(COMMAND);

    } // sendMessage(String)

    public synchronized void handleLispCommand(String COMMAND){
	// PRE: Takes (String:+)
	// POST: Returns nothing.

	// This method is called when LISP has something to tell the
	// network. Of course what lisp outputs might not be information
	// to the network at all, so we have to look at COMMAND and
	// determine what to do from there.

	// System.out.println("Agent's LISP says "+COMMAND);

	// In here we will do the parsing.

	Vector command = parseCommand(COMMAND);

	// Get elements of command.

	String to = (String)command.elementAt(0);
	String from = (String)command.elementAt(1);
	String procedure = (String)command.elementAt(2);

	// Check for validity.

	if(to.equals("INVALID")){
	    // Invalid command. We ignore.
	} // if
	else{
	    // Valid command.

	    // The agent can send to the referee or player's engine.

	    if(to.equals("REFEREE")){
		System.out.println("Sending this command to Game Server: "+COMMAND);
		sendCommandToGameServer(COMMAND);
	    } // if
	    else{
		System.out.println("Sending this command to Game Server: "+COMMAND);
		sendCommandToPrivateServer(COMMAND);
	    } // else

	} // else

    } // handleLispCommand(String)

    public synchronized void handleNetCommand(SocketHandler SOCKET, String COMMAND){
	// PRE: Takes (SocketHandler:+),(String:+).
	// POST: Returns nothing.

	// This method is called whenever the private server or the
	// game server wishes to tell the agent something. Its synchronized
	// since the game server and private server could call the method
	// at the same time. Of course we have to parse the command
	// into something we can send to the LISP process.

	// System.out.println(SOCKET.getConnectionType() + " SAYS TO AGENT:: " + COMMAND);

	// Accept PRE-commands

	if(COMMAND.equals("KILL_EVERYTHING")){
	    killAgentConnection();
	} // if

	// First parse out the command.

	Vector command = parseCommand(COMMAND);

	// Get elements of command.

	String to = (String)command.elementAt(0);
	String from = (String)command.elementAt(1);
	String procedure = (String)command.elementAt(2);

	// System.out.println("MESSAGE CONTENTS: "+to+":"+from+":"+procedure);

	// Check for validity.

	if(to.equals("INVALID")){
	    // Invalid command. We ignore.
	} // if
	else{
	    // Its a valid command string from the network.
	    // We then will send it to the LISP process running here.
	    System.out.println("Message Sent to LISP: "+procedure);
	    sendLispCommand(procedure);
	} // else

    } // handleNetCommand(String,String)
 
    public void killAgentConnection(){
	// PRE: Takes nothing.
	// POST: Returns nothing.

	// To do this, we first call the killLispProcess();
	killLispProcess();
	// Now we take the handlers and kill them too.
	game_socket_handler_.killSocketHandler();
	private_socket_handler_.killSocketHandler();

	System.exit(0);

    } // killAgentConnection()
	
    // ------ Protected Methods ------

    // ------ Private Methods ------

    // ------ Public Static Void Main ------

    // ------ Test Method ------

    public void test(){
	// PRE: Takes nothing.
	// POST: Returns nothing.
	
	// Description:
	// This method outputs information about itself to System.out.

	System.out.println("Testing method of class: "+toString());
    
    } // test()

} // class AgentConnector




