;; tile.lisp
;; This file contains a bunch of functions which deal with tile
;; heuristics on which tile to select to play and which to not.

;; Warning: In order for these functions to work properly,
;; a "rank-tiles" function must exist. This function is 
;; heuristic dependant.

(load "../agent/mdistance.lisp")

;; make-tile-list
;; This function takes the world state and the agent state
;; and it determines which tiles it would like to place in order of
;; 1.) Grow the chain you own first.
;; 2.) Merge the chain you own next.
;; 3.) Make a new chain.
;; 4.) Place a tile closest to the chain you own.
;; The function returns a list, of tiles in the order which
;; reflects this above preference.

(defun make-tile-list (a b)
  ;; PRE: Takes a world state 'a' and an agent state 'b'
  ;; POST: Returns true. Puts a list of the correct tiles
  ;; in the *tile-list* global function.

  (setq tagged-tiles nil
	owned-tiles nil
	ranking-list nil
	return-list nil
	x nil
  )

  (setf owned-tiles (car (cdr b)))

  ;; First, get the tiles tagged.

  (setf tagged-tiles (tile-tagger a owned-tiles))

  ;; Now we have a list of the tagged tiles, we proceed
  ;; by making a ranking list. 

  ;; In this case we are using the general-rank-tiles heuristic.

  (format t "~% Going into ranking-list")

  (setf ranking-list (rank-tiles b tagged-tiles))

  (setf return-list nil)

  (format t "~%The Ranking List is: ~s" ranking-list)

  ;; Now that the list has been made, we go through it and make
  ;; the return list. Start with the 4s.

  (setf x 0)
  (dolist (num-tile ranking-list)
	  (if (equal num-tile 4)
	      ;; If true, this tile is a 4, so put it on the end.
	      (progn
		(setf tile (nth x owned-tiles))
		;; Now put this tile on the end of return.
		(setf return-list (cons tile return-list))
	      ) ;; progn.
	  ) ;; if
	  (setf x (+ x 1))
  )
  
  ;; Now do the 3s.

  (setf x 0)
  (dolist (num-tile ranking-list)
	  (if (equal num-tile 3)
	      ;; If true, this tile is a 3, so put it on the end.
	      (progn
		(setf tile (nth x owned-tiles))
		;; Now put this tile on the end of return.
		(setf return-list (cons tile return-list))
	      ) ;; progn.
	  ) ;; if
	  (setf x (+ x 1))
  )

  ;; Now do the 2s.

  (setf x 0)
  (dolist (num-tile ranking-list)
	  (if (equal num-tile 2)
	      ;; If true, this tile is a 2, so put it on the end.
	      (progn
		(setf tile (nth x owned-tiles))
		;; Now put this tile on the end of return.
		(setf return-list (cons tile return-list))
	      ) ;; progn.
	  ) ;; if
	  (setf x (+ x 1))
  )

  ;; Now do the 1s.

  (setf x 0)
  (dolist (num-tile ranking-list)
	  (if (equal num-tile 1)
	      ;; If true, this tile is a 1, so put it on the end.
	      (progn
		(setf tile (nth x owned-tiles))
		;; Now put this tile on the end of return.
		(setf return-list (cons tile return-list))
	      ) ;; progn.
	  ) ;; if
	  (setf x (+ x 1))
  )

  ;; Now do the 0s.

  (setf x 0)
  (dolist (num-tile ranking-list)
	  (if (equal num-tile 0)
	      ;; If true, this tile is a 0, so put it on the end.
	      (progn
		(setf tile (nth x owned-tiles))
		;; Now put this tile on the end of return.
		(setf return-list (cons tile return-list))
	      ) ;; progn.
	  ) ;; if
	  (setf x (+ x 1))
  )

  (format t "~%Return list is: " return-list)

return-list
)

;; do-i-own
;; This function tells us whether or not the agent owns
;; stock in a particular chain. It takes in the agent's state
;; and the chain in question. It returns T or NIL

(defun do-i-own (a b)
  ;; PRE: Takes an agent state 'a' and a chain 'b'
  ;; POST: Returns T or NIL.

  (format t "~%Inside do-i-own")

  (setq chain nil
	chains nil
	num nil
	name nil
	number 0
	rt nil
  )

  (setf chains (car (cdr (cdr a))))

  (dolist (chain chains)
	  (setf name (car chain))
	  (setf num (car (cdr chain)))
	  (if (equal name b)
	      ;; If true, this is the chain, check the number.
	      (if (equal num 0)
		  (setf rt nil)
		  (setf rt T)
	      ) ;; if
	  ) ;; if
  )

rt
)

;; tile-tagger
;; This function takes in the world state and a list of tiles
;; which the agent has. It then returns a list which tags all
;; of the tiles in their order the following manner:
;;
;; (
;;  (GROW <Chain Name>)   - Grows this chain.
;;  (MAKE)                - Makes a new chain.
;;  (MERGE <Chain Names>) - Merges the chains.
;;  (PLACE <Chain Name>)  - Places a tile, closest to Chain.
;; )

(defun tile-tagger (a b)
  ;; PRE: Takes a world state 'a' and a list of tiles 'b'
  ;; POST: Returns a list of what those tiles do if placed.

  ;; First set up some variables.

  (format t "~% Inside Tile Tagger ")

  (setq agent-id nil
	unplayed-tiles nil
	stocks-left nil
	unused-hotels nil
	played-tiles nil
	chains nil
	tile-chain-list nil
	chain-tiles nil
	closest-chain nil
	return-list nil
	grow-chain nil
	merge-chains nil
	md 200
	sum 0
	x 1
	y 1
	z 1
  )

  ;; And then get their components from the world state.

  (setf agent-id (car a))
  (setf unplayed-tiles (car (cdr a)))
  (setf stocks-left (car (cdr (cdr a))))
  (setf unused-hotels (car (cdr (cdr (cdr a)))))
  (setf played-tiles (car (cdr (cdr (cdr (cdr a))))))
  (setf chains (car (cdr (cdr (cdr (cdr (cdr a)))))))
  (setf return-list nil)

  ;; Now we have to systematically go through all of the tiles
  ;; that we were given and see if they grow or merge a chain.

  (dolist (tile b)
	  ;; For each tile in the list, we will make another
	  ;; list representing the chains and whether or not
	  ;; the tile has manahattan distance 0 to that chain
	  ;; or not.
	  ;; In other words, Tile 10A might be (0 1 0 0)
	  ;; where it only grows the second chain. (0 1 1 0) 
	  ;; would merge the chains 2 and 3. :-)

	  (dolist (chain chains)

		  (setf chain-tiles (car (cdr chain)))
		  (format t "~%Chain tiles are : ~s" chain-tiles)
		  (setf md (tile-chain-distance tile chain-tiles))
		  (format t "~%Manhattan Distance: ~s" md)

		  (if (equal md 1)
		      (if (equal tile-chain-list nil)
			  (setf tile-chain-list (list 1))
			  (setf tile-chain-list (append tile-chain-list `(1)))
		      )
		      (if (equal tile-chain-list nil)
			  (setf tile-chain-list (list 0))
			  (setf tile-chain-list (append tile-chain-list `(0)))
		      )
		  )
	 )

	 ;; We now have in tile-chain-list a list of the relationships
	 ;; between this tile and the chains. Now sum. 
	 ;; If it is 0 we know it is PLACE or MAKE. 
	 ;; If it is 1 we know it is GROW.
	 ;; if it is >1 then it is MERGE.

	 (setf sum 0)

	 (format t "~%Tile Chain list: ~s" tile-chain-list) 

	 (dolist (a tile-chain-list)
		 (setf sum (+ sum a))
	 )

	 (format t "~%Sum of Tile Chain List: ~s" sum)

	 (setf x 0)

	 (if (equal sum 1)
	     (dolist (a tile-chain-list)
		      ;; This is a grow of a specific chain.
		      ;; First we have to find out which chain.
		      (format t "~%It is a Grow. Checking for Chain.")
		     (format t "~%X is ~s" x) 
		     (if (equal a 1)
			  (progn
			    (format t "~%Grow-Chain is: ~s" (car (nth x chains)))
			    (setf grow-chain (car (nth x chains)))
			    (if (equal return-list nil)
				(setf return-list (list (list `GROW grow-chain)))
			        (setf return-list (append return-list (list (list `GROW grow-chain))))
			    ) ;; if
			  )
			  nil
		      )
		      (setf x (+ x 1))
	     )
	     (if (equal sum 0)
		 (progn
		   ;; Place or Make New Chain.
		   ;; Depends on whether or not the tile is next to
		   ;; any of the tiles in the played tiles list.
		   ;; Easy: Do a tile-chain-distance between TILE
		   ;; and the list.
		   
		   (setf md (tile-chain-distance tile played-tiles))
		   (if (equal md 1)
		     (progn
		       ;; Its a MAKE.
		       ;; added by Lisa 05-29-01
		       ;; if there are no more available chains, you can't make a new one, so uhhh
		       ;; just make make-chain NIL
		       (if (eq (length unused-hotels) 0)
			   (setf new-chain-name NIL)
			 (setf new-chain-name (make-chain unused-hotels)))
		       (if (equal return-list nil)
			   (setf return-list (list (list `MAKE new-chain-name)))
			 (setf return-list (append return-list (list (list `MAKE new-chain-name))))			   
		        )
		     )
		     (progn
		       ;; Its a PLACE.
		       ;; We need to find the closest chain to it.
		       ;; Go through the chains and find the smallest.
		       
		       (setf x 0)
		       (setf z 1)
		       (setf y 200)
		       (dolist (chain chains)
			       (setf chain-tiles (car (cdr chain)))
			       (setf z (tile-chain-distance tile chain-tiles))
			       (if (< z y)
				   (progn
				     (setf y z)
				     (setf closest-chain (car (nth x chains)))
				     )
				 nil
				 )
			       (setf x (+ x 1))
		       )
		       (if (equal return-list nil)
			   (setf return-list (list (list `PLACE closest-chain)))
			 (setf return-list (append return-list (list (list `PLACE closest-chain))))
			 )
		       )
		     )
		 ) ;; progn in the if-true
	         (progn
		  ;; Merger
		  ;; To find out who has merged we just call
		  ;; do list through the tile-chain list. If it is
		  ;; a 1 then we will add that to the merge-chain list.
		  
		  (dolist (a tile-chain-list)
			  (format t "~%It is a Merger. Checking for Chains.")
			  (if (equal a 1)
			      (progn
			       (format t "~%Found merging chain.")
			       (if (equal merge-chains nil)
				 (setf merge-chains (list (car (nth x chains))))
				 (progn 
				    (format t "~%merge chains not nil :: ~s appending ~s " merge-chains (list (car (nth x chains))))
				   (setf merge-chains (append merge-chains (list (car (nth x chains)))))
				   (format t "~%merge chains now: ~s" merge-chains)
				 )
			       )
			      )
			      nil
			  )
			  (setf x (+ x 1))
		  )
		  (if (equal return-list nil)
		      (setf return-list (list (cons `MERGE merge-chains)))
		      (setf return-list (append return-list (list (cons `MERGE merge-chains))))
		      )
		  ) ;; prog
		 ) ;; if sum is 0
	     ) ;; if sum is 1

	 (format t "~%Grow Chain is ::: ~s" grow-chain)

	 ;; Now adjust the return list accordingly.

	 ;;(if (not (equal grow-chain nil))
	 ;;(append return-list (list `GROW grow-chain))
	 ;;  (if (not (equal merge-chains nil))
	 ;;(append return-list (cons `MERGE merge-chains))
	 ;;nil
	 ;;)
	 ;;)

      (setf grow-chain nil)
      (setf merge-chains nil)
      (setf closest-chain nil)
      (setf z 1)
      (setf y 200)
      (setf x 1)
      (setf sum 0)
      (setf tile-chain-list nil)
      (setf md 0)
      
      (format t "~%RETURN LIST: ~s" return-list)

    ) ;; Do list for each tile in the list of tiles.

;; And finally return the return-list

(format t "~%Return list: ~s" return-list)
return-list
) ;; procedure tile-tagger	     

	  
			       
			  

  





