;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; FILE: Perimeter.lisp
;; Function that calculates the perimeter of a existing chain in
;; Acquire. The perimeter of a chain is the length of the distance
;; around the outside of the chain. To find the perimeter of a chain,
;; we'll take the sum of the distance along each of the sides. 
;; A chain is composed by tiles. We'll say that each side of the tile
;; has length 1.
;; 
;; Created by Luiza da Silva
;; Date: 05/19/2001
;; Modified: 05/27/2001
;;(
;; Input: 
;;   1. Chain that needs to have its paramenter calculated
;;   2. List of existing chains, containing their tiles
;;
;; Output:
;;   1. Perimiter of chain
;;
;; Procedure:
;;  1. Obtain chain name that needs to be calculated
;;  2. Obtain list of exsting chains in board with their tiles
;;  3. Extract list of tiles of the chain we want to calculate
;; the perimeter
;;  4. Calculate perimeter
;;
;; General Conditions:
;;  1. Smaller possible chain has 2 tiles, therefore perimeter=6.
;;
;; Questions:
;; 1. Do I have to check if all tiles listed actually are somewhat
;; connected (i.e., are all part of the chain)?
;; 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; Function PERIMETER
;; calculates a list of tiles that can be placed around the chain
;; and grow it
(defun perimeter (?chain ?existing-chains)
  ;; PRE: takes chain name and existing chains
  ;; POST: retuns list of possible adjacint tiles

  (setq seclist nil)
  (setq tile-list nil)

  ;; get tile-list from *existing-chains*
  (setf tile-list (nth 1(assoc ?chain ?existing-chains)))

  (format t "tile-list : ~%~s~%" tile-list)

  (setf copy-tile-list (copy-list tile-list))
  
  ;; for each tile, make a list of tiles that are around it (up, down,
  ;; left and right of the tile in the chain
  ;; maek a big list of all adjacent tiles
  (dolist (tile tile-list)
	  ;;(format t "partial tile-list inside loop: ~%~s~%" tile-list)
	  ;;(format t "partile tile inside loop: ~%~s~%" tile)
	  (setf seclist (append seclist (adj-tiles tile))))

  ;;(format t "full seclist: ~%~s~%" seclist)

  ;;from the big list, take repeats out, leaving just one of each
  (setf seclist (remove-duplicates seclist))
  
  ;;(format t "seclist w/out doubles: ~%~s~%" seclist)

  ;; take out the tiles that form the chain
  ;;(format t "copy-tile-list : ~%~s~%" copy-tile-list)
  (dolist (tile copy-tile-list)
	  ;;(format t "tile : ~%~s~%" tile)
	  (setf seclist (remove tile seclist))
	  ;;(format t "new seclist: ~%~s~%" seclist)
	  )
  
  (format t "final seclist: ~%~s~%" seclist)

  ;;returm list
  seclist

)

;; Function ADJ-TILES
;; Return the tiles adjacent to the one received
;; calls function tile-back in maptile.lisp
(defun adj-tiles (?tile)
  ;; PRE: takes a tile
  ;; POST: returns the tiles adjacent to it
  
  (setq tile-list nil)
  (setq new-list nil)

  ;;gets tile's grid location
  (setf ptile (grid-location ?tile))
  
  ;;adjacent tiles
  (setf uptile (list (nth 0 ptile)(- (nth 1 ptile) 1)))

  (setf downtile (list (nth 0 ptile)(+ (nth 1 ptile) 1)))

  (setf lefttile (list (- (nth 0 ptile) 1)(nth 1 ptile)))

  (setf righttile (list (+ (nth 0 ptile) 1)(nth 1 ptile)))

  ;; check if they are valid
  (if (or (eql (nth 0 uptile) 0)(eql (nth 0 uptile) 13))(setf uptile nil))
  (if (or (eql (nth 1 uptile) 0)(eql (nth 1 uptile) 10))(setf uptile nil))

  (if (or (eql (nth 0 downtile) 0)(eql (nth 0 downtile) 13))(setf downtile nil))
  (if (or (eql (nth 1 downtile) 0)(eql (nth 1 downtile) 10))(setf downtile nil))

  (if (or (eql (nth 0 lefttile) 0)(eql (nth 0 lefttile) 13))(setf lefttile nil))
  (if (or (eql (nth 1 lefttile) 0)(eql (nth 1 lefttile) 10))(setf lefttile nil))

  (if (or (eql (nth 0 righttile) 0)(eql (nth 0 righttile) 13))(setf righttile nil))
  (if (or (eql (nth 1 righttile) 0)(eql (nth 1 righttile) 10))(setf righttile nil))

  ;; put them together in a list
  (setf tilelist (list uptile downtile lefttile righttile))

  ;; remove nils from the list
  (setf tilelist (remove nil tilelist))

  ;; map tiles back to tile notation
  (dolist (tle tilelist)
    (setf new-list (append new-list (list (tile-back tle)))))

  new-list
)

;; Function NPERIMETER
;; Returns the number of tiles that can be placed around a chain and it grows it.
;; calls perimeter
(defun nperimeter (?chain ?existing-chains)
  ;; PRE: takes a chain and the list of existing chains in the board
  ;; POST: returns the number of tiles that can be adjacent to the chain
  
  (format t "~%Inside nperimeter, in perimeter.lisp~%")

  (setf adj-tiles (perimeter ?chain ?existing-chains))
  
  (format t "adj-tiles: ~%~s~%" adj-tiles)

  (setf ntiles (length adj-tiles))

  (format t "number of tiles: ~%~d~%" ntiles)

  (format t "~%Leaving nperimeter~%")
  ntiles
)


;; Function PER_SE-PERIMETER
;; calculatesthe perimeter as sides of a tile
(defun per-se-perimeter (?chain ?existing-chains)

  (defparameter result 0)

  (setq tile-list nil)
  (setq p 0)

  ;;(format t "~%~s~%" ?chain)

  ;;(format t "~%~s~%" ?existing-chains)

  ;;find ?chain in ?existing-chains
  ;;if it is there, remove tile-list

  (setf tile-list (nth 1 (assoc ?chain ?existing-chains)))

  ;;(format t  "~%~A~%" tile-list)

  ;;calculate perimeter
  ;;perimeter = (number-tiles * 4) - (num-connections * 2)

  (setf connects (num-connections tile-list))

  (cond ((null tile-list)(setf p 0))
	((eql (length tile-list) 1)(setf p 4))
	(t (setf p (- (* (length tile-list) 4)(* connects 2)))))

  (format t "~%~s~%" p)

  ;;(num-connections tile-list)
  
)

;;End of perimeter function

;;function that calculates the number of connections between the tiles
(defun num-connections (?tile-list)

  ;;come up with tile combinations 2-2 (no repeats) and then check the 
  ;;degree of connectivity that pairs have
  ;; make a big list with all combinations, take repeats out

  (setq list-comb nil)
  (setq grid nil)
  (setq list-comb nil)

  (dolist (tile ?tile-list)
	  (setf grid (list (grid-location tile)))
	  ;;(format t "~%~S~%" grid)
	  (setf list-comb (append grid list-comb)))

  
  (comb list-comb)

  ;;(format t "~%~s~%" list-comb)
)


(defun comb (?lst)

  (setq comb nil)

  (setf copy (copy-list ?lst))

  (loop for obj in ?lst
	do (loop for snd in copy
		 do (if (not (eql obj snd))
			(setf comb (append (list (list obj snd)) comb)))))

  (setf comb (remove-duplicates comb))

  (dolist (pair comb)
	  (setf a (nth 0 pair))
	  (setf b (nth 1 pair))
	  ;;(format t "~% a = ~s~%" a)
	  ;;(format t "~% b = ~s~%" b)
	  (setf diff1 (abs (- (nth 0 a)(nth 0 b))))
	  ;;(format t "~% diff1 = ~s~%" diff1)
	  (setf diff2 (abs (- (nth 1 a)(nth 1 b))))
	  ;;(format t "~% diff2 = ~S~%" diff2)
	  (setf sum (+ diff1 diff2))
	  (if (eql sum 1)(setf result (+ result 1))))

  ;;(format t "~%~d~%" result)

  (setf result (/ result 2))
)

    




