;; mdistance.lisp
;; A series of functions used to find manhattan distance between chains,
;; tiles, and other assorted methodology.
;; Programmer: Michael Czajkowski
;; Created: 19 May, 2001

;; connectivity
;; This function takes two chains and tells you how well connected
;; they are. Connectivity is measured by the number of places between
;; the two chains that one tile would merge the two chains together.

(defun connectivity (a b)
  ;; PRE: Takes two lists which represent chains.
  ;; POST: Returns an integer, the connectivity of the two chains.

  (setq connectivity 0
	tile-connectivity 0
	grid-a nil
	grid-b nil
	md 0
  )

  (dolist (tile-a a)
	  ;; For each tile in a, go through all tiles in the
	  ;; other chain.
	  
	  (setf tile-connectivity 0)
	  
	  (dolist (tile-b b)
		   ;; If tile-a and tile-b have manhattan
		   ;; distance of 2 then we add one to the
		   ;; tile-connectivity variable. At the end
		   ;; we put tile-connectivity into connectivity.

		   (setf grid-a (grid-location tile-a))
		   (setf grid-b (grid-location tile-b))
		   
		   (setf md (manhattan-distance grid-a grid-b))

		   (if (equal md 2)
		       ;; Connectivity is one more.
		       (setf tile-connectivity (+ tile-connectivity 1))
		       nil
		   )
	  )
	  
	  ;; Now take tile-connectivity and add it to connectivity.

	  (setf connectivity (+ connectivity tile-connectivity))
  ) ;; dolist

;; Return connectivity

connectivity
) ;; procedure connectivity.

;; tile-chain-distance
;; This funtion takes a tile and a chain and then returns the distance
;; between the two.

(defun tile-chain-distance (a b)
  ;; PRE: Takes an atom and a list of tiles.
  ;; POST: Returns the minium tile distance.

  (setq dys 200
	temp 0
	loc1 nil
	loc2 nil
  )

  ;; Go through the elements of list b and then
  ;; Decrement the distance if the manhattan is closer.

  (setf loc1 (grid-location a))

  (dolist (objb b)
	  (setf loc2 (grid-location objb))
	  (setf temp (manhattan-distance loc1 loc2))
		  
	  (if (< temp dys)
	      (setf dys temp)
	    nil
	  )
  )

  ;; And now dys is the minimum manhattan distance.

dys
)

;; chain-distance
;; This function takes two lists of tiles and returns the distance
;; between the two lists (each list assumed to be a hotel's chain)

(defun chain-distance (a b)
  ;; PRE: Takes two lists of tiles.
  ;; POST: Returns the minimum chain distance

  (setq dys 200
	temp 0
	loc1 nil
	loc2 nil
  )
  
  ;; Go through elements of each list and get their grid
  ;; locations and then manhattan distances.

  (dolist (obja a)
	  ;; (format t "~%OBJECT A IS: ~s~%" obja)
	  (setf loc1 (grid-location obja))	  
	  ;; (format t "~%LOC1 IS: ~s~%" loc1)
	  (dolist (objb b)
		  (setf loc2 (grid-location objb))
		  ;; (format t "~%LOC2 IS: ~s~%" loc2)
		  (setf temp (manhattan-distance loc1 loc2))
		  ;; (format t "~%TEMP IS: ~s DIST IS: ~s" temp dys)
		  ;; If the temp is less than difference
		  ;; make the new distance temp.
		      
		  (if (< temp dys)
		      (setf dys temp)
		      nil
		  )
	  )
  )
  dys
) ;; End of function chain-distance

;; manhattan-distance
;; This function takes two tile locations and returns their manhattan
;; distance.

(defun manhattan-distance (a b)
  ;; PRE: Takes two lists of two length each, each element is a number.
  ;; POST: Returns a number integer distance between x and y.

  (setq x1 nil
	x2 nil
	y1 nil
	y2 nil
	distance nil)

  ;; set up the variables, a goes to x1,y1 and b to x2,y2

  (setf x1 (car a))
  (setf x2 (car b))
  (setf y1 (car (cdr a)))
  (setf y2 (car (cdr b)))

  ;; now distance is abs(y1-y2) + abs(x1-x2)
  
  (setf distance (+ (abs (- y1 y2)) (abs (- x1 x2))))

  distance
) ;; end of function manhattan-distance.

;; grid-location
;; This function takes a tile and gets its grid location as a list
;; of two numbers: (column,row) so 10A is (10 1).

(defun grid-location (x)
  ;; PRE: Takes a tile atom.
  ;; POST: Returns a list (column row)

  (setq letter nil 
	number nil 
	str nil 
	retx nil 
	rety nil)

  ;; get the string version of x

  (setf str (format nil "~A" x))

  ;; get the letter portion of the string

  (setf letter (char str (- (length str) 1)))

  ;; get the number portion of the string

  (setf number (if (equal (length str) 3)
		   (format nil "~A~A" (aref str 0) (aref str 1))
		   (format nil "~A" (aref str 0))
		   )
  )

  ;; translate the number portion to an atomic number.

  (if
      (equal number "1")
      (setf rety 1)
  )
  (if
      (equal number "2")
      (setf rety 2)
  )
  (if
      (equal number "3")
      (setf rety 3)
  )
  (if
      (equal number "4")
      (setf rety 4)
  )
  (if
      (equal number "5")
      (setf rety 5)
  )
  (if
      (equal number "6")
      (setf rety 6)
  )
  (if
      (equal number "7")
      (setf rety 7)
  )
  (if
      (equal number "8")
      (setf rety 8)
  )
  (if
      (equal number "9")
      (setf rety 9)
  )
  (if
      (equal number "10")
      (setf rety 10)
  )
  (if
      (equal number "11")
      (setf rety 11)
  )
  (if
      (equal number "12")
      (setf rety 12)
  )

  ;; translate the letter portion into a number atom

  (if
      (equal (format nil "~A" letter) "A")
      (setf retx 1)
  )
  (if
      (equal (format nil "~A" letter) "B")
      (setf retx 2)
  )
   (if
      (equal (format nil "~A" letter) "C")
      (setf retx 3)
  )
  (if
      (equal (format nil "~A" letter) "D")
      (setf retx 4)
  )
  (if
      (equal (format nil "~A" letter) "E")
      (setf retx 5)
  )
  (if
      (equal (format nil "~A" letter) "F")
      (setf retx 6)
  )
  (if
      (equal (format nil "~A" letter) "G")
      (setf retx 7)
  )
  (if
      (equal (format nil "~A" letter) "H")
      (setf retx 8)
  )
  (if
      (equal (format nil "~A" letter) "I")
      (setf retx 9)
  )

  ;; Return the list of the column then row.

  (list rety retx)
) ;; end of function grid-location.









