;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Programmer: Luiza da Silva
;; Date: May 27 2001
;; Modified: 05 27 2001
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; FILE: maptile.lisp
;; Function that maps the tile from its grid location back to the
;; (number-letter) notation.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;; Function TILE-BACK
;; maps a grid position to a tile
(defun tile-back(?x)
  ;; PRE: takes a grid postion for a tile
  ;; POST :returns a tile symbol

  (setq tile nil)

  (if (eql (nth 1 ?x) 1)(setf letter 'A))
  (if (eql (nth 1 ?x) 2)(setf letter 'B))
  (if (eql (nth 1 ?x) 3)(setf letter 'C))
  (if (eql (nth 1 ?x) 4)(setf letter 'D))
  (if (eql (nth 1 ?x) 5)(setf letter 'E))
  (if (eql (nth 1 ?x) 6)(setf letter 'F))
  (if (eql (nth 1 ?x) 7)(setf letter 'G))
  (if (eql (nth 1 ?x) 8)(setf letter 'H))
  (if (eql (nth 1 ?x) 9)(setf letter 'I))

  (setf tile (eval(read-from-string(format nil "'~s~s" (car ?x) letter))))

  tile



;; Ugly way of doing it, before Lisa's help...

  ;; FIRST ROW
;  (if (and (eql (nth 0 ?x) 1)(eql (nth 1 ?x) 1))(setf tile '1A))
;  (if (and (eql (nth 0 ?x) 2)(eql (nth 1 ?x) 1))(setf tile '2A))
;  (if (and (eql (nth 0 ?x) 3)(eql (nth 1 ?x) 1))(setf tile '3A))
;  (if (and (eql (nth 0 ?x) 4)(eql (nth 1 ?x) 1))(setf tile '4A))
;  (if (and (eql (nth 0 ?x) 5)(eql (nth 1 ?x) 1))(setf tile '5A))
;  (if (and (eql (nth 0 ?x) 6)(eql (nth 1 ?x) 1))(setf tile '6A))
;  (if (and (eql (nth 0 ?x) 7)(eql (nth 1 ?x) 1))(setf tile '7A))
;  (if (and (eql (nth 0 ?x) 8)(eql (nth 1 ?x) 1))(setf tile '8A))
;  (if (and (eql (nth 0 ?x) 9)(eql (nth 1 ?x) 1))(setf tile '9A))
;  (if (and (eql (nth 0 ?x) 10)(eql (nth 1 ?x) 1))(setf tile '10A))
;  (if (and (eql (nth 0 ?x) 11)(eql (nth 1 ?x) 1))(setf tile '11A))
;  (if (and (eql (nth 0 ?x) 12)(eql (nth 1 ?x) 1))(setf tile '12A))

  ;;SECOND ROW
;  (if (and (eql (nth 0 ?x) 1)(eql (nth 1 ?x) 2))(setf tile '1B))
;  (if (and (eql (nth 0 ?x) 2)(eql (nth 1 ?x) 2))(setf tile '2B))
;  (if (and (eql (nth 0 ?x) 3)(eql (nth 1 ?x) 2))(setf tile '3B))
;  (if (and (eql (nth 0 ?x) 4)(eql (nth 1 ?x) 2))(setf tile '4B))
;  (if (and (eql (nth 0 ?x) 5)(eql (nth 1 ?x) 2))(setf tile '5B))
;  (if (and (eql (nth 0 ?x) 6)(eql (nth 1 ?x) 2))(setf tile '6B))
;  (if (and (eql (nth 0 ?x) 7)(eql (nth 1 ?x) 2))(setf tile '7B))
;  (if (and (eql (nth 0 ?x) 8)(eql (nth 1 ?x) 2))(setf tile '8B))
;  (if (and (eql (nth 0 ?x) 9)(eql (nth 1 ?x) 2))(setf tile '9B))
;  (if (and (eql (nth 0 ?x) 10)(eql (nth 1 ?x) 2))(setf tile '10B))
; (if (and (eql (nth 0 ?x) 11)(eql (nth 1 ?x) 2))(setf tile '11B))
; (if (and (eql (nth 0 ?x) 12)(eql (nth 1 ?x) 2))(setf tile '12B))

  ;; THIRD ROW
;  (if (and (eql (nth 0 ?x) 1)(eql (nth 1 ?x) 3))(setf tile '1C))
;  (if (and (eql (nth 0 ?x) 2)(eql (nth 1 ?x) 3))(setf tile '2C))
;  (if (and (eql (nth 0 ?x) 3)(eql (nth 1 ?x) 3))(setf tile '3C))
;  (if (and (eql (nth 0 ?x) 4)(eql (nth 1 ?x) 3))(setf tile '4C))
;  (if (and (eql (nth 0 ?x) 5)(eql (nth 1 ?x) 3))(setf tile '5C))
;  (if (and (eql (nth 0 ?x) 6)(eql (nth 1 ?x) 3))(setf tile '6C))
;  (if (and (eql (nth 0 ?x) 7)(eql (nth 1 ?x) 3))(setf tile '7C))
;  (if (and (eql (nth 0 ?x) 8)(eql (nth 1 ?x) 3))(setf tile '8C))
;  (if (and (eql (nth 0 ?x) 9)(eql (nth 1 ?x) 3))(setf tile '9C))
;  (if (and (eql (nth 0 ?x) 10)(eql (nth 1 ?x) 3))(setf tile '10C))
;  (if (and (eql (nth 0 ?x) 11)(eql (nth 1 ?x) 3))(setf tile '11C))
;  (if (and (eql (nth 0 ?x) 12)(eql (nth 1 ?x) 3))(setf tile '12C))

  ;; FOURTH ROW
;  (if (and (eql (nth 0 ?x) 1)(eql (nth 1 ?x) 4))(setf tile '1D))
;  (if (and (eql (nth 0 ?x) 2)(eql (nth 1 ?x) 4))(setf tile '2D))
;  (if (and (eql (nth 0 ?x) 3)(eql (nth 1 ?x) 4))(setf tile '3D))
;  (if (and (eql (nth 0 ?x) 4)(eql (nth 1 ?x) 4))(setf tile '4D))
;  (if (and (eql (nth 0 ?x) 5)(eql (nth 1 ?x) 4))(setf tile '5D))
;  (if (and (eql (nth 0 ?x) 6)(eql (nth 1 ?x) 4))(setf tile '6D))
;  (if (and (eql (nth 0 ?x) 7)(eql (nth 1 ?x) 4))(setf tile '7D))
;  (if (and (eql (nth 0 ?x) 8)(eql (nth 1 ?x) 4))(setf tile '8D))
;  (if (and (eql (nth 0 ?x) 9)(eql (nth 1 ?x) 4))(setf tile '9D))
;  (if (and (eql (nth 0 ?x) 10)(eql (nth 1 ?x) 4))(setf tile '10D))
;  (if (and (eql (nth 0 ?x) 11)(eql (nth 1 ?x) 4))(setf tile '11D))
;  (if (and (eql (nth 0 ?x) 12)(eql (nth 1 ?x) 4))(setf tile '12D))

  ;; FIFTH ROW
;  (if (and (eql (nth 0 ?x) 1)(eql (nth 1 ?x) 5))(setf tile '1E))
;  (if (and (eql (nth 0 ?x) 2)(eql (nth 1 ?x) 5))(setf tile '2E))
;  (if (and (eql (nth 0 ?x) 3)(eql (nth 1 ?x) 5))(setf tile '3E))
;  (if (and (eql (nth 0 ?x) 4)(eql (nth 1 ?x) 5))(setf tile '4E))
;  (if (and (eql (nth 0 ?x) 5)(eql (nth 1 ?x) 5))(setf tile '5E))
;  (if (and (eql (nth 0 ?x) 6)(eql (nth 1 ?x) 5))(setf tile '6E))
;  (if (and (eql (nth 0 ?x) 7)(eql (nth 1 ?x) 5))(setf tile '7E))
;  (if (and (eql (nth 0 ?x) 8)(eql (nth 1 ?x) 5))(setf tile '8E))
;  (if (and (eql (nth 0 ?x) 9)(eql (nth 1 ?x) 5))(setf tile '9E))
;  (if (and (eql (nth 0 ?x) 10)(eql (nth 1 ?x) 5))(setf tile '10E))
;  (if (and (eql (nth 0 ?x) 11)(eql (nth 1 ?x) 5))(setf tile '11E))
;  (if (and (eql (nth 0 ?x) 12)(eql (nth 1 ?x) 5))(setf tile '12E))

  ;;SIXTH ROW
; (if (and (eql (nth 0 ?x) 1)(eql (nth 1 ?x) 6))(setf tile '1F))
; (if (and (eql (nth 0 ?x) 2)(eql (nth 1 ?x) 6))(setf tile '2F))
; (if (and (eql (nth 0 ?x) 3)(eql (nth 1 ?x) 6))(setf tile '3F))
; (if (and (eql (nth 0 ?x) 4)(eql (nth 1 ?x) 6))(setf tile '4F))
; (if (and (eql (nth 0 ?x) 5)(eql (nth 1 ?x) 6))(setf tile '5F))
; (if (and (eql (nth 0 ?x) 6)(eql (nth 1 ?x) 6))(setf tile '6F))
; (if (and (eql (nth 0 ?x) 7)(eql (nth 1 ?x) 6))(setf tile '7F))
;  (if (and (eql (nth 0 ?x) 8)(eql (nth 1 ?x) 6))(setf tile '8F))
;  (if (and (eql (nth 0 ?x) 9)(eql (nth 1 ?x) 6))(setf tile '9F))
;  (if (and (eql (nth 0 ?x) 10)(eql (nth 1 ?x) 6))(setf tile '10F))
;  (if (and (eql (nth 0 ?x) 11)(eql (nth 1 ?x) 6))(setf tile '11F))
;  (if (and (eql (nth 0 ?x) 12)(eql (nth 1 ?x) 6))(setf tile '12F))

  ;; SEVENTH ROW
;  (if (and (eql (nth 0 ?x) 1)(eql (nth 1 ?x) 7))(setf tile '1G))
;  (if (and (eql (nth 0 ?x) 2)(eql (nth 1 ?x) 7))(setf tile '2G))
;  (if (and (eql (nth 0 ?x) 3)(eql (nth 1 ?x) 7))(setf tile '3G))
;  (if (and (eql (nth 0 ?x) 4)(eql (nth 1 ?x) 7))(setf tile '4G))
;  (if (and (eql (nth 0 ?x) 5)(eql (nth 1 ?x) 7))(setf tile '5G))
;  (if (and (eql (nth 0 ?x) 6)(eql (nth 1 ?x) 7))(setf tile '6G))
;  (if (and (eql (nth 0 ?x) 7)(eql (nth 1 ?x) 7))(setf tile '7G))
;  (if (and (eql (nth 0 ?x) 8)(eql (nth 1 ?x) 7))(setf tile '8G))
;  (if (and (eql (nth 0 ?x) 9)(eql (nth 1 ?x) 7))(setf tile '9G))
;  (if (and (eql (nth 0 ?x) 10)(eql (nth 1 ?x) 7))(setf tile '10G))
;  (if (and (eql (nth 0 ?x) 11)(eql (nth 1 ?x) 7))(setf tile '11G))
;  (if (and (eql (nth 0 ?x) 12)(eql (nth 1 ?x) 7))(setf tile '12G))


  ;; EIGHTH ROW
;  (if (and (eql (nth 0 ?x) 1)(eql (nth 1 ?x) 8))(setf tile '1H))
;  (if (and (eql (nth 0 ?x) 2)(eql (nth 1 ?x) 8))(setf tile '2H))
;  (if (and (eql (nth 0 ?x) 3)(eql (nth 1 ?x) 8))(setf tile '3H))
;  (if (and (eql (nth 0 ?x) 4)(eql (nth 1 ?x) 8))(setf tile '4H))
;  (if (and (eql (nth 0 ?x) 5)(eql (nth 1 ?x) 8))(setf tile '5H))
;  (if (and (eql (nth 0 ?x) 6)(eql (nth 1 ?x) 8))(setf tile '6H))
;  (if (and (eql (nth 0 ?x) 7)(eql (nth 1 ?x) 8))(setf tile '7H))
;  (if (and (eql (nth 0 ?x) 8)(eql (nth 1 ?x) 8))(setf tile '8H))
;  (if (and (eql (nth 0 ?x) 9)(eql (nth 1 ?x) 8))(setf tile '9H))
;  (if (and (eql (nth 0 ?x) 10)(eql (nth 1 ?x) 8))(setf tile '10H))
;  (if (and (eql (nth 0 ?x) 11)(eql (nth 1 ?x) 8))(setf tile '11H))
;  (if (and (eql (nth 0 ?x) 12)(eql (nth 1 ?x) 8))(setf tile '12H))


  ;; NINTH ROW
;  (if (and (eql (nth 0 ?x) 1)(eql (nth 1 ?x) 9))(setf tile '1I))
;  (if (and (eql (nth 0 ?x) 2)(eql (nth 1 ?x) 9))(setf tile '2I))
;  (if (and (eql (nth 0 ?x) 3)(eql (nth 1 ?x) 9))(setf tile '3I))
;  (if (and (eql (nth 0 ?x) 4)(eql (nth 1 ?x) 9))(setf tile '4I))
;  (if (and (eql (nth 0 ?x) 5)(eql (nth 1 ?x) 9))(setf tile '5I))
;  (if (and (eql (nth 0 ?x) 6)(eql (nth 1 ?x) 9))(setf tile '6I))
;  (if (and (eql (nth 0 ?x) 7)(eql (nth 1 ?x) 9))(setf tile '7I))
;  (if (and (eql (nth 0 ?x) 8)(eql (nth 1 ?x) 9))(setf tile '8I))
;  (if (and (eql (nth 0 ?x) 9)(eql (nth 1 ?x) 9))(setf tile '9I))
;  (if (and (eql (nth 0 ?x) 10)(eql (nth 1 ?x) 9))(setf tile '10I))
;  (if (and (eql (nth 0 ?x) 11)(eql (nth 1 ?x) 9))(setf tile '11I))
;  (if (and (eql (nth 0 ?x) 12)(eql (nth 1 ?x) 9))(setf tile '12I))

)


