;;;; Implementation of Dumb Agent
;;;; Luiza da Silva


;;; AGENT INITIALIZATION
;;; Initializes agent.

(defun setup-agent ()

;;; Fields, all initialized to NIL in the beginning.

  ;; id - a unique identification for the agent, given by the
  ;; controller when the agent subscribes to it
  (defparameter *id*                 NIL)

  ;; home - the location (probably IP address) of this Agent
  (defparameter *home*               NIL)

  ;; controller -  the location (probably IP address) of the
  ;;  main game "server" which this Agent is connected to
  (defparameter *controller*         NIL)

  ;; referee - the location (probably IP address) of the 
  ;; game engine (Referee Engine) which this Agent is connected to
  (defparameter *referee*            NIL)

  ;; to-referee-Engine - AgentConnector object that this Agent 
  ;; uses to send and receive messages to and from the Referee
  (defparameter *to-referee-agent*   NIL)

  ;; to-player-engine - AgentConnector object that this Agent 
  ;; uses to send and receive messages to and from its Player's Engine 
  (defparameter *to-player-engine*   NIL)

  ;; heuristic - the name of the Heuristic which this Agent uses
  ;; (defparameter *heuristic*       NIL)

;;; items money, tiles and stocks are going to be property lists of
;;; an agent.
  
  (defparameter *avail-chains*       NIL)
  (defparameter *init-money*         0)
  (defparameter *tiles*              MIL)

NIL
)




:;; main() - Generates the agent; executable method to allow this 
;;; Agent to be instantiated and run on a separate machine from the 
;;; "referee"; it connects to the "controller" and waits for the 
;;; game to begin

(defun main ()

 (set-home(get-home))

 (set=controller(get-controller))

 (request-referee)

 (set-referee(get-referee))

 ;;(set-heuristic(get-heuristic))

 ;;gets controller location and calls agent's contructor
  (agent (*controller*))

  (show-agent)
  
  (make-move)

  (send-move-to-referee)

 
)





;;; agent (?controller) - constructor of the Agent class; the argument 
;;; "controller" tells the Agent where to find the main game "server"


(defun agent (?controller)

 ;; calls get-id( ) and set-id( )
  (set-id (get-id))

 ;; calls get-init-money ( ) and set-init-money( )
  (set-init-money (get-init-money))

 ;;set up property lists for money and for stocks
  (eval (read-from-string (format nil "(setf (get (nth ~s *id*) 'money) ~d)~%" temp *init-money*)))

 ;; calls get-avail-chains () and set-avail-chains()
  (set-avail-chains(get-avail-chains))

 ;; sets up initial available chains to agent
  (dolist (temp *avail-chains*)
	  (eval (read-from-string (format nil "(setf (get (nth ~s *id*) '~s) 0)~%" *id*  temp))))
)






;;; get-home( ) - get agent's location

(defun get-home()


)






;;; get-controller( ) - returns the location of the controller this 
;;; Agent is connected to

(defun get-controller()

)





;;; request-referee( ) - asks the controller for the location of 
;;; the Referee Engine this Agent must connect to

(defun request-referee ( )

)






;;; get-referee ( ) - returns the location of the Referee 
;;; Engine this Agent is connected to

(defun get-referee ( )

)






;;; set-referee( ) - sets the location of the Referee Engine 
;;; this Agent is connected to

(defun set-referee ( )

)







;;; get-heuristic( ) - returns the name of the Heuristic which 
;;; this Agent uses

;;(defun get-heuristic ( )

;;)






;;; get-id ( ) - returns the agent's id given by the Controller
(defun get-id ( )
;; for now, initialized with 1
1
)







;;; set-id (?x) - mutator, sets value for *id* to ?x
(defun set-id (?x)
 (setf *id* ?x)
)






;;; get-init-money ( ) - returns the agent's initial money given
;;; by the Referee
(defun get-init-money( )
  ;; for now initialized with 0
0
)






;;; set-init-money (?x) - mutator, sets value for *init-money* to ?x
(defun set-init-money(?x)
 (setf *init-money* ?x)
)






;;; get-avail-chains ( ) - retuns available chains
(defun get-avail-chains ( )
  ;; for now initialized to typical values
  (FESTIVAL WORLDWIDE TOWER IMPERIAL AMERICAN CONTINENTAL LUXOR)
)






;;; set-avail-chains (x) - mutator, sets value for *avail-chains* to x
(defun set-avail-chains (x)
  (setf *avail-chains* x)
)






;;; show-agent( ) - display information about agent

(defun show-agent( )
  (pprint *id*)
  (eval (read-from-string (format nil "(pprint (get '~s 'tiles))~%" *id*)))
  (eval (read-from-string (format nil "(pprint (get '~s 'money))~%" *id*)))
  (dolist (temp *avail-stocks*)
	  (format t "~% ~s" temp)
	  (eval (read-from-string (format nil "(pprint (get '~s '~s))~%" *id* 
temp)))
	  (format t "~%")
  )
)


;;;GAME PLAYING

;; Picks agent's move
(defun make-move()

)

;; Sends agent's move to referee 
(defun send-move-to-referee()

)

;; Receives world state from referee
(defun receive-world-state (x)

)

;; Draw tile
(defun draw-tile()

)

;; Chooses stocks to buy on agent's turn
(defun make-stock-choice()

)

;; Receives stocks from stocks
(defun get-stocks-from-referee()

)

;; Receives bonus from referee
(defun get-bonus-from-referee()

)

;; In case of a merger, agent must decide what to do with stock from chain x
(defun make-stock-decision (x)

)










