;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;; Implementation of the Generic Heuristic
;;;; Programmer: Luiza da Silva
;;;; Created: May 25 2001
;;;; Last revised: May 29 2001
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; FILE: GenHeur.lisp
;; The Generic Heuristic is what agents are going to 
;; use in the next level of implementation. Now, a simple economic 
;; model is attempted to be constructed, where the most important 
;; thing for the agent is first to merge chains as often as it can, trying
;; to buy stocks from the biggest chains (or with largest possibility
;; of growth) and by trying to grow such chains
;; (because then, at the end of the game, it can get more money as being
;; among of the largest stockholders for the bigger chain(s)). 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;; FUNCTIONS

;; Function SETUP-GEN-HEURISTIC()
;; Sets up global parameters for General Heuristic
(defun setup-gen-heuristic()
  ;; PRE: heuristic should be loaded in agent
  ;; POST: declares global variables for the heuristic

  (format t "~%Inside setup-gen-heuristic~%")

  (defparameter *world-state* NIL)
  (defparameter *agent-state* NIL)

  ;; List of preferences of tile placing in order
  (defparameter *current-tile-list* NIL) 

  (defparameter *last-place-tile-action* nil)
  (defparameter *last-buy-stock-action* nil)
  (defparameter *rem-stocks* nil)
  (defparameter *rem-tiles* nil)
  (defparameter *existing-chains* nil)
  (defparameter *played-tiles* nil)
  (defparameter *new-chain-name* 'nil)

  ;; Load all files that are needed here
  (load "../agent/tile.lisp")
  (load "../agent/maptile.lisp")
  (load "../agent/mdistance.lisp")
  (load "../agent/perimeter.lisp")
;;  (load "../agent/temp.lisa.lisp")

  ;;seeding the random number generator
   
  (setf *random-state* (make-random-state t))

  (format t "~%Leaving setup-gen-heuristic~%")
)

;; Function CALC-MOVE (?STATE_WORLD ?STATE_AGENT)
;; Calculates a move and returns it to the agent
(defun calc-move (?world-state ?agent-state)
  ;; PRE: takes the current state of the world and current agent state.
  ;; POST: Return a move for the agent.

  (format t "~%Inside calc-move, in GenHeur.lisp~%")

  (setf *world-state* ?world-state)
  (setf *agent-state* ?agent-state)

  ;;Mike, should return (PLACE-TILE tile)
  (setq move (cons (calc-tile) nil)) 

  ;;Lisa and Luiza, should return (BUY-STOCK qty chain)
  (setq move (append move (list (calc-stock))))

  (format t "~%Leaving calc-move...~%")

  move
)

;; Function MAX-EXP-SIZE (?X)
;; Determines probability that any remaining tile is adj to x, a chain (recursive)
(defun max-exp-size (?x)
  ;; PRE: takes a chain
  ;; POST: return the probability of tiles yet to be played will the adjacent
  ;;       to x, therefore growing x

  (setq exp-size 0)
  (setq sum 0)

  (format t "~%Inside max-exp-size, in GenHeur.lisp~%")
  (format t "~%parameter received by max-exp-size: ~s~%" ?x)

  (setf chain (nth 0 ?x))
  
  (format t "~%chain to be used in max-exp-size: ~s~%" chain)

  ;; get list of played tiles
  (setf *played-tiles* (nth 4 *world-state*))
  (format t "played-tiles: ~%~s~%" *played-tiles*)

  ;; how many played tiles there is?
  (setf num-played-tiles (length *played-tiles*))
  (format t "Num of played tiles: ~%~s~%" num-played-tiles)

  ;; get the number of tiles that can be placed around the chain to grow it
  ;; do it by calling nparameter
  (format t "~%*existing-chains* in max-exp-size: ~s~%" *existing-chains*)
  (setf num-tiles (nperimeter chain *existing-chains*))
  (format t "num-tiles: ~s~%" num-tiles)
  
  ;; get total number of tile - num of played tiles
  (setf denom (- 108 num-played-tiles))
  (format t "~%Denominator: ~s~%" denom)

  ;;loop that adds the probabilities of a tile to be placed and grow a chain
  (setf control denom )
 
 ; (dotimes (x control)
;	   (setf partial (/ num-tiles denom))
;	   (format t "~%Partial: ~s~%" partial)
;	   (setf exp-size (+ exp-size partial))
;	   (setf num-tiles (+ num-tiles 1))
;	   (setf denom (- denom 1)))

(loop for i from 1 to control
      until (eql (/ num-tiles denom) 1)
      do 
      (setf exp-size (+ exp-size (/ num-tiles denom)))
      (setf num-tiles (+ num-tiles 1))
      (setf denom (- denom 1)))

  (format t "~%max-exp-size: ~s~%" (round exp-size))

  (format t "~%Leaving max-exp-size~%")
  
  (list (round exp-size))
)


;; Function CALC-NEW-PLACE_TILE
;; Calculates a new tile selection if the previous one was declared invalid by 
;; the engine
(defun calc-new-place-tile()
  ;; PRE: take nothing.
  ;; POST: Returns a new tile selection to the agent

  (setq next-tile nil
	new-tile-action nil)

  (setf *current-tile-list* (cdr *current-tile-list*))

  (if (equal (length *current-tile-list*) 0)
      (setf new-tile-action (list `PLACE-TILE NIL))
      (progn
	(setf next-tile (car *current-tile-list*))
	(setf new-tile-action (list `PLACE-TILE next-tile))
	(setf *current-tile-list* (cdr *current-tile-list*))
      )
  ) ;; if

  new-tile-action
)

;; Function CALC-NEW-BUY-STOCK()
;; Calculates a new stock selection if the previous one was declared invalid 
;; by the engine
(defun calc-new-buy-stock()
  ;; PRE: ?
  ;; POST: Returns a new stock selection to the agent. if goes through the
  ;; options (property-lists) in the 
  ;; since the buy-stock action was invalid, such action should be popped out
  ;; from the property list for the first tile in the current tile plan.

  ;; if the invalid buy-stock action was the last one in the property 
  ;; list for the tile, buy-stock action should be nil

  ;; what's the name of the property list from the tile list? stock-list

  ;; pop out the first element of the property list
  
  (setf current-tile (car *current-tile-list*))

  (setf (get current-tile 'stock-list)(remove (car (get current-tile 'stock-list))(get current-tile 'stock-list)))

  ;; get the next element of the property list 

  (setf next-action (car (get current-tile 'stock-list)))
  
  ;; if the tile ran out of options, don't buy any stock

  (if (eql next-action nil)
      (setf new-stock-action (list 'BUY-STOCK nil nil))
    (setf new-stock-action next-action))

  new-stock-action
)

;; Function CALC-TILE()
;; Calculates the tile option for the agent's move.
(defun calc-tile ()
  ;; PRE: ?
  ;; POST: Returns the tile option after analysis.
  
  (format t "~%Inside calc-tile, in GenHeur.lisp~%")

  (setq tile-action nil)

  ;;for testing purposes
  ;;(setf tile-action (list 'PLACE-TILE NIL))
  
  (setf *current-tile-list* (make-tile-list *world-state* *agent-state*))

  ;; return tile action to calc-move

  (setf tile-action (list `PLACE-TILE (car *current-tile-list*)))
 
  ;; remove that action from the current tile list.

  ;; (setf *current-tile-list* (cdr *current-tile-list*))

  (format t "~%Leaving calc-tile~%")
  
  tile-action
  )

;;------------------------------------------------------------------------------
;; Function CALC-STOCK() and sundry related functions
;; 05-29-01 Lisa Anthony
;; Calculates the stock option for the agent's move.
(defun calc-stock()
  ;; PRE: ?
  ;; POST: Returns the stock option after analysis.
  (format t "~%Inside calc-stock, in GenHeur.lisp~%")

  ;; making a copy of *existing-chains* that uses property lists As God Intended
  (setq ex-chains nil)
  (mapcar #'(lambda (z)
	      (setf (get (car z) 'tiles) (cadr z))
	      (setf ex-chains (append ex-chains (list (car z)))))
	  *existing-chains*)
	      
  ;; (setf *current-stock-list* nil)
  
  ;; determine a sequence of contingency plans
  ;; a list of buy-stock actions for each tile in case of
  ;; invalid-place-tile or invalid-buy-stock
  (dolist (temp *current-tile-list*)
	  (setf (get temp 'stock-list) nil)
	  (setf rem-chains (copy-list ex-chains))
	  
	  ;; if a chain has been made in this turn, buy stock in it
	  (if (eq (caar (tile-tagger *world-state* (list temp))) 'MAKE)
	      (progn
		(setf (get temp 'stock-list) (append (cons (cadar (tile-tagger *world-state* (list temp))) nil) (get temp 'stock-list)))))

	  ;; otherwise sort the list of chains in descending order
	  (setf rem-chains (sort-chains rem-chains))
	  
	  ;; determine which chains have a Manhattan distance of 2
	  ;; from any other chain, and buy in chains close to merging
	  (if (> (length (close-chains rem-chains)) 0)
	      ;; sort
	      (progn
		(setf (get temp 'stock-list) (append (get temp 'stock-list) (sort-chains (close-chains rem-chains))))
		(mapcar #'(lambda (z)
			    (setf rem-chains (remove z rem-chains)))
			(sort-chains (close-chains rem-chains)))))
	  
	  ;; finally add the rest, largest first
	  (setf (get temp 'stock-list) (append (get temp 'stock-list) (sort-chains rem-chains))))
  
  ;; lame hack our project sucks
  (mapcar #'(lambda (z)
	      (setf (get z 'stock-list)
		    (flatten
		     (mapcar #'(lambda (x)
				 (list (list 3 x) (list 2 x) (list 1 x)))
			     (get z 'stock-list)))))
	  *current-tile-list*)
  (format t "~%Leaving calc-stock~%")
  (dolist (temp *current-tile-list*)
	  (format t "~%~s ~s" temp (get temp 'stock-list)))
  ;; *current-tile-list*
  (format t "~%~s" (flatten (list (list `BUY-STOCK) (car (get (car *current-tile-list*) 'stock-list)))))
  (flatten (list (list 'BUY-STOCK) (car (get (car *current-tile-list*) 'stock-list))))
  )


;; Takes a list of lists and returns one list
(defun flatten (?list)
  (if (eq ?list ())
      ()
    (append (car ?list) (flatten (cdr ?list))))
  )


;; Returns the list of ?chains in sorted order.
(defun sort-chains (?chains)
  (format t "~%entered sort-chains = ~s" ?chains)
  (stable-sort ?chains #'< :key #'chain-size)
  )


;; Finds list of all chains on board which have a Manhattan distance of 1
;; in the order of greatest connectivity to least connectivity
(defun close-chains (chains)
  (format t "~%entering close-chains~%")
  ;; make temp variable to hold existing chains, which can be manipulated
  (setq tchains chains)
  ;; list of the chains which are close to each other
  (setq closest-chains nil)

  ;; connectivity ?x ?y -------------------
  (dolist (temp tchains)
	  (dolist (temp2 (cdr tchains))
		  (cond ((eq (chain-distance (get temp 'tiles) (get temp2 'tiles)) 2)
			 (setf closest-chains (remove-duplicates (append closest-chains (list temp temp2))))
			 (setf tchains (remove temp tchains)))
			(t nil))))
  closest-chains
  )
  
;; Determine the size of chain ?x.  Returns the size, or NIL if
;; undefined.
(defun chain-size (?x)
  (format t "~%chain-size ~s ~s = ~d" ?x (get ?x 'tiles) (list-length (get ?x 'tiles)))
  (list-length (get ?x 'tiles))
  )
;;------------------------------------------------------------------------------


;; rank-tiles
;; This function takes the output of tagged-tiles and an
;; agent state and then ranks them based on 
;; 0 - Merge of a chain I own.
;; 1 - Grow of a chain I own.
;; 2 - Make a new chain.
;; 3 - Place near a chain I own.
;; 4 - None of the above.
;; It then returns a list of these tiles.

(defun rank-tiles (a b)
  ;; PRE: Takes agent state a and tagged tiles b
  ;; POST: Returns list as described above.

  (setq stocks-owned nil
	return-list nil
	tagged-tile nil
	mynum 0
	chain nil
	action nil
	own nil
	merge-chain nil
	merge-chains nil
  )
  
  (setf stocks-owned (car (cdr (cdr a))))

  (dolist (tagged-tile b)
	  ;; First, get the action that tile
	  ;; makes, MAKE, PLACE, MERGE, GROW.

	  (format t "~%Tagged-Tile: ~s" tagged-tile)

	  (setf action (car tagged-tile))
	  (if (equal action `MAKE)
	      (progn
		(format t "~%MAKE")
		(setf mynum 2)
	      )
	  )
	  (if (equal action `GROW)
	      ;; Handling GROWING. If we own the next
	      ;; item in the list, make mynum 0.
	      (progn
		(format t "~%GROW")
		(setf chain (car (cdr tagged-tile)))
		(setf own (do-i-own a chain))
		(if own
		    ( ;; We do own then we just set to 0
		      setf mynum 1
		    )
		    ( ;; We do not own, then set it to 4
		      setf mynum 4
		    )
		)
	      )
	  )
	  (if (equal action `PLACE)
	      ;; Handling PLACE. If we own the next
	      ;; item in the list, make mynum 3.
	      (progn
		(format t "~%PLACE")
		(setf chain (car (cdr tagged-tile)))
	        (setf own (do-i-own a chain))
		(if own
		    ( ;; We do own the chain set to 3
		     setf mynum 3
		    )
		    ( ;; We do not own, set it to 4.
		     setf mynum 4
		    )
		)
	      )
	  )
	  (if (equal action `MERGE)
	      ;; Handling MERGE. This is more complicated.
	      ;; We have to go through the stocks in merge
	      ;; and see if we own any of them. If we do
	      ;; then we can set action to 
	      (progn
		(format t "~%MERGE ~s" mynum)
		(setf merge-chains (cdr tagged-tile))
		(setf mynum 4) ;; Assume failure.
		(dolist (merge-chain merge-chains)
			(setf own (do-i-own a merge-chain))
			(if own
			    ;; Then set it to 1.
			    (progn (setf mynum 0)
			    (format t "~%I own this chain mynum: ~s" mynum))
			)
		) ;; dolist
		;; If we did not set it to 1 the whole time
		;; then it is still 4.
	      )
	  ) 
      
	  ;; Now we have the variable in mynum.
	  ;; Just add that to the list.

	  (format t "~%Adding a ~s" mynum)
	 
	  (if (equal return-list nil)
	      (setf return-list (list mynum))
	      (setf return-list (append return-list (list mynum)))
	  )

	  (setf mynum 4)

     ) ;; do list

;; Return the return-list

return-list
)

;; Function MAKE-CHAIN
;; determines what the new chain is going to be called
(defun make-chain (?avail-chains)
  ;; PRE: takes's id and list of available chains
  ;; POST: a chain is picked and sent to the engine

  (format t "~%entering make-chain with ?avail-chains = ~s~%" ?avail-chains)
  (setf ?x (random (length ?avail-chains)))
  (setf ?chain (nth ?x ?avail-chains))

  (setf *new-chain-name* ?chain)

  ?chain
)

;; Function GET-NEW_CHAIN-NAME
;; returns the name of the new chain
(defun get-new-chain-name()
  ;; PRE: new chain name must be picked already
  ;; POST: returns new chain name

  *new-chain-name*
)

;; Function PICK-STOCK-ACTION
;; pick how much to sell, trade, or hold in a merger.
(defun pick-stock-action (dominant-chain losing-chains the-world-state the-agent-state)
  ;; PRE: Takes two lists and the world state, the dominant-chain and
  ;; the losing-chains. It also takes the agent's current state.
  ;; POST: Returns a stock-action, an action to trade or sell or hold.

;; In this function we will determine whether to sell/trade/hold
;; based on the following principles:
;; 1.) Never hold anything.
;; 2.) If the agent owns the dominant chain, trade as many as possible.
;; 3.) If the agent does not own the dominant chain then sell everything.

;; Use the tile.lisp's do-i-own

  (setq own-dominant-chain nil
	stocks-left nil
	agent-owned-stocks nil
	dominant-chain-stocks-left nil
	losing-chain-stocks-left nil
	x nil
	y nil
	sell 0
	return-list nil
	)
  ;; added by Lisa/Luiza 05-29-01
  (setf *return-list* nil)
  
  (setf stocks-left (car (cdr (cdr the-world-state))))
  (setf own-dominant-chain (do-i-own the-agent-state dominant-chain))
  (setf agent-owned-stocks (car (cdr (cdr the-agent-state))))
  
  (if (equal own-dominant-chain T)
      (progn
	;; We do number 2 above, trade as many as possible.
	;; First find out what the dominant-chain has left in the market.
	
	(dolist (chain stocks-left)
		(if (equal (car chain) dominant-chain)
		    ;; If true, this is the dominant chain.
		    (setf dominant-chain-stocks-left (car (cdr chain)))
		    nil
		)
	) ;; dolist

	(format t "~%The Dominant Chain has ~s stocks left!" dominant-chain-stocks-left)

	;; Now go through the losing chain list.

	(dolist (chain losing-chains)
		;; For each losing chain find out what we own in
		;; it so we know what we can convert for.
		(dolist (l-chain agent-owned-stocks)
			(if (equal (car l-chain) chain)
			    ;; This is a losing chain if true.
			    (setf losing-chain-stocks-left (car (cdr l-chain)))
			    (setf losing-chain-stocks-left -1)
			)

			(format t "~%Losing Chain Stocks Left ~s" losing-chain-stocks-left)
			;; If there were anything to trade it 
			;; is now in losing-chain-stocks-left

			(if (> losing-chain-stocks-left -1)
			    (progn
			      ;; We now attempt to trade in as much
			      ;; as possible to the dominant chain.
			      (setf x (mod losing-chain-stocks-left 2))
			      (if (equal x 1)
				  (progn
				    (setf y (/ (- losing-chain-stocks-left 1) 2))
				    ;; Y is now the number we would
				    ;; like to trade in for.
				    (setf sell 1)
				  ) ;; if true
				  (progn
				    (setf y (/ losing-chain-stocks-left  2))
				    ;; Y is now the number we would
				    ;; like to trade in for.
				    (setf sell 0)
				  )
			      ) ;; if
			      (format t "~%I would like to trade: ~s" y)
			      (if (<= y dominant-chain-stocks-left)
				  (progn
				    ;; We're good to go and trade
				    ;; changed by Lisa 05-29-01 to add (TRADE 0 NIL NIL)
				    ;; in the case that you don't have any stocks in the losing chain, or only have 1
				    (if (eq y 0)
					(setf return-list (list (list `TRADE-STOCK 0 NIL NIL)))
				      (if (equal return-list nil)
					  (setf return-list (list (list `TRADE-STOCK (* y 2) (car l-chain) dominant-chain)))
					(setf return-list (append return-list (list (list `TRADE-STOCK (* y 2) (car l-chain) dominant-chain))))
					)
				      ) ;; if
				    (format t "~%return-list = ~s~%" return-list)	
				    
				    (setf dominant-chain-stocks-left (- dominant-chain-stocks-left y))
				  )
				  (progn
				    ;; We can only get some of them.
				    (setf max-tradeable (- y dominant-chain-stocks-left))
				    ;; We take what we can get.
				    ;; changed by Lisa 05-29-01 to add (TRADE 0 NIL NIL)
				    ;; in the case that there aren't enough dominant stocks left to trade in for
				    (if (eq y 0)
					(setf return-list (list (list `TRADE-STOCK 0 NIL NIL)))
				      (if (equal return-list nil)
					  (setf return-list (list (list `TRADE-STOCK (* dominant-chain-stocks-left 2) (car l-chain) dominant-chain)))
					(setf return-list (append return-list (list (list `TRADE-STOCK (* dominant-chain-stocks-left 2) (car l-chain) dominant-chain))))
					) ;; if 
				      ) ;; if
				    (setf dominant-chain-stocks 0)
				    (setf y (* max-tradeable 2))
				    ;; Now sell the rest.
				    (setf sell (+ sell y))
				 ) ;; progn
			    ) ;; if
		      
			      ;; Sell whatever stocks we had in sell.
			      ;; changed by Lisa 05-29-01 to add (SELL-STOCK 0 NIL)
			      (if (eq sell 0)
				  (progn (setf return-list (append return-list (list (list `SELL-STOCK 0 NIL))))
					 (format t "~%in first half, in sell = 0: return-list = ~s~%" return-list))
				;;				  (if (equal return-list nil)
				;;				      (setf return-list (list (list `SELL-STOCK sell (car l-chain))))
				(progn (setf return-list (append return-list (list (list `SELL-STOCK sell (car l-chain)))))
				       (format t "~%in first half, else = 0: return-list = ~s~%" return-list))
				;;				    ) ;; if
				) ;; if
			      ) ;; progn
			    
		     ) ;; if we had more than 0 stocks in this chain to trade.
			 
		     ;; Reset x, y, sell
		     (setf x 0)
		     (setf y 0)
		     (setf sell 0)

	       ) ;; dolist for every chain the agent owns stock in.
		;; added by Lisa/Luiza
		(setf *return-list* (append *return-list* (list return-list)))
		(format t "~%*return-list* = ~s, return-list = ~s~%" *return-list* return-list)
		(setf return-list nil)
	 ) ;; dolist for each losing chain in the merger
     ) ;; progn
     (progn
       ;; If we do not own the dominant chain the decision is 
       ;; to sell everything.
       (dolist (chain losing-chains)
	       ;; changed by Lisa 05-29-01:
	       (if (equal return-list nil)
		   (setf return-list (list (list `TRADE-STOCK 0 NIL NIL)))
		 (setf return-list (append return-list (list (list `TRADE-STOCK 0 NIL NIL)))))
	       ;; For each losing chain find out what we own in
	       ;; it so we know what we can convert for.
	       (dolist (l-chain agent-owned-stocks)    
		       ;; The l-chain is what is in the agent's store.
		       ;; we first see if we have found the losing
		       ;; chain in the agent's store.
		       (if (equal (car l-chain) chain)
			    ;; If true this is the losing chain
			    ;; in which we will just sell it all.
			    (progn
			      (setf sell (car (cdr l-chain)))
			      ;; changed by Lisa 05-29-01:
			      ;; if this is not true, we have no stock in that chain (SELL-STOCK 0 NIL)
			      (if (eq sell 0)
				  (setf return-list (append return-list (list (list `SELL-STOCK 0 NIL))))
				;; Sell whatever stocks we had in sell.
				;;			      (if (equal return-list nil)
				;;				  (setf return-list (list (list `SELL-STOCK sell (car l-chain))))
				(setf return-list (append return-list (list (list `SELL-STOCK sell (car l-chain))))))
				(format t "~%return-list = ~s~%" return-list)
				)
			  ) ;; if
			) ;; dolist for each chain the agent owns.
		;; added by Lisa/Luiza
		(format t "~%*return-list* = ~s, return-list = ~s~%" *return-list* return-list)
		(setf *return-list* (append *return-list* (list return-list)))
		(setf return-list nil)
		) ;; dolist for all the losing chains.
     ) ;; progn
   ) ;; if we owned the dominant chain or not.

;; Return the return-list

  (format t "~%*return-list* = ~s~%" *return-list*)
  *return-list*
) ;; pick-stock-action


;; Function CALC-PICK-DOMINANT-CHAIN-IN-MERGER
;; determines what chain is to become dominant in merger
(defun calc-pick-dominant-chain-in-merger(?chain-choices ?agent-state)
  ;; PRE: takes a list of chain options and the agent state
  ;; POST: returns a chain that is going to be the dominant chain

  ;;ALGORITHM: 
  ;; 1. Pick the chain that the agent has more stocks in
  ;;    (for this, you need to know the stocks the agent has)
  ;; 2. Otherwise, (if he does not have any stocks on neither of the chains)
  ;; pick at random

  (format t "~%Inside calc-pick-dominant-chain-in-merger...~%")

  (setq list-stock nil)

  ;; updates agent-state
  (setf *agent-state* ?agent-state)

  (format t "~%Chain choices received: ~s~%" ?chain-choices)

  (format t "~%Agent's state received: ~s~%" ?agent-state)

  (format t "~%Agent's state saved: ~s~%" *agent-state*)
  
  ;; gets list of stocks that agent has
  (setf ?agent-stocks (nth 2 ?agent-state))

  (format t "~%List of stocks that agent has: ~s~%" ?agent-stocks)

  ;; see how many stocks the agent has from each of the chains in the 
  ;; ?chain-choices list
  (dolist (choice ?chain-choices)
	  (dolist (chain ?agent-stocks)
		  (if (eql (car chain) choice)(setf list-stock (append list-stock (list chain))))))

  (format t "~%What agent has from the choices: ~s~%" list-stock)

  ;; find out which chain has the highest score
  (setf maxscorechain nil)
  (setf maxscore 0)

  (dolist (chain list-stock)
	  (format t "~%~s~%" chain)
	  (cond ((> (nth 1 chain) maxscore)(setf maxscore (nth 1 chain))
		(setf maxscorechain (nth 0 chain)))))

  ;; if maxscore was 0, then chain must be picked at random

  (cond ((eql maxscore 0 )
	 (setf ?x (random(length ?chain-choices)))
	 (setf maxscorechain (nth ?x ?chain-choices))))


  maxscorechain

)
