/*
  UserControllerConnector.java
  - This is the connector object which connects the User Controller to
  the system.
  2 May 2001
  Programmer: Michael Czajkowski
*/

// Package

// Imports

import java.io.*;
import java.net.*;
import java.util.Vector;

// <UserControllerConnector>

public class UserControllerConnector extends Connector{

    // ------ Private Data Fields ------

    private Socket game_socket_ = null;
    
    private SocketHandler game_socket_handler_ = null;

    // ------ Constructors ------

    public UserControllerConnector(String GAMEHOST, int GAMEPORT, int AGENTS, int GAMES){
	// PRE: Takes (String:+),(int:+),(int:+),(int:+)
	// POST: Returns type UserControllerConnector.

	super("lisp");

	try{
	    // First make the InetAddress to the game host.
	    
	    InetAddress game = InetAddress.getByName(GAMEHOST);
	    
	    // Now make the sockets and hope they bind :-)

	    game_socket_ = new Socket(game,GAMEPORT);

	} // try
	catch(UnknownHostException e){
	    // Illegal InetAddress;
	    System.err.println("Error. Cannot make connection to address specified. :: "+e);
	} // catch
	catch(ConnectException e){
	    // Had a connection Exception
	    System.err.println("Error. Could not make connection. Localized Message :: "+e.getLocalizedMessage()+" Stack Trace: ");
	    e.printStackTrace(System.err);
	} // catch
	catch(IOException e){
	    // Problem with socket creation.
	    System.err.println("Error. Could not make socket. :: "+e);
	} // catch

	// Now make the socket handler for the socket.

	InputStream i = null;
	OutputStream o = null;

	try{
	    i = game_socket_.getInputStream();
	    o = game_socket_.getOutputStream();
	} // try
	catch(Exception e){
	    System.err.println("Error. Problem getting stream from game server socket. Terminal Error :: "+e);
	    System.exit(1);
	} // catch

	BufferedReader br = new BufferedReader(new InputStreamReader(i));
	BufferedWriter wr = new BufferedWriter(new OutputStreamWriter(o));

	game_socket_handler_ = new SocketHandler(game_socket_,this,br,wr,"USER CONTROLLER");

	// And now start the handler's thread for the listening.

	game_socket_handler_.start();

	// Initialize the LISP interpreter.

	sendLispCommand("(load \"io.lisp\")");
	sendLispCommand("(setup-session "+GAMES+" "+AGENTS+")");

	// Send the registration request.

	game_socket_handler_.sendCommand("REGISTER_IO");

    } // constructor(String, int)

    // ------ Public Methods ------    

    public void sendCommandToGameServer(String COMMAND){
	// PRE: Takes (String:+)
	// POST: Returns nothing.

	// This method sends the command COMMAND to the Game server.
	// The command is essentially a lisp procedure call.

	game_socket_handler_.sendCommand(COMMAND);

    } // sendCommandToGameServer(String)

    public synchronized void handleLispCommand(String COMMAND){
	// PRE: Takes (String:+)
	// POST: Returns nothing.

	// This method is called when LISP has something to tell the
	// network. Of course what lisp outputs might not be information
	// to the network at all, so we have to look at COMMAND and
	// determine what to do from there.

	System.out.println("USER CONTROLLER's LISP SAYS:: "+COMMAND);

	// Look for special cases first.

        if(COMMAND.equals("COMMAND:END")){
	    // END OF PROGRAM.
	    killUserControllerConnection();
	} // if
	else if(COMMAND.equals("COMMAND:too-many-agents:END")){
	    // TOO MANY AGENTS.
	    return;
	} // else if

	// In here we will do the parsing.

	Vector command = parseCommand(COMMAND);

	// Get elements of command.

	String to = (String)command.elementAt(0);
	String from = (String)command.elementAt(1);
	String procedure = (String)command.elementAt(2);

	// Check for validity.

	if(to.equals("INVALID")){
	    // Invalid command. We ignore.
	} // if
	else{
	    // Valid command.

	    // The user controller has only one thing to send and it
	    // is to the game server by default.

	    sendCommandToGameServer(COMMAND);

	} // else

    } // handleLispCommand(String)

    public synchronized void handleNetCommand(SocketHandler SOCKET, String COMMAND){
	// PRE: Takes (SocketHandler:+)
	// POST: Returns nothing.

	// This method is called whenever the private server or the
	// game server wishes to tell the agent something. Its synchronized
	// since the game server and private server could call the method
	// at the same time. Of course we have to parse the command
	// into something we can send to the LISP process.

	System.out.println(SOCKET.getConnectionType() + " SAYS TO USER CONTROLLER:: " + COMMAND);

	// Look for pre-defined commands.

	if(COMMAND.equals("COMMAND:END")){
	    killUserControllerConnection();
	} // if


	// First parse out the command.

	Vector command = parseCommand(COMMAND);

	// Get elements of command.

	String to = (String)command.elementAt(0);
	String from = (String)command.elementAt(1);
	String procedure = (String)command.elementAt(2);

	// Check for validity.

	if(to.equals("INVALID")){
	    // Invalid command. We ignore.
	} // if
	else{
	    // Its a valid command string from the network.
	    // We then will send it to the LISP process running here.

	    sendLispCommand(procedure);

	} // else

    } // handleNetCommmand(String,String)

    public void killUserControllerConnection(){
	// PRE: Takes nothing.
	// POST: Returns nothing.

	// To do this, we first call the killLispProcess();
	killLispProcess();
	// Send the kill signal to the referee.
	sendCommandToGameServer("KILL_EVERYTHING");
	// Now we take the handlers and kill them too.
	game_socket_handler_.killSocketHandler();

	System.exit(0);
       
    } // killUserControllerConnection()

    // ------ Protected Methods ------

    // ------ Private Methods ------

    // ------ Public Static Void Main ------

    // ------ Test Method ------

    public void test(){
	// PRE: Takes nothing.
	// POST: Returns nothing.
	
	// Description:
	// This method outputs information about itself to System.out.

	System.out.println("Testing method of class: "+toString());
    
    } // test()

} // class xxx



