/*
  ServerConnector.java
  - A connector object for the up and rising Server. :-)
  29 April, 2001
  Programmer: Michael Czajkowski
*/

// Package

// Imports

import java.net.*;
import java.io.*;
import java.util.Vector;

// <ServerConnector>

public class ServerConnector extends Connector{

    // ------ Private Data Fields ------

    private ServerSocket server_socket_;
    private ServerSocketHandler server_socket_handler_;

    private SocketHandler user_controller_;
    private boolean controlled_;

    private Vector players_;
    private Vector observers_;
    private Vector connections_;

    private int id_counter_ = 0;
    private int max_player_count_ = 6;
    private String server_type_ = "REFEREE";

    // ------ Constructors ------

    public ServerConnector(String LOCALHOST, int LOCALPORT){
	// PRE: Takes (String:+),(int:+)
	// POST: Returns type ServerConnector.

	super("acl");
	
	players_ = new Vector();
        observers_ = new Vector();
	connections_ = new Vector();

	user_controller_ = null;
	controlled_ = false;

	max_player_count_ = 6;

	// Make the ServerSocket which we will listen to connections on.
    
	try{
	    InetAddress localaddress = InetAddress.getLocalHost();
	    server_socket_ = new ServerSocket(LOCALPORT,10,localaddress);
	} // try
	catch(UnknownHostException e){
	    // Could not get the local host. Big problem.
	    System.err.println("Error. Could not make a connection on this local machine. Terminal Error :: "+e);
	    System.exit(1);
	} // catch
	catch(IOException e){
	    // Means you cant make a connection on the port you request.      
	    System.err.println("Error. Could not open connection on port: "+LOCALPORT+ ". Error is Terminal :: "+e);
	    System.exit(1);
	} // catch

	// And now we make a ServerSocketHandler class which will deal
	// with the ServerSocket and accept its connections.

	server_socket_handler_ = new ServerSocketHandler(server_socket_,this);

	// We can now listen for and accept connections by starting the
	// server socket.

	server_socket_handler_.start();

	// Initialize all the engine lisp code.

	sendLispCommand("(load \"engine.lisp\")");
	sendLispCommand("(init-engine)");


    } // constructor(String,int)

    // ------ Public Methods ------

    public synchronized void broadcastToAll(String COMMAND){
	// PRE: Takes (String:+)
	// POST: Returns nothing.

	// This method broadcasts to all connections_ the
	// COMMAND message.

	for(int i=0;i<connections_.size();i++){
	    // Get each handler one at a time.
	    SocketHandler h = (SocketHandler)connections_.elementAt(i);
	    h.sendCommand(COMMAND);
	} // for

    } // broadcastToAll(String)
   
    public synchronized void handleLispCommand(String COMMAND){
	// PRE: Takes (String:+)
	// POST: Returns nothing.

	// This method is called when LISP has something to tell the
	// network. Of course what lisp outputs might not be information
	// to the network at all, so we have to look at COMMAND and
	// determine what to do from there.

	System.out.println("SERVER'S LISP SAYS:: "+COMMAND);

	// In here we will do the parsing.

	Vector command = parseCommand(COMMAND);

	// Get elements of command.

	String to = (String)command.elementAt(0);
	String from = (String)command.elementAt(1);
	String procedure = (String)command.elementAt(2);

	// Check for validity.

	if(to.equals("INVALID")){
	    // Invalid command. We ignore.
	} // if
	else{
	    // Valid command.

	    // The TO field is now considerably important
	    // since we have an array of agents.

	    if(to.equals("IO")){
		// User controller.
		user_controller_.sendCommand(COMMAND);
	    } // if
	    else{
		// Goes to an agent.
		try{
		    Integer to_1 = new Integer(to);
		    int to_2 = to_1.intValue();
		    SocketHandler agent = (SocketHandler)players_.elementAt(to_2);
		    System.out.println("Sending Message: "+procedure+" to Agent: "+to_2);
		    agent.sendCommand(COMMAND);
		} // try
		catch(NumberFormatException e){
		    // Wrong number format. Wasn't IO OR an agent!
		    System.err.println("Error. Cannot send message to: "+to);
		} // catch
	    } // else
	} // else

    } // handleLispCommand(String)

    public synchronized void handleNewConnection(Socket SOCKET){
	// PRE: Takes (java.net.Socket:+)
	// POST: Returns nothing.

	// The ServerSocketHandler calls this method when a new
	// connection is made, so we now have to make a SocketHandler
	// object and put the socket and its streams into it.

	// Get the name of the connection.

	InetAddress socketaddress = SOCKET.getInetAddress();
	String hostname = socketaddress.getHostName();

	// Get the streams.

	InputStream i = null;
	OutputStream o = null;

	try{
	    i = SOCKET.getInputStream();
	    o = SOCKET.getOutputStream();
	} // try
	catch(Exception e){
	    System.err.println("Error. Could not get streams from socket: "+hostname+". Failure to create socket, connection not accepted :: "+e);
	    return;
	} // catch
	
	// Now make the BufferedReader and BufferedWriter objects.

	BufferedReader br = new BufferedReader(new InputStreamReader(i));
	BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(o));

	// And then make the socket handler.

	SocketHandler sh = new SocketHandler(SOCKET,this,br,bw,hostname);

	// Add the SocketHandler to the connection list.

	connections_.addElement(sh);

	// And finally, start the SocketHandler up.

	sh.start();

	/* TESTING STUFF */

	// sh.sendCommand("HELLO AGENT!!");

    } // handleNewConnection
 
    public synchronized void handleNetCommand(SocketHandler SOCKET, String COMMAND){
	// PRE: Takes (SocketHandler:+),(String:+).
	// POST: Returns nothing.

	// This method is called whenever the private server or the
	// game server wishes to tell the agent something. Its synchronized
	// since the game server and private server could call the method
	// at the same time. Of course we have to parse the command
	// into something we can send to the LISP process.

	System.out.println(SOCKET.getConnectionType() + " SAYS TO SERVER:: " + COMMAND);

	// First we look for basic commands such as I'm a player
	// or a user controller.

	if(COMMAND.equals("REGISTER_PLAYER")){
	    System.out.println(SOCKET.getConnectionType() + " sent command " + COMMAND);
	    // new player trying to log on to game.
	    boolean AOK = handlePlayerRegistration(SOCKET);
	} // if
	else if(COMMAND.equals("REGISTER_IO")){
	    // user controller is logging on to game.
	    if(controlled_ == false){
		// We can make a new controller.
		controlled_ = true;
		// Set up the new info.
		user_controller_ = SOCKET;
		System.out.println(SOCKET.getConnectionType()+" is the user controller (IO).");
	    } // if
	    else{
		// Can not make a new controller.
		System.err.println(SOCKET.getConnectionType()+ " tried to become a user controller. This server already has one.");
	    } // else
	} // else if
	else if(COMMAND.equals("KILL_EVERYTHING")){
	    // user controller is killing the server.

	    killServerConnection();
	} // else if

	// First parse out the command.

	Vector command = parseCommand(COMMAND);

	// Get elements of command.

	String to = (String)command.elementAt(0);
	String from = (String)command.elementAt(1);
	String procedure = (String)command.elementAt(2);

	// Check for validity.

	if(to.equals("INVALID")){
	    // Invalid command. We ignore.
	} // if
	else{
	    // Its a valid command string from the network.
	    // We then will send it to the LISP process running here.

	    sendLispCommand(procedure);

	} // else

    } // handleNetCommand(String,String)

    public void killServerConnection(){
	// PRE: Takes nothing.
	// POST: Returns nothing.

	// To do this, we first call the killLispProcess();
	System.out.println("Killing Lisp Process.");
	killLispProcess();
	// Now we take the handlers and kill them too.
       
	broadcastToAll("KILL_EVERYTHING");

	System.out.println("Killing Connections.");
	for(int i=0;i<connections_.size();i++){
	    // Get each handler one at a time.	    
	    SocketHandler h = (SocketHandler)connections_.elementAt(i);
	    h.killSocketHandler();
	} // for

	// And then kill the ServerSocketHandler

	System.out.println("Killing Socket Handler");
	server_socket_handler_.killServerSocketHandler();

	System.exit(0);

    } // killServerConnection()

    // ------ Protected Methods ------

    // ------ Private Methods ------

    private boolean handlePlayerRegistration(SocketHandler SOCKET){
	// PRE: Takes (SocketHandler:+)
	// POST: Returns (boolean:+).

	// We have an agent trying to register as a player.
	// If we are full then reject trivially first.
		
	// Do we have the room first?
	if(players_.size()>=max_player_count_){
	    // Too full
	    return false;
	} // if

	// Now add the SocketHandler into the pool of players.

	int id = id_counter_;
	id_counter_++;

	SOCKET.sendCommand("COMMAND:"+id+":"+server_type_+":(main "+id+"):END");

	// Now put this socket into our players list.
	
	players_.addElement(SOCKET);
	System.out.println("New Player in Game AT: "+SOCKET.getConnectionType()+" whose ID will now be: "+id);

	return true;

    } // handlePlayerRegistration(String);

    // ------ Public Static Void Main ------

    // ------ Test Method ------

    public void test(){
	// PRE: Takes nothing.
	// POST: Returns nothing.
	
	// Description:
	// This method outputs information about itself to System.out.

	System.out.println("Testing method of class: "+toString());
    
    } // test()

} // class ServerConnector



