/*
  Agent.java
  - The program which runs the agent.
  29 April 2001
  Programmer: Michael Czajkowski
*/

// Package

// Imports

// <Agent>

public class Agent{

    // ------ Private Data Fields ------

    // ------ Constructors ------

    public Agent(){
	// PRE: Takes nothing.
	// POST: Returns type Agent.

    } // constructor()

    // ------ Public Methods ------

    // ------ Protected Methods ------

    // ------ Private Methods ------

    // ------ Public Static Void Main ------

    public static void main(String args[]){
	// PRE: Takes (String[]:+)
	/* 
	   args[0] - This machine's DNS name.
	   args[1] - The port this Machine's private server is on.
	   args[2] - The DNS name of the game server.
	   args[3] - The port which the game server is on.
	*/
	// POST: Returns nothing.

	int localport = 0;
	int gameport = 0;

	try{
	    Integer lp = new Integer(args[1]);
	    Integer gp = new Integer(args[3]);
	    localport = lp.intValue();
	    gameport = gp.intValue();
	} // try
	catch(NumberFormatException e){
	    // Input of a wrong number.
	    System.err.println("Error. Invalid port as input. This error is terminal :: "+e);
	    System.exit(1);
	} // catch
        
	// Make an agent connector with the above information.

	AgentConnector ac = new AgentConnector(args[0],args[2],localport,gameport);
	
	// Now that we have the agent connector up and running we can 
	// send messages to the server.

	// ac.sendCommandToGameServer("HI GAME SERVER!");
	// ac.sendCommandToPrivateServer("HI PRIVATE SERVER!");
    
	try{Thread.sleep(3000000);}catch(Exception e){}
	ac.killAgentConnection();
	
	System.out.println("Agent is Done.");

    } // public static void main(String[])

    // ------ Test Method ------

    public void test(){
	// PRE: Takes nothing.
	// POST: Returns nothing.
	
	// Description:
	// This method outputs information about itself to System.out.

	System.out.println("Testing method of class: "+toString());
    
    } // test()

} // class Agent



