;;;; Implementation for the  sophisitcated Agent
;;;; Luiza da Silva
;;;; Created in May, 2001

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; LIST OF ACTIONS OF AN AGENT

;; PLACE-TILE X 
;; BUY-STOCK QTY X 
;; SELL-STOCK QTY X 
;; TRADE-STOCK QTY X Y 
;; DRAW-TILE 
;; HOLD-STOCK QTY X 
;; CHOOSE-CHAIN X 
;; END-GAME

;;; OBJECT FOR AND AGENT-STATE

;; agent-state = (?money ?tiles ?stock)
;; where ?money = integer
;; ?tiles = list of #-letter pairs (ex. 1E, 12F)
;; ?stock = list of quantities owned for each stock (()()...())

;;; ORDER FOR THE HOTEL CHAINS WITHIN AN AGENT-STATE

;; ?stock list
;; *avail-chains = TOWER LUXOR AMERICAN WORLDWIDE FESTIVAL IMPERIAL CONTINENTAL
;; so an example of a ?stock variable would be
;; ((TOWER 0)(LUXOR 0)(AMERICAN 0)(WORLDWIDE O)(FESTIVAL 0)(IMPERIAL 0)(CONTINENTAL 0))
;; 
;;; WORLD STATE INFORMATION
;;
;; construct current state of world (in the server), minus *players* info

;; (setq current-state nil)

;; (setf current-state (append current-state (cons *current-player* nil)))

;; (setf current-state (append current-state (cons *avail-tiles* nil)))

;; (setf current-state (append current-state (cons *avail-stocks* nil)))

;; (setf current-state (append current-state (cons *avail-chains* nil)))

;; (setf current-state (append current-state (cons *played-tiles* nil)))
;; *played-tiles* will be a list of the type: (tile1 tile2 ...)

;; (setf current-state (append current-state (cons *existing-chains* nil)))
;; *existing-chains* will be a list of the type: ((chain1 (tile1 tile2))(chain2 (tile1 tile2))(chain3 (tile1 tile2)))

;; one example: (setf *new state* '(23 (a1 d3 f4 g5 h6) ((luxor 10) (imperial 40) (festival 15)) (festival luxor) (d3 b5 n2 m6)((tower (d3 m6))(continental (b5 n2))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;; AGENT INITIALIZATION
;;; Initializes agent.

(defun setup-agent (?id)

;;; Fields, all initialized to NIL in the beginning.

  ;; id - a unique identification for the agent, given by the
  ;; controller when the agent subscribes to it
  (defparameter *id*                 ?id)

  ;; heuristic - the name of the Heuristic which this Agent uses
  ;; (defparameter *heuristic*       NIL)

  ;; items money, tiles and stocks are going to be properties of an agent.
  
  (defparameter *stocks*       NIL)
  (defparameter *money*        0)
  (defparameter *tiles*        NIL)

;;; World state
  
  ;; the agent player who is making a move
  (defparameter *current-player*    NIL)

  ;; a list of all tiles that have not yet been chosen
  (defparameter *avail-tiles*       NIL)

  ;; a list of hotel chains which have not yet been defined in the board
  (defparameter *avail-chains*      NIL)

  ;; a list of the amounts of stock shares not yet sold for each hotel chain
  (defparameter *avail-stocks*      NIL)
  
  ;; a list of all chain and respective tiles which have been placed on the board
  (defparameter *played-tiles*      NIL)

  ;; a list of all hotel chains which have been placed on the board
  (defparameter *existing-chains*    NIL)

;;; Game playing

  (defparameter *last-place-tile-action*    NIL)
  (defparameter *rem-tiles*                 NIL)  
  (defparameter *last-buy-stock-action*     NIL)
  (defparameter *rem-stocks*                NIL)

  (defparameter *last-move*                 NIL)

;; Setting parameter to print
  (setf *print-right-margin* 1000)

NIL
)

;;;Communications portion sets my ID in time of initialization
;;(defun setID()
;;  (setf *id* ?x)
;;  (main)
;;)

;;; main() - Generates the agent; executable method to allow this 
;;; Agent to be instantiated and run on a separate machine from the 
;;; "referee"; it connects to the "controller" and waits for the 
;;; game to begin

(defun main (?id)

  (setup-agent ?id)

;;  (setf *id* ?id)
  (show-agent)
  
  (attach-agent)
  )

;; ***Added by Lisa: need to be able to reset agent attributes when a new game within same session is begun.
;; Is actually called by engine at the end of each game because the engine still knows who/where the players
;; are then, not at the beginning of the games.
(defun reset-agent (?id)
  (main ?id)
  ;; same seq of events occurs: init attrib, set ?id, attach to server
  )


;;; show-agent( ) - display information about agent

(defun show-agent( )
  (pprint *id*)
  (format t "*tiles*=~s~%" *tiles*)
  (format t "*money*=~d~%" *money*)
  (dolist (temp *stocks*)
	  (format t "~% ~s" temp)
	  (format t "~%")
	  )
  )

;;checks agent id
(defun id-check (?x)
  (if (eql *id* ?x) 1 0)
)

;;handles if a different id was received
(defun wrong-id(?id *id*)
  (format t "~%INVALID ID:~%")
)

;;;GAME PLAYING

;;requests attachment to server
(defun attach-agent()
  (format t "~%COMMAND:REFEREE:~A:(attach-agent ~A):END~%" *id* *id*)
)

;;receives initial world state from server
(defun set-initial-world-state(?id ?world-state)

  ;;sets current player's info
  (setf *current-player* (nth 0 ?world-state)) 

  ;;sets tiles available
  (setf *avail-tiles* (nth 1 ?world-state))

  ;;sets list of available stocks and the quantities
  (setf *avail-stocks* (nth 2 ?world-state))

  ;;sets list of available chains
  (setf *avail-chains* (nth 3 ?world-state))

  ;;sets list of playes tiles (tiles on the board)
  (setf *played-tiles* (nth 4 ?world-state))

  ;;sets list of existing chains
  (setf *existing-chains* (nth 5 ?world-state))

  ;;sets list of remaining stocks
  (setf *rem-stocks* (copy-list *avail-stocks*))
)

;;receives initial state from server if connection was accepted, otherwise resends attach-agent
(defun set-initial-state(?id ?initial-state)
  (cond ((eql (id-check ?id) 0)(attach-agent)) 
        (t (setf *money* (nth 0 ?initial-state))
           (setf *tiles* (nth 1 ?initial-state))
	   (setf *stocks* (nth 2 ?initial-state))))
)



;;server asks for agent's move
(defun agent-general-move(?id)

  ;;check id
  ;;(if (eql (id-check ?id) 0)(wrong-id ?id *id*))

  ;;for testing purposes
  ;;(setf *tiles* '(D3 F5 A10 H9 B2 G8))
  ;;(setf *avail-stocks* '((LUXOR 10)(IMPERIAL 13)(AMERICAN 9)))

  ;;make local copy of *avail-stocks*
  (setf ?stocks (copy-list *avail-stocks*))

  ;;place tile
  ;; ***Added by Lisa: making new random state to prevent seeding problems
  (let ((*random-state* (make-random-state t)))
    (setf x (random (length *tiles*)))
    )
  (if (eql x nil) (setf x 0))
  (setf tile (nth x *tiles*))
  (setf action-1 (list 'PLACE-TILE tile))

  ;;buy stocks
  ;; ***Added by Lisa: making new random state to prevent seeding problems
  (let ((*random-state* (make-random-state t)))
    (setf x (random(length ?stocks)))
    )
  (if (eql x nil) (setf x 0))
  (setf ?stock (nth x ?stocks))
  (setf action-2 (list 'BUY-STOCK 3 (car ?stock)))

  ;;make move list

  (setf actions (list action-1 action-2 '(DRAW-TILE)))

  ;;send command with move
  (format t "~%COMMAND:REFEREE:~A:(accept-move ~A '~A):END~%" *id* *id* actions)

  ;; save actions for future reference, i.e., if the place-tile or buy-stock action
  ;; ends up being invalid

  (setf *last-place-tile-action* action-1)
  (setf *last-buy-stock-action* action-2)
  (setf *last-move* actions)
)

;;updates agent state
(defun update-agent-state(?id ?current-state)
  (cond ((eql (id-check ?id) 0))
        (t (setf *money* (nth 0 ?current-state))
           (setf *tiles* (nth 1 ?current-state))
           (setf *stocks* (nth 2 ?current-state))))
  ;; make sure to understand and remember that the list of stocks also contains the quantities
  ;; this applies to both *stocks* and *avail-stocks*
)

;;updates world state
(defun update-world-state(?id ?current-state)

  ;;update current player's info
  (setf *current-player* (nth 0 ?current-state)) 

  ;;updates tiles available
  (setf *avail-tiles* (nth 1 ?current-state))

  ;;updates list of available stocks and the quantities
  (setf *avail-stocks* (nth 2 ?current-state))

  ;;updates list of available chains
  (setf *avail-chains* (nth 3 ?current-state))

  ;;updates list of playes tiles (tiles on the board)
  (setf *played-tiles* (nth 4 ?current-state))

  ;;updates list of existing chains
  (setf *existing-chains* (nth 5 ?current-state))

  ;;update list of remaining stocks
   (setf *rem-stocks* (copy-list *avail-stocks*))
)

;;when a chain is formed, agent is asked to pick the new chain
(defun pick-new-chain-name(?id ?avail-chains)

  ;;for now, pick a chain at random
  ;; ***Added by Lisa: making new random state to prevent seeding problems
  (let ((*random-state* (make-random-state t)))
    (setf ?x (random(length ?avail-chains)))
    )
  (setf ?chain (nth ?x ?avail-chains))
  
  ;;send command to server to call (set-new-chain-name(?id ?chain))
  
  (format t "~%COMMAND:REFEREE:~A:(set-new-chain-name ~A '~A):END~%" *id* *id* ?chain)
)

;;in a merger with >2 chains, agent must pick one among  dominant chain in merger
(defun pick-dominant-chain-in-merger(?id ?chain-choices)
  
  ;;for now, pick a chain at random
  ;; ***Added by Lisa: making new random state to prevent seeding problems
  (let ((*random-state* (make-random-state t)))
    (setf ?x (random(length ?chain-choices)))
    )
  (setf ?chain (nth ?x ?chain-choices))

  ;;send command to server to call (set-dominant-chain-in-merger(?id ?chain))

  (format t "~%COMMAND:REFEREE:~A:(set-dominant-chain-in-merger ~A '~A):END~%" *id* *id* ?chain)
)

;;agent chooses stock action
(defun choose-stock-action(?id ?dominant-chain ?merging-chains)

  (format t "~%Enter choose-stock-action~%")
  (setq actions nil)

  (dolist (chain ?merging-chains)
	(format t "~A~%" chain)
        (setf pair (assoc chain *stocks*))
	(format t "~A~%" pair)
        (setf a (nth 1 pair))
	(format t "~d~%" a)
	(if (eql a nil) (setf a 0))
	;; ***Added by Lisa: making new random state to prevent seeding problems
	(let ((*random-state* (make-random-state t)))
	  (setf b (random (+ a 1)))
	  )
	(format t "~d~%" b)
        (setf action1 (list 'TRADE-STOCK b chain ?dominant-chain))
        (setf a (- a b))
	(format t "~d~%" a)
	;; ***Added by Lisa: making new random state to prevent seeding problems
	(let ((*random-state* (make-random-state t)))
	  (setf b (random (+ a 1)))
	  )
	(format t "~d~%" b)
        (setf action2 (list 'HOLD-STOCK b chain))
        (setf a (- a b))
	(format t "~d~%" a)
        (setf action3 (list 'SELL-STOCK a chain))
	(setf actions (append actions (list (list action1 action2 action3)))))

  ;;send command to engine
  ;;(format t "~A~%" actions)
  (format t "~%COMMAND:REFEREE:~A:(agent-stock-action ~A '~A '~A '~A):END~%" *id* *id* ?dominant-chain ?merging-chains actions)

)

;;server offers agent to declare the game over, if it is a valid action in the agent's move
(defun declare-game-over (?id)

  ;; for now, decides if wants to declare game over at random too
  ;; ***Added by Lisa: making new random state to prevent seeding problems
  (let ((*random-state* (make-random-state t)))
    (setf ?answer (random 2))
    )
  
  (if (eql ?answer 0)(setf ?answer t)(setf ?answer nil))


  ;; then it sends answer to engine
  (format t "~%COMMAND:REFEREE:~A:(declare-game-over ~A ~A):END~%" *id* *id* ?answer)
  
)

;;server checks PLACE-TILE action from agent's move and realizes it is invalid.
;;server then asks for another tile-placing action
(defun invalid-place-tile(?id)

  ;; gets another place-tile action making sure it is different from the last one
  (setq action NIL)
  (setf tiles (copy-list *rem-tiles*))
  (setf bad-tile (nth 1 *last-place-tile-action*))
  (format t "~%~s~%" tiles)
  (setf tiles (remove bad-tile tiles))
  (format t "~%~s~%" tiles)

  (cond  ((eq (list-length tiles) 0) (setf action (list 'PLACE-TILE NIL)))
	 (t
	  ;; ***Added by Lisa: making new random state to prevent seeding problems
	  (let ((*random-state* (make-random-state t)))
	    (setf x (random(length tiles)))
	    )
	  (setf tile (nth x tiles))
	  (setf action (list 'PLACE-TILE tile))))
  
  ;; modifies last move to include the new place-tile action, replacing the invalid one
  (setf actions (list action *last-buy-stock-action* '(DRAW-TILE)))
  ;; saves place-tile action and entire new move
  (setf *last-place-tile-action* action)
  (setf *last-move* actions)
  ;;calls in server accept-new-place-tile(?id ?move)
  (format t "~%COMMAND:REFEREE:~A:(accept-new-place-tile ~A '~A):END~%" *id* *id* actions)
  )

;;server checks BUY-STOCK action from agent's move and realizes it is invalid.
;;server then asks for another stock buying action
(defun invalid-buy-stock(?id ?qty ?chain)

  (setq action NIL)

  ;;(setf *rem-stocks* (copy-list *avail-stocks*))

  ;;(setf bad-stock (nth 1 *last-buy-stock-action*))
  
  
  (dolist (pair *rem-stocks*)
	  (if (eql (car pair) ?chain)(setf *rem-stocks* (remove pair *rem-stocks*))))
  
  (cond ((eql *rem-stocks* nil) (setf action (list 'BUY-STOCK 0 NIL)))
	(t
	 ;; ***Added by Lisa: making new random state to prevent seeding problems
	 (let ((*random-state* (make-random-state t)))
	   (setf x (random(length *rem-stocks*)))
	   )
	 (setf stock (nth x *rem-stocks*))
	 (setf action (list 'BUY-STOCK 3 (car stock)))))
  

  ;;modifies last move to include the new buy-stock action, replacing the invalid one

  (setf actions (list *last-place-tile-action* action '(DRAW-TILE)))

  ;; saves place-tile action and entire new move
  (setf *last-buy-stock-action* action)
  (setf *last-move* actions)

  ;;calls in server accept-new-buy-stock(?id ?move)

  (format t "~%COMMAND:REFEREE:~A:(accept-new-buy-stock ~A '~A):END~%" *id* *id* actions)

)

;;server checks agent's move and realizes there is something wrong with the format
;;server then calls this function in agent so agent can check move format and 
;;resend move
(defun invalid-move-format(?id)

  ;;calls accept-move(?id ?revised-move) 

  ;;for now calls accept move again
  (format t "~%COMMAND:REFEREE:~A:(accept-move ~A '~A):END~%" *id* *id* *last-move*)  
) 

;; resends attachment request if engine is not ready
(defun engine-not-ready (?id)
  (format t "~%COMMAND:REFEREE:~A:(attach-agent ~A):END~%" *id* *id*)
)




