/*
 * Decompiled with CFR 0.152.
 */
package sals.single;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Random;
import sals.single.Tensor;

public class TensorMethods {
    public static Tensor importSparseTensor(String path, String delim, int[] modeLengths, int[] modesIdx, int valIdx, int[][] permutedIdx) throws IOException {
        String line;
        int omega = 0;
        BufferedReader br = new BufferedReader(new FileReader(path));
        while ((line = br.readLine()) != null) {
            ++omega;
        }
        br.close();
        return TensorMethods.importSparseTensor(path, delim, omega, modeLengths, modesIdx, valIdx, permutedIdx);
    }

    public static Tensor importSparseTensor(String path, String delim, int omega, int[] modeLengths, int[] modesIdx, int valIdx, int[][] permutedIdx) throws IOException {
        String line;
        int N = modesIdx.length;
        int[][] indices = new int[N][omega];
        float[] values = new float[omega];
        BufferedReader br = new BufferedReader(new FileReader(path));
        float sum = 0.0f;
        int i = 0;
        while ((line = br.readLine()) != null) {
            int n;
            String[] tokens = line.split(delim);
            if (permutedIdx != null) {
                n = 0;
                while (n < N) {
                    indices[n][i] = permutedIdx[n][Integer.valueOf(tokens[modesIdx[n]])];
                    ++n;
                }
            } else {
                n = 0;
                while (n < N) {
                    indices[n][i] = Integer.valueOf(tokens[modesIdx[n]]);
                    ++n;
                }
            }
            values[i] = Float.valueOf(tokens[valIdx]).floatValue();
            sum += values[i];
            ++i;
        }
        br.close();
        return new Tensor(N, modeLengths, omega, indices, values, sum);
    }

    public static Tensor createBinaryTensor(int omega, int[] modeLengths) {
        int N = modeLengths.length;
        int[][] indices = new int[N][omega];
        float[] values = new float[omega];
        Random random = new Random();
        float sum = 0.0f;
        int i = 0;
        while (i < omega) {
            int n = 0;
            while (n < N) {
                indices[n][i] = random.nextInt(modeLengths[n]);
                ++n;
            }
            values[i] = 1.0f;
            sum += 1.0f;
            ++i;
        }
        return new Tensor(N, modeLengths, omega, indices, values, sum);
    }

    public static int[][] cardinality(Tensor tensor) {
        int dimension = tensor.N;
        int[] modeSizes = tensor.modeLengths;
        int[][] cardinality = new int[dimension][];
        int dim = 0;
        while (dim < dimension) {
            cardinality[dim] = new int[modeSizes[dim]];
            ++dim;
        }
        int i = 0;
        while (i < tensor.omega) {
            int dim2 = 0;
            while (dim2 < dimension) {
                int[] nArray = cardinality[dim2];
                int n = tensor.indices[dim2][i];
                nArray[n] = nArray[n] + 1;
                ++dim2;
            }
            ++i;
        }
        return cardinality;
    }
}

