/*
 * Decompiled with CFR 0.152.
 */
package sals.single;

import sals.single.MultiThread;
import sals.single.Tensor;

public class Performance {
    public static double computeRMSE(final Tensor tensor, final float[][][] params, final int N, final int K, final int M) {
        final double[] loss = new double[1];
        new MultiThread<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object runJob(int m, int threadIndex) {
                double innerLoss = 0.0;
                int[] indicies = Performance.blockIndex(tensor.omega, M, m);
                int startIdx = indicies[0];
                int endIdx = indicies[1];
                int elemIdx = startIdx;
                while (elemIdx <= endIdx) {
                    float predict = 0.0f;
                    int k = 0;
                    while (k < K) {
                        float product = 1.0f;
                        int n = 0;
                        while (n < N) {
                            product *= params[n][tensor.indices[n][elemIdx]][k];
                            ++n;
                        }
                        predict += product;
                        ++k;
                    }
                    innerLoss += Math.pow(predict - tensor.values[elemIdx], 2.0);
                    ++elemIdx;
                }
                double[] dArray = loss;
                synchronized (loss) {
                    loss[0] = loss[0] + innerLoss;
                    // ** MonitorExit[var8_8] (shouldn't be in output)
                    return null;
                }
            }
        }.run(M, MultiThread.createJobList(M));
        return Math.sqrt(loss[0] / (double)tensor.omega);
    }

    public static double computeRMSE(final Tensor tensor, final float[][][] params, final float[][] bias, final float mu, final int N, final int K, final int M) {
        final double[] loss = new double[1];
        new MultiThread<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object runJob(int m, int threadIndex) {
                double innerLoss = 0.0;
                int[] indicies = Performance.blockIndex(tensor.omega, M, m);
                int startIdx = indicies[0];
                int endIdx = indicies[1];
                int elemIdx = startIdx;
                while (elemIdx <= endIdx) {
                    float predict = mu;
                    int n = 0;
                    while (n < N) {
                        predict += bias[n][tensor.indices[n][elemIdx]];
                        ++n;
                    }
                    int k = 0;
                    while (k < K) {
                        float product = 1.0f;
                        int n2 = 0;
                        while (n2 < N) {
                            product *= params[n2][tensor.indices[n2][elemIdx]][k];
                            ++n2;
                        }
                        predict += product;
                        ++k;
                    }
                    innerLoss += Math.pow(predict - tensor.values[elemIdx], 2.0);
                    ++elemIdx;
                }
                double[] dArray = loss;
                synchronized (loss) {
                    loss[0] = loss[0] + innerLoss;
                    // ** MonitorExit[var8_8] (shouldn't be in output)
                    return null;
                }
            }
        }.run(M, MultiThread.createJobList(M));
        return Math.sqrt(loss[0] / (double)tensor.omega);
    }

    private static int[] blockIndex(int n, int m, int i) {
        int[] result = new int[]{(int)Math.ceil(((double)n + 0.0) * (double)i / (double)m), (int)Math.ceil(((double)n + 0.0) * (double)(i + 1) / (double)m) - 1};
        return result;
    }
}

