/*
 * Decompiled with CFR 0.152.
 */
package sals.single;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import sals.single.Tensor;

public class Output {
    public static void calculateEstimate(Tensor queryTensor, float[][][] params, int N, int K) {
        int elemIdx = 0;
        while (elemIdx < queryTensor.omega) {
            float predict = 0.0f;
            int k = 0;
            while (k < K) {
                float product = 1.0f;
                int n = 0;
                while (n < N) {
                    product *= params[n][queryTensor.indices[n][elemIdx]][k];
                    ++n;
                }
                predict += product;
                ++k;
            }
            queryTensor.values[elemIdx] = predict;
            ++elemIdx;
        }
    }

    public static void calculateEstimate(Tensor queryTensor, float mu, float[][] bias, float[][][] params, int N, int K) {
        int elemIdx = 0;
        while (elemIdx < queryTensor.omega) {
            float predict = mu;
            int n = 0;
            while (n < N) {
                predict += bias[n][queryTensor.indices[n][elemIdx]];
                ++n;
            }
            int k = 0;
            while (k < K) {
                float product = 1.0f;
                int n2 = 0;
                while (n2 < N) {
                    product *= params[n2][queryTensor.indices[n2][elemIdx]][k];
                    ++n2;
                }
                predict += product;
                ++k;
            }
            queryTensor.values[elemIdx] = predict;
            ++elemIdx;
        }
    }

    public static void writeEstimate(String outputDir, Tensor query, int N) throws IOException {
        BufferedWriter bw = new BufferedWriter(new FileWriter(String.valueOf(outputDir) + File.separator + "estimate.out"));
        int elemIdx = 0;
        while (elemIdx < query.omega) {
            int dim = 0;
            while (dim < N) {
                bw.write(String.valueOf(query.indices[dim][elemIdx]) + ",");
                ++dim;
            }
            bw.write(String.valueOf(query.values[elemIdx]) + "\n");
            ++elemIdx;
        }
        bw.close();
    }

    public static void writeEstimate(String outputDir, Tensor query, int[][] permutedIdx, int N) throws IOException {
        int[][] invertedIdx = new int[N][];
        int dim = 0;
        while (dim < N) {
            invertedIdx[dim] = new int[permutedIdx[dim].length];
            int i = 0;
            while (i < permutedIdx[dim].length) {
                invertedIdx[dim][permutedIdx[dim][i]] = i;
                ++i;
            }
            ++dim;
        }
        BufferedWriter bw = new BufferedWriter(new FileWriter(String.valueOf(outputDir) + File.separator + "estimate.out"));
        int elemIdx = 0;
        while (elemIdx < query.omega) {
            int dim2 = 0;
            while (dim2 < N) {
                bw.write(String.valueOf(invertedIdx[dim2][query.indices[dim2][elemIdx]]) + ",");
                ++dim2;
            }
            bw.write(String.valueOf(query.values[elemIdx]) + "\n");
            ++elemIdx;
        }
        bw.close();
    }

    public static void writePerformance(String outputDir, double[][] performance, int Tout) throws IOException {
        BufferedWriter bw = new BufferedWriter(new FileWriter(String.valueOf(outputDir) + File.separator + "performance.out"));
        bw.write("iteration,elapsed_time,training_rmse,test_rmse");
        int outIter = 0;
        while (outIter < Tout) {
            bw.write(String.format("%d,%d,%f,%f\n", (int)performance[outIter][0], (int)performance[outIter][1], performance[outIter][2], performance[outIter][3]));
            ++outIter;
        }
        bw.close();
    }

    public static void writePerformanceTimeOnly(String outputDir, double[][] performance, int Tout) throws IOException {
        BufferedWriter bw = new BufferedWriter(new FileWriter(String.valueOf(outputDir) + File.separator + "performance.out"));
        bw.write("iteration,elapsed_time");
        int outIter = 0;
        while (outIter < Tout) {
            bw.write(String.format("%d,%d\n", (int)performance[outIter][0], (int)performance[outIter][1]));
            ++outIter;
        }
        bw.close();
    }

    public static void writeFactorMatrices(String outputDir, float[][][] params) throws IOException {
        outputDir = String.valueOf(outputDir) + File.separator + "factor_matrices";
        int N = params.length;
        File file = new File(outputDir);
        if (file.exists()) {
            file.delete();
        }
        file.mkdir();
        int n = 0;
        while (n < N) {
            BufferedWriter bw = new BufferedWriter(new FileWriter(String.valueOf(outputDir) + File.separator + (n + 1)));
            int modeLength = params[n].length;
            int K = params[n][0].length;
            int i = 0;
            while (i < modeLength) {
                StringBuffer buffer = new StringBuffer();
                buffer.append(i);
                buffer.append(",");
                int k = 0;
                while (k < K - 1) {
                    buffer.append(params[n][i][k]);
                    buffer.append(",");
                    ++k;
                }
                buffer.append(params[n][i][K - 1]);
                buffer.append("\n");
                bw.write(buffer.toString());
                ++i;
            }
            bw.close();
            ++n;
        }
    }

    public static void writeFactorMatrices(String outputDir, float[][][] params, int[][] permutedIdx) throws IOException {
        outputDir = String.valueOf(outputDir) + File.separator + "factor_matrices";
        int N = params.length;
        File file = new File(outputDir);
        if (file.exists()) {
            file.delete();
        }
        file.mkdir();
        int n = 0;
        while (n < N) {
            BufferedWriter bw = new BufferedWriter(new FileWriter(String.valueOf(outputDir) + File.separator + (n + 1)));
            int modeLength = params[n].length;
            int K = params[n][0].length;
            int i = 0;
            while (i < modeLength) {
                StringBuffer buffer = new StringBuffer();
                int rowIndex = permutedIdx[n][i];
                buffer.append(i);
                buffer.append(",");
                int k = 0;
                while (k < K - 1) {
                    buffer.append(params[n][rowIndex][k]);
                    buffer.append(",");
                    ++k;
                }
                buffer.append(params[n][rowIndex][K - 1]);
                buffer.append("\n");
                bw.write(buffer.toString());
                ++i;
            }
            bw.close();
            ++n;
        }
    }

    public static void writeBiases(String outputDir, float[][] bias) throws IOException {
        outputDir = String.valueOf(outputDir) + File.separator + "bias_terms";
        int N = bias.length;
        File file = new File(outputDir);
        if (file.exists()) {
            file.delete();
        }
        file.mkdir();
        int n = 0;
        while (n < N) {
            BufferedWriter bw = new BufferedWriter(new FileWriter(String.valueOf(outputDir) + File.separator + (n + 1)));
            int modeLength = bias[n].length;
            int i = 0;
            while (i < modeLength) {
                StringBuffer buffer = new StringBuffer();
                buffer.append(i);
                buffer.append(",");
                buffer.append(bias[n][i]);
                buffer.append("\n");
                bw.write(buffer.toString());
                ++i;
            }
            bw.close();
            ++n;
        }
    }

    public static void writeBiases(String outputDir, float[][] bias, int[][] permutedIdx) throws IOException {
        outputDir = String.valueOf(outputDir) + File.separator + "bias_terms";
        int N = bias.length;
        File file = new File(outputDir);
        if (file.exists()) {
            file.delete();
        }
        file.mkdir();
        int n = 0;
        while (n < N) {
            BufferedWriter bw = new BufferedWriter(new FileWriter(String.valueOf(outputDir) + File.separator + (n + 1)));
            int modeLength = bias[n].length;
            int i = 0;
            while (i < modeLength) {
                StringBuffer buffer = new StringBuffer();
                int rowIndex = permutedIdx[n][i];
                buffer.append(i);
                buffer.append(",");
                buffer.append(bias[n][rowIndex]);
                buffer.append("\n");
                bw.write(buffer.toString());
                ++i;
            }
            bw.close();
            ++n;
        }
    }

    public static void writeMU(String outputDir, float mu) throws IOException {
        outputDir = String.valueOf(outputDir) + File.separator + "mu";
        BufferedWriter bw = new BufferedWriter(new FileWriter(outputDir));
        bw.write("" + mu);
        bw.write("\n");
        bw.close();
    }
}

