/*
 * Decompiled with CFR 0.152.
 */
package sals.single;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MultiThread<T> {
    private Thread[] m_threads;
    private HashMap<Integer, T> m_results;
    private int m_numberOfJobs;
    private int m_finishingJobs;
    private Exception m_exception;
    private List<Integer> m_jobList;
    private Object m_lock;

    public abstract T runJob(int var1, int var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<Integer, T> run(int threadNum, List<Integer> jobList) {
        this.m_finishingJobs = 0;
        this.m_exception = null;
        this.m_jobList = jobList;
        this.m_numberOfJobs = jobList.size();
        this.m_threads = new Thread[threadNum];
        this.m_results = new HashMap();
        this.m_lock = new Object();
        int i = 0;
        while (i < threadNum) {
            final int threadIndex = i;
            Thread t = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    while (true) {
                        Object object;
                        int jobIndex = 0;
                        jobIndex = MultiThread.this.getJob();
                        if (jobIndex < 0) break;
                        try {
                            Object result = MultiThread.this.runJob(jobIndex, threadIndex);
                            object = MultiThread.this.m_lock;
                            synchronized (object) {
                                MultiThread multiThread = MultiThread.this;
                                multiThread.m_finishingJobs = multiThread.m_finishingJobs + 1;
                                MultiThread.this.m_lock.notifyAll();
                            }
                            if (result == null) continue;
                            MultiThread.this.setResult(jobIndex, result);
                        }
                        catch (Exception e) {
                            object = MultiThread.this.m_lock;
                            synchronized (object) {
                                MultiThread.this.m_exception = e;
                                MultiThread.this.m_lock.notifyAll();
                            }
                            return;
                        }
                    }
                }
            };
            t.start();
            this.m_threads[i] = t;
            ++i;
        }
        int finishingJobs = 0;
        while (true) {
            if (this.m_finishingJobs > finishingJobs) {
                finishingJobs = this.m_finishingJobs;
                continue;
            }
            Object object = this.m_lock;
            synchronized (object) {
                if (this.m_exception != null || this.m_finishingJobs == this.m_numberOfJobs) {
                    break;
                }
                try {
                    this.m_lock.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        if (this.m_exception != null) {
            throw new RuntimeException(this.m_exception);
        }
        return this.m_results;
    }

    public static List<Integer> createJobList(int n) {
        LinkedList<Integer> jobList = new LinkedList<Integer>();
        int i = 0;
        while (i < n) {
            jobList.add(i);
            ++i;
        }
        return jobList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getJob() {
        Object object = this.m_lock;
        synchronized (object) {
            block6: {
                block5: {
                    if (this.m_exception == null) break block5;
                    return -1;
                }
                if (!this.m_jobList.isEmpty()) break block6;
                return -1;
            }
            return this.m_jobList.remove(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setResult(int jobIndex, T result) {
        HashMap<Integer, T> hashMap = this.m_results;
        synchronized (hashMap) {
            this.m_results.put(jobIndex, result);
        }
    }
}

