/*
 * Decompiled with CFR 0.152.
 */
package sals.mr;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;

public class Output {
    public static void setOutputPath(String outputDir, Configuration conf) {
        conf.set("cardinality", String.valueOf(outputDir) + "/cardinality");
        conf.set("indexmap", String.valueOf(outputDir) + "/indexmap");
        conf.set("estimate", String.valueOf(outputDir) + "/estimate.out");
        conf.set("average_path", String.valueOf(outputDir) + "/mu");
        conf.set("performance", String.valueOf(outputDir) + "/performance.out");
        conf.set("performance temp", String.valueOf(outputDir) + "/performance.temp");
        conf.set("factor_matrices", String.valueOf(outputDir) + "/factor_matrices");
        conf.set("biases", String.valueOf(outputDir) + "/bias_terms");
    }

    public static void performanceOutput(Job job, Configuration conf) {
        int M = conf.getInt("M", 1);
        int Tout = conf.getInt("Tout", 0);
        double[][] result = new double[Tout][6];
        String userHome = System.getProperty("user.home");
        String tempFile = String.valueOf(userHome) + "/PEGASUS_TEMP_" + job.getJobID();
        String tempFile2 = String.valueOf(userHome) + "/PEGASUS_TEMP_2_" + job.getJobID();
        FileSystem fs = null;
        BufferedReader br = null;
        BufferedWriter bw = null;
        try {
            try {
                int outIter;
                fs = FileSystem.get((Configuration)conf);
                int m = 0;
                while (m < M) {
                    fs.copyToLocalFile(new Path(String.valueOf(conf.get("performance temp")) + "/" + m), new Path(tempFile));
                    br = new BufferedReader(new FileReader(tempFile));
                    outIter = 0;
                    while (outIter < Tout) {
                        String line = br.readLine();
                        String[] tokens = line.split(",");
                        result[outIter][0] = Integer.valueOf(tokens[0]).intValue();
                        result[outIter][1] = Math.max((double)Integer.valueOf(tokens[1]).intValue(), result[outIter][1]);
                        double[] dArray = result[outIter];
                        dArray[2] = dArray[2] + Double.valueOf(tokens[2]);
                        double[] dArray2 = result[outIter];
                        dArray2[3] = dArray2[3] + Double.valueOf(tokens[3]);
                        double[] dArray3 = result[outIter];
                        dArray3[4] = dArray3[4] + Double.valueOf(tokens[4]);
                        double[] dArray4 = result[outIter];
                        dArray4[5] = dArray4[5] + Double.valueOf(tokens[5]);
                        ++outIter;
                    }
                    br.close();
                    ++m;
                }
                new File(tempFile).delete();
                bw = new BufferedWriter(new FileWriter(tempFile2));
                String line = "iteration,elapsed_time,training_rmse,test_rmse\n";
                System.out.print(line);
                bw.write(line);
                outIter = 0;
                while (outIter < Tout) {
                    line = String.format("%d,%d,%f,%f\n", (int)result[outIter][0], (int)result[outIter][1], Math.sqrt(result[outIter][2] / result[outIter][3]), result[outIter][5] == 0.0 ? 0.0 : Math.sqrt(result[outIter][4] / result[outIter][5]));
                    System.out.print(line);
                    bw.write(line);
                    ++outIter;
                }
                bw.close();
                fs.copyFromLocalFile(true, new Path(tempFile2), new Path(conf.get("performance")));
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(0);
                try {
                    fs.close();
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                fs.close();
            }
            catch (Exception exception) {}
        }
    }
}

