/*
 * Decompiled with CFR 0.152.
 */
package sals.mr;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.TextInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.NullOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;
import sals.mr.ElementWritable;
import sals.mr.PairWritable;
import sals.single.ArrayMethods;

public class GreedyRowAssignment {
    public static void run(Configuration conf) throws IOException, ClassNotFoundException, InterruptedException {
        Job greedyJob1 = new Job(conf, "GREEDY_ROW_ASSIGNMENT-1");
        greedyJob1.setJarByClass(GreedyRowAssignment.class);
        greedyJob1.setMapperClass(GreedyMapper.class);
        greedyJob1.setCombinerClass(GreedyCombiner.class);
        greedyJob1.setReducerClass(GreedyReducer.class);
        greedyJob1.setInputFormatClass(TextInputFormat.class);
        greedyJob1.setOutputFormatClass(TextOutputFormat.class);
        greedyJob1.setMapOutputKeyClass(PairWritable.class);
        greedyJob1.setMapOutputValueClass(IntWritable.class);
        greedyJob1.setOutputKeyClass(PairWritable.class);
        greedyJob1.setOutputValueClass(IntWritable.class);
        greedyJob1.setNumReduceTasks(conf.getInt("M", 1));
        FileInputFormat.addInputPath((Job)greedyJob1, (Path)new Path(conf.get("training", "")));
        FileOutputFormat.setOutputPath((Job)greedyJob1, (Path)new Path(conf.get("cardinality", "")));
        greedyJob1.waitForCompletion(true);
        Job greedyJob2 = new Job(conf, "GREEDY_ROW_ASSIGNMENT-2");
        greedyJob2.setJarByClass(GreedyRowAssignment.class);
        greedyJob2.setMapperClass(Greedy2Mapper.class);
        greedyJob2.setReducerClass(Greedy2Reducer.class);
        greedyJob2.setInputFormatClass(TextInputFormat.class);
        greedyJob2.setOutputFormatClass(NullOutputFormat.class);
        greedyJob2.setMapOutputKeyClass(PairWritable.class);
        greedyJob2.setMapOutputValueClass(IntWritable.class);
        greedyJob2.setNumReduceTasks(1);
        FileInputFormat.addInputPath((Job)greedyJob2, (Path)new Path(conf.get("cardinality", "")));
        greedyJob2.waitForCompletion(true);
    }

    public static int[][] getPermutedIndex(int N, int[] modeLengths, Configuration conf) throws IOException {
        String line;
        int[][] permutedIdx = new int[N][];
        int i = 0;
        while (i < N) {
            permutedIdx[i] = new int[modeLengths[i]];
            ++i;
        }
        Path[] localFiles = DistributedCache.getLocalCacheFiles((Configuration)conf);
        FileInputStream fstream = new FileInputStream(localFiles[0].toString());
        DataInputStream in = new DataInputStream(fstream);
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        while ((line = br.readLine()) != null) {
            String[] tokens = line.trim().split(",");
            permutedIdx[Integer.valueOf((String)tokens[0]).intValue()][Integer.valueOf((String)tokens[1]).intValue()] = Integer.valueOf(tokens[2]);
        }
        br.close();
        return permutedIdx;
    }

    public static int[][] getInvertedIndex(int N, int[] modeLengths, Configuration conf) throws IOException {
        String line;
        int[][] invertedIdx = new int[N][];
        int i = 0;
        while (i < N) {
            invertedIdx[i] = new int[modeLengths[i]];
            ++i;
        }
        Path[] localFiles = DistributedCache.getLocalCacheFiles((Configuration)conf);
        FileInputStream fstream = new FileInputStream(localFiles[0].toString());
        DataInputStream in = new DataInputStream(fstream);
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        while ((line = br.readLine()) != null) {
            String[] tokens = line.trim().split(",");
            invertedIdx[Integer.valueOf((String)tokens[0]).intValue()][Integer.valueOf((String)tokens[2]).intValue()] = Integer.valueOf(tokens[1]);
        }
        br.close();
        return invertedIdx;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Greedy2Mapper
    extends Mapper<LongWritable, Text, PairWritable, IntWritable> {
        private PairWritable keyWritable = new PairWritable();
        private IntWritable intWritable = new IntWritable();

        public void map(LongWritable key, Text value, Mapper.Context context) throws IOException, InterruptedException {
            String[] tokens = value.toString().trim().split(",");
            this.keyWritable.set(Integer.valueOf(tokens[0]), Integer.valueOf(tokens[1]));
            this.intWritable.set(Integer.valueOf(tokens[2]).intValue());
            context.write((Object)this.keyWritable, (Object)this.intWritable);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Greedy2Reducer
    extends Reducer<PairWritable, IntWritable, NullWritable, NullWritable> {
        private int N;
        private int[] modeLengths;
        private int[][] cardinalities;
        private int M;
        Text keyText = new Text("");
        Text valueText = new Text("");

        public void setup(Reducer.Context context) {
            Configuration conf = context.getConfiguration();
            this.N = conf.getInt("N", 0);
            this.M = conf.getInt("M", 0);
            this.modeLengths = new int[this.N];
            this.cardinalities = new int[this.N][];
            int n = 0;
            while (n < this.N) {
                this.modeLengths[n] = conf.getInt("I" + (n + 1), 0);
                this.cardinalities[n] = new int[this.modeLengths[n]];
                ++n;
            }
        }

        public void reduce(PairWritable key, Iterable<IntWritable> values, Reducer.Context context) throws IOException, InterruptedException {
            for (IntWritable value : values) {
                this.cardinalities[key.left][key.right] = value.get();
            }
        }

        public void cleanup(Reducer.Context context) throws IOException {
            Configuration conf = context.getConfiguration();
            String userHome = System.getProperty("user.home");
            String tempFile = String.valueOf(userHome) + "/PEGASUS_TEMP_" + context.getJobID() + "_" + System.currentTimeMillis();
            BufferedWriter bw = new BufferedWriter(new FileWriter(tempFile));
            Random rand = new Random(0L);
            int[] totalValueSumOfEachReducer = new int[this.M];
            int n = this.N - 1;
            while (n >= 0) {
                context.progress();
                long modeLength = this.cardinalities[n].length;
                int[] sortedValue = this.cardinalities[n];
                ArrayIndexComparator comparator = new ArrayIndexComparator(sortedValue);
                Integer[] sortedIndex = comparator.createIndexArray();
                Arrays.sort(sortedIndex, comparator);
                Arrays.sort(sortedValue);
                ArrayMethods.reverse(sortedValue);
                int[] currentValueSumOfEachReducer = new int[this.M];
                int[] currentIndexOfEachReducer = new int[this.M];
                int[] maxIndexOfEachReducer = new int[this.M];
                int[][] indiciesOfEachReducer = new int[this.M][];
                int r = 0;
                while (r < this.M) {
                    maxIndexOfEachReducer[r] = (int)((long)Math.ceil((double)((long)(r + 1) * modeLength) / (0.0 + (double)this.M)) - (long)Math.ceil((double)((long)r * modeLength) / (0.0 + (double)this.M)));
                    indiciesOfEachReducer[r] = new int[maxIndexOfEachReducer[r]];
                    ++r;
                }
                int i = 0;
                while ((long)i < modeLength) {
                    int smallestIndex = 0;
                    int smallestValue = Integer.MAX_VALUE;
                    int smallestTotalValue = Integer.MAX_VALUE;
                    int smallestRemainingIndex = Integer.MAX_VALUE;
                    LinkedList<Integer> tieList = new LinkedList<Integer>();
                    int r2 = 0;
                    while (r2 < this.M) {
                        int remainingIndex = maxIndexOfEachReducer[r2] - currentIndexOfEachReducer[r2];
                        if (currentIndexOfEachReducer[r2] < maxIndexOfEachReducer[r2]) {
                            if (currentValueSumOfEachReducer[r2] < smallestValue) {
                                smallestIndex = r2;
                                smallestValue = currentValueSumOfEachReducer[r2];
                                smallestTotalValue = totalValueSumOfEachReducer[r2];
                                smallestRemainingIndex = remainingIndex;
                                tieList.clear();
                                tieList.add(r2);
                            } else if (currentValueSumOfEachReducer[r2] == smallestValue) {
                                if (remainingIndex < smallestRemainingIndex) {
                                    smallestIndex = r2;
                                    smallestValue = currentValueSumOfEachReducer[r2];
                                    smallestTotalValue = totalValueSumOfEachReducer[r2];
                                    smallestRemainingIndex = remainingIndex;
                                    tieList.clear();
                                    tieList.add(r2);
                                } else if (remainingIndex == smallestRemainingIndex) {
                                    if (totalValueSumOfEachReducer[r2] < smallestTotalValue) {
                                        smallestIndex = r2;
                                        smallestValue = currentValueSumOfEachReducer[r2];
                                        smallestTotalValue = totalValueSumOfEachReducer[r2];
                                        smallestRemainingIndex = remainingIndex;
                                        tieList.clear();
                                        tieList.add(r2);
                                    } else if (totalValueSumOfEachReducer[r2] == smallestTotalValue) {
                                        tieList.add(r2);
                                    }
                                }
                            }
                        }
                        ++r2;
                    }
                    int n2 = smallestIndex = ((Integer)tieList.get(rand.nextInt(tieList.size()))).intValue();
                    currentValueSumOfEachReducer[n2] = currentValueSumOfEachReducer[n2] + sortedValue[i];
                    int n3 = smallestIndex;
                    totalValueSumOfEachReducer[n3] = totalValueSumOfEachReducer[n3] + sortedValue[i];
                    indiciesOfEachReducer[smallestIndex][currentIndexOfEachReducer[smallestIndex]] = sortedIndex[i];
                    int n4 = smallestIndex;
                    currentIndexOfEachReducer[n4] = currentIndexOfEachReducer[n4] + 1;
                    ++i;
                }
                int index = 0;
                int r3 = 0;
                while (r3 < this.M) {
                    int i2 = 0;
                    while (i2 < indiciesOfEachReducer[r3].length) {
                        bw.write(String.valueOf(n) + "," + indiciesOfEachReducer[r3][i2] + "," + index + "\n");
                        ++index;
                        ++i2;
                    }
                    ++r3;
                }
                --n;
            }
            bw.close();
            FileSystem fs = FileSystem.get((Configuration)conf);
            fs.copyFromLocalFile(true, new Path(tempFile), new Path(conf.get("indexmap")));
            fs.close();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class ArrayIndexComparator
        implements Comparator<Integer> {
            private final int[] value;

            public ArrayIndexComparator(int[] value) {
                this.value = value;
            }

            public Integer[] createIndexArray() {
                Integer[] indexes = new Integer[this.value.length];
                int i = 0;
                while (i < this.value.length) {
                    indexes[i] = i;
                    ++i;
                }
                return indexes;
            }

            @Override
            public int compare(Integer index1, Integer index2) {
                return this.value[index2] - this.value[index1];
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class GreedyCombiner
    extends Reducer<PairWritable, IntWritable, PairWritable, IntWritable> {
        private IntWritable intWritable = new IntWritable(0);

        public void reduce(PairWritable key, Iterable<IntWritable> values, Reducer.Context context) throws IOException, InterruptedException {
            int count = 0;
            for (IntWritable value : values) {
                count += value.get();
            }
            this.intWritable.set(count);
            context.write((Object)key, (Object)this.intWritable);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class GreedyMapper
    extends Mapper<LongWritable, Text, PairWritable, IntWritable> {
        private String delim;
        private int[] modeIdx;
        private int N;
        private PairWritable keyWritable;
        private IntWritable intWritable;

        public void setup(Mapper.Context context) {
            Configuration conf = context.getConfiguration();
            ElementWritable.N = this.N = conf.getInt("N", 0);
            this.keyWritable = new PairWritable();
            this.intWritable = new IntWritable(1);
            this.modeIdx = new int[this.N];
            this.delim = conf.get("delim", " ");
            int i = 0;
            while (i < this.N) {
                this.modeIdx[i] = conf.getInt("i" + (i + 1), 0);
                ++i;
            }
        }

        public void map(LongWritable key, Text value, Mapper.Context context) throws IOException, InterruptedException {
            String[] tokens = value.toString().split(this.delim);
            int dim = 0;
            while (dim < this.N) {
                int index = Integer.valueOf(tokens[this.modeIdx[dim]]);
                this.keyWritable.set(dim, index);
                context.write((Object)this.keyWritable, (Object)this.intWritable);
                ++dim;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class GreedyReducer
    extends Reducer<PairWritable, IntWritable, Text, Text> {
        private Text keyText = new Text("");
        private Text valueText = new Text("");

        public void reduce(PairWritable key, Iterable<IntWritable> values, Reducer.Context context) throws IOException, InterruptedException {
            int count = 0;
            for (IntWritable value : values) {
                count += value.get();
            }
            this.keyText.set(String.valueOf(key.left) + "," + key.right + "," + count);
            context.write((Object)this.keyText, (Object)this.valueText);
        }
    }
}

