/*
 * Decompiled with CFR 0.152.
 */
package sals.mr;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Reducer;
import sals.mr.ElementWritable;
import sals.mr.GreedyRowAssignment;
import sals.mr.TripleWritable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CommonReducer
extends Reducer<TripleWritable, ElementWritable, NullWritable, NullWritable> {
    protected float epsilon = 1.0E-12f;
    protected int machineId;
    protected String baseLocalPath;
    protected String baseHDFSPath;
    protected Configuration conf;
    protected float[] oldBias;
    protected float[] curBias;
    protected int K;
    protected int M;
    protected int Tout;
    protected int Tin;
    protected float lambda;
    protected boolean useWeight;
    protected int waiting;
    protected int N;
    protected int[] modeLengths;
    protected int[][] nnzFiber;
    protected int[] nnzTraining;
    protected int[] nnzTest;
    protected int[] nnzQuery;
    protected int[] startIndex;
    protected int[] endIndex;
    protected ObjectOutputStream[] outIndexR;
    protected ObjectOutputStream[] outValueR;
    protected ObjectOutputStream[] outIndexRTest;
    protected ObjectOutputStream[] outValueRTest;
    protected ObjectOutputStream[] outIndexRQuery;
    protected ObjectOutputStream[] outValueRQuery;
    protected String tempLocalFile;

    public void setup(Reducer.Context context) {
        this.conf = context.getConfiguration();
        ElementWritable.N = this.N = this.conf.getInt("N", 0);
        this.modeLengths = new int[this.N];
        this.nnzFiber = new int[this.N][];
        this.nnzTraining = new int[this.N];
        this.nnzTest = new int[1];
        this.nnzQuery = new int[1];
        this.startIndex = new int[this.N];
        this.endIndex = new int[this.N];
        this.outIndexR = new ObjectOutputStream[this.N];
        this.outValueR = new ObjectOutputStream[this.N];
        this.outIndexRTest = new ObjectOutputStream[1];
        this.outValueRTest = new ObjectOutputStream[1];
        this.outIndexRQuery = new ObjectOutputStream[1];
        this.outValueRQuery = new ObjectOutputStream[1];
        int i = 0;
        while (i < this.N) {
            this.modeLengths[i] = this.conf.getInt("I" + (i + 1), 0);
            ++i;
        }
        this.M = this.conf.getInt("M", 0);
        this.K = this.conf.getInt("K", 0);
        this.Tout = this.conf.getInt("Tout", 0);
        this.Tin = this.conf.getInt("Tin", 0);
        this.baseHDFSPath = this.conf.get("output");
        this.waiting = this.conf.getInt("waiting", 100);
        this.lambda = this.conf.getFloat("lambda", 0.0f);
        this.useWeight = this.conf.getBoolean("use_weight", true);
        this.machineId = -1;
    }

    protected void updateBias(int n) throws FileNotFoundException, IOException {
        int blockLength = this.endIndex[n] - this.startIndex[n];
        float[] numerators = new float[blockLength];
        float[] denominators = new float[blockLength];
        ObjectInputStream inIndex = new ObjectInputStream(new BufferedInputStream(new FileInputStream(this.getLocalRPath(n, true, 0, false))));
        ObjectInputStream inValue = new ObjectInputStream(new BufferedInputStream(new FileInputStream(this.getLocalRPath(n, false, 0, false))));
        int elem = 0;
        while (elem < this.nnzTraining[n]) {
            int resultIndex;
            int[] index = new int[this.N];
            int _mode = 0;
            while (_mode < this.N) {
                index[_mode] = inIndex.readInt();
                ++_mode;
            }
            float r = inValue.readFloat();
            int n2 = resultIndex = index[n] - this.startIndex[n];
            numerators[n2] = numerators[n2] + (r + this.oldBias[index[n]]);
            int n3 = resultIndex;
            denominators[n3] = denominators[n3] + 1.0f;
            ++elem;
        }
        inIndex.close();
        inValue.close();
        int i = 0;
        while (i < blockLength) {
            if (denominators[i] != 0.0f) {
                int n4 = i;
                denominators[n4] = denominators[n4] + this.lambda * (float)(this.useWeight ? this.nnzFiber[n][i] : 1);
                int rowIndex = i + this.startIndex[n];
                float result = numerators[i] / denominators[i];
                if (result > -this.epsilon && result < this.epsilon) {
                    result = 0.0f;
                }
                this.curBias[rowIndex] = result;
            }
            ++i;
        }
    }

    protected double updateRWithBias(int n, int nBias, int type, boolean measureCost) throws FileNotFoundException, IOException {
        double errorSum = 0.0;
        ObjectInputStream inIndex = null;
        ObjectInputStream inValue = null;
        ObjectOutputStream outValue = null;
        inIndex = new ObjectInputStream(new BufferedInputStream(new FileInputStream(this.getLocalRPath(n, true, type, false))));
        inValue = new ObjectInputStream(new BufferedInputStream(new FileInputStream(this.getLocalRPath(n, false, type, false))));
        outValue = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(this.getLocalRPath(n, false, type, true))));
        int nnz = 0;
        nnz = type == 0 ? this.nnzTraining[n] : (type == 1 ? this.nnzTest[n] : this.nnzQuery[n]);
        int elem = 0;
        while (elem < nnz) {
            int[] index = new int[this.N];
            float r = 0.0f;
            int _mode = 0;
            while (_mode < this.N) {
                index[_mode] = inIndex.readInt();
                ++_mode;
            }
            r = inValue.readFloat();
            r = r + this.oldBias[index[nBias]] - this.curBias[index[nBias]];
            outValue.writeFloat(r);
            if (measureCost) {
                errorSum += (double)(r * r);
            }
            ++elem;
        }
        inIndex.close();
        inValue.close();
        outValue.close();
        this.replace(this.getLocalRPath(n, false, type, false));
        return errorSum;
    }

    protected void communicateBias(int outIter, int n, Reducer.Context context, FileSystem fs) throws IOException {
        Path outPath = new Path(this.getHDFSBiasParamPath(outIter, n, this.machineId, false));
        FSDataOutputStream out = fs.create(outPath);
        int i = this.startIndex[n];
        while (i < this.endIndex[n]) {
            out.writeFloat(this.curBias[i]);
            ++i;
        }
        out.close();
        this.markBiasWrite(outIter, n, fs);
        boolean[] markReadComplete = new boolean[this.M];
        markReadComplete[this.machineId] = true;
        while (true) {
            long requestTime = System.currentTimeMillis();
            FileStatus[] statusList = fs.listStatus(new Path(this.getHDFSBiasParamPath(outIter, n, true)));
            CommonReducer.shuffle(statusList);
            FileStatus[] fileStatusArray = statusList;
            int n2 = statusList.length;
            int n3 = 0;
            while (n3 < n2) {
                block20: {
                    FileStatus status = fileStatusArray[n3];
                    int _machineId = Integer.valueOf(status.getPath().getName());
                    if (!markReadComplete[_machineId]) {
                        FSDataInputStream in = null;
                        try {
                            try {
                                in = fs.open(new Path(this.getHDFSBiasParamPath(outIter, n, _machineId, false)));
                                int i2 = this.getStartIndex(n, _machineId);
                                while (i2 < this.getStartIndex(n, _machineId + 1)) {
                                    this.curBias[i2] = in.readFloat();
                                    ++i2;
                                }
                            }
                            catch (Exception e) {
                                System.out.println(e.getMessage());
                                context.getCounter("Error", "err").increment(1L);
                                try {
                                    in.close();
                                }
                                catch (Exception exception) {}
                                break block20;
                            }
                        }
                        catch (Throwable throwable) {
                            try {
                                in.close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            throw throwable;
                        }
                        try {
                            in.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        markReadComplete[_machineId] = true;
                    }
                }
                ++n3;
            }
            boolean markAll = true;
            int _machineId = 0;
            while (_machineId < this.M) {
                if (!markReadComplete[_machineId]) {
                    markAll = false;
                    break;
                }
                ++_machineId;
            }
            if (markAll) break;
            context.progress();
            long timeToWait = (long)((double)this.waiting * Math.random()) - (System.currentTimeMillis() - requestTime);
            if (timeToWait <= 0L) continue;
            try {
                Thread.sleep(timeToWait);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    protected void markBiasWrite(int outIter, int n, FileSystem fs) {
        block12: {
            FSDataOutputStream out;
            while (true) {
                out = null;
                try {
                    out = fs.create(new Path(this.getHDFSBiasParamPath(outIter, n, this.machineId, true)));
                    break block12;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    System.out.println("Mark write Failed");
                    try {
                        out.close();
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                    continue;
                }
                break;
            }
            finally {
                try {
                    out.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    protected void markWrite(int outIter, int k, int inIter, int n, FileSystem fs) {
        block12: {
            FSDataOutputStream out;
            while (true) {
                out = null;
                try {
                    out = fs.create(new Path(this.getHDFSParamPath(outIter, k, inIter, n, this.machineId, true)));
                    break block12;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    System.out.println("Mark write Failed");
                    try {
                        out.close();
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                    continue;
                }
                break;
            }
            finally {
                try {
                    out.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    protected void writeBiasParams(int n) throws FileNotFoundException, IOException {
        ObjectOutputStream os = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(this.getLocalBiasParamPath(n, false))));
        int row = 0;
        while (row < this.modeLengths[n]) {
            os.writeFloat(this.curBias[row]);
            ++row;
        }
        os.close();
    }

    protected void loadBiasFromLocal(int n) throws FileNotFoundException, IOException {
        this.curBias = new float[this.modeLengths[n]];
        ObjectInputStream in = new ObjectInputStream(new BufferedInputStream(new FileInputStream(this.getLocalBiasParamPath(n, false))));
        int i = 0;
        while (i < this.modeLengths[n]) {
            this.curBias[i] = in.readFloat();
            ++i;
        }
        in.close();
    }

    protected void createParamMatrix(int n, int k, float scale, Random random, Reducer.Context context) throws IOException {
        int col = 0;
        while (col < k) {
            context.progress();
            ObjectOutputStream os = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(this.getLocalParamPath(n, col, false))));
            int row = 0;
            while (row < this.modeLengths[n]) {
                os.writeFloat(random.nextFloat() * scale);
                ++row;
            }
            os.close();
            ++col;
        }
    }

    protected void createBiasTerms(int n, Reducer.Context context) throws IOException {
        ObjectOutputStream os = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(this.getLocalBiasParamPath(n, false))));
        int row = 0;
        while (row < this.modeLengths[n]) {
            os.writeFloat(0.0f);
            ++row;
        }
        os.close();
    }

    protected String getLocalRPath(int n, boolean isIndex, int type, boolean isTemp) {
        if (isIndex) {
            if (type == 0) {
                return String.valueOf(this.baseLocalPath) + "/indexR" + n + (isTemp ? "_T" : "");
            }
            if (type == 1) {
                return String.valueOf(this.baseLocalPath) + "/indexRT" + n + (isTemp ? "_T" : "");
            }
            return String.valueOf(this.baseLocalPath) + "/indexRQ" + n + (isTemp ? "_T" : "");
        }
        if (type == 0) {
            return String.valueOf(this.baseLocalPath) + "/valueR" + n + (isTemp ? "_T" : "");
        }
        if (type == 1) {
            return String.valueOf(this.baseLocalPath) + "/valueRT" + n + (isTemp ? "_T" : "");
        }
        return String.valueOf(this.baseLocalPath) + "/valueRQ" + n + (isTemp ? "_T" : "");
    }

    protected String getLocalParamPath(int n) {
        return String.valueOf(this.baseLocalPath) + "/" + n;
    }

    protected String getLocalParamPath(int n, int k, boolean isTemp) {
        return String.valueOf(this.getLocalParamPath(n)) + "/" + k + (isTemp ? "_T" : "");
    }

    protected String getLocalBiasParamPath(int n, boolean isTemp) {
        return String.valueOf(this.getLocalParamPath(n)) + "/B" + (isTemp ? "_T" : "");
    }

    protected String getHDFSParamPath(int outIter, int k, int inIter, int n, boolean log) {
        String path = this.baseHDFSPath;
        path = log ? String.valueOf(path) + "/log/" : String.valueOf(path) + "/data/";
        path = String.valueOf(path) + outIter + "/" + k + "/" + inIter + "/" + n;
        return path;
    }

    protected String getHDFSParamPath(int outIter, int k, int inIter, int n, int m, boolean log) {
        return String.valueOf(this.getHDFSParamPath(outIter, k, inIter, n, log)) + "/" + m;
    }

    protected String getHDFSBiasParamPath(int outIter, int n, boolean log) {
        String path = this.baseHDFSPath;
        path = log ? String.valueOf(path) + "/log/" : String.valueOf(path) + "/data/";
        path = String.valueOf(path) + outIter + "/B/" + n;
        return path;
    }

    protected String getHDFSBiasParamPath(int outIter, int n, int m, boolean log) {
        return String.valueOf(this.getHDFSBiasParamPath(outIter, n, log)) + "/" + m;
    }

    protected int getStartIndex(int n, int m) {
        return (int)Math.ceil((double)(m * this.modeLengths[n]) / (0.0 + (double)this.M));
    }

    protected void replace(String path) {
        File newFile;
        File oriFile = new File(path);
        boolean success = oriFile.delete();
        if (!success) {
            System.out.println(String.valueOf(path) + " delete Failed");
        }
        if (!(success = (newFile = new File(String.valueOf(path) + "_T")).renameTo(new File(path)))) {
            System.out.println(String.valueOf(path) + " replace Failed");
        }
    }

    protected static void shuffle(FileStatus[] status) {
        int n = status.length;
        Random random = new Random();
        int i = 0;
        while (i < n) {
            int randI = random.nextInt(n - i);
            FileStatus temp = status[n - i - 1];
            status[n - i - 1] = status[randI];
            status[randI] = temp;
            ++i;
        }
    }

    protected void writeBiasesResults(Reducer.Context context) throws IOException, InterruptedException {
        int[][] invertedIdx = GreedyRowAssignment.getInvertedIndex(this.N, this.modeLengths, this.conf);
        int n = 0;
        while (n < this.N) {
            BufferedWriter bw = new BufferedWriter(new FileWriter(this.tempLocalFile));
            ObjectInputStream br = new ObjectInputStream(new FileInputStream(this.getLocalBiasParamPath(n, false)));
            int i = 0;
            while (i < this.modeLengths[n]) {
                StringBuffer buffer = new StringBuffer();
                buffer.append(invertedIdx[n][i]);
                buffer.append(",");
                buffer.append(br.readFloat());
                buffer.append("\n");
                bw.write(buffer.toString());
                ++i;
            }
            br.close();
            bw.close();
            FileSystem fs = FileSystem.get((Configuration)this.conf);
            fs.copyFromLocalFile(true, new Path(this.tempLocalFile), new Path(String.valueOf(this.conf.get("biases", "")) + "/" + (n + 1)));
            fs.close();
            ++n;
        }
    }

    protected void writePerformance(Reducer.Context context, double[][] result) throws IOException {
        BufferedWriter bw = new BufferedWriter(new FileWriter(this.tempLocalFile));
        int outIter = 0;
        while (outIter < this.Tout) {
            bw.write(String.format("%d,%d,%f,%d,%f,%d\n", (int)result[outIter][0] + 1, (int)result[outIter][1], result[outIter][2], (int)result[outIter][3], result[outIter][4], (int)result[outIter][5]));
            ++outIter;
        }
        bw.close();
        FileSystem fs = FileSystem.get((Configuration)this.conf);
        fs.copyFromLocalFile(true, new Path(this.tempLocalFile), new Path(String.valueOf(this.conf.get("performance temp", "")) + "/" + this.machineId));
        fs.close();
    }

    protected void writeEstimate(Reducer.Context context) throws IOException, InterruptedException {
        int[][] invertedIdx = GreedyRowAssignment.getInvertedIndex(this.N, this.modeLengths, this.conf);
        BufferedWriter bw = new BufferedWriter(new FileWriter(this.tempLocalFile));
        ObjectInputStream inIndex = new ObjectInputStream(new BufferedInputStream(new FileInputStream(this.getLocalRPath(0, true, 2, false))));
        ObjectInputStream inValue = new ObjectInputStream(new BufferedInputStream(new FileInputStream(this.getLocalRPath(0, false, 2, false))));
        int nnz = this.nnzQuery[0];
        int elem = 0;
        while (elem < nnz) {
            StringBuffer buffer = new StringBuffer();
            int[] index = new int[this.N];
            int _mode = 0;
            while (_mode < this.N) {
                index[_mode] = invertedIdx[_mode][inIndex.readInt()];
                buffer.append(String.valueOf(index[_mode]) + ",");
                ++_mode;
            }
            buffer.append("" + -1.0f * inValue.readFloat());
            bw.write(String.valueOf(buffer.toString()) + "\n");
            ++elem;
        }
        inIndex.close();
        inValue.close();
        bw.close();
        FileSystem fs = FileSystem.get((Configuration)this.conf);
        fs.copyFromLocalFile(true, new Path(this.tempLocalFile), new Path(String.valueOf(this.conf.get("estimate", "")) + "/" + this.machineId));
        fs.close();
    }

    protected void writeFactormatricesResult(Reducer.Context context) throws IOException, InterruptedException {
        int[][] invertedIdx = GreedyRowAssignment.getInvertedIndex(this.N, this.modeLengths, this.conf);
        int n = 0;
        while (n < this.N) {
            BufferedWriter bw = new BufferedWriter(new FileWriter(this.tempLocalFile));
            ObjectInputStream[] brs = new ObjectInputStream[this.K];
            int k = 0;
            while (k < this.K) {
                brs[k] = new ObjectInputStream(new FileInputStream(this.getLocalParamPath(n, k, false)));
                ++k;
            }
            int i = 0;
            while (i < this.modeLengths[n]) {
                StringBuffer buffer = new StringBuffer();
                buffer.append(invertedIdx[n][i]);
                int k2 = 0;
                while (k2 < this.K) {
                    buffer.append(",");
                    buffer.append(brs[k2].readFloat());
                    ++k2;
                }
                buffer.append("\n");
                bw.write(buffer.toString());
                ++i;
            }
            k = 0;
            while (k < this.K) {
                brs[k].close();
                ++k;
            }
            bw.close();
            FileSystem fs = FileSystem.get((Configuration)this.conf);
            fs.copyFromLocalFile(true, new Path(this.tempLocalFile), new Path(String.valueOf(this.conf.get("factor_matrices", "")) + "/" + (n + 1)));
            fs.close();
            ++n;
        }
    }
}

