/*
 * Decompiled with CFR 0.152.
 */
package sals.mr;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;
import sals.mr.ElementWritable;
import sals.mr.TripleWritable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CommonMapper
extends Mapper<LongWritable, Text, TripleWritable, ElementWritable> {
    public static final int TYPE_TRAINING = 0;
    public static final int TYPE_TEST = 1;
    public static final int TYPE_QUERY = 2;
    private int M;
    private String delim;
    private int[] modeIdx;
    private int valueIdx;
    private int N;
    private int[] modeLengths;
    private TripleWritable position;
    private ElementWritable entry;
    private int[][] permutedIdx = null;
    private int type;

    public void setup(Mapper.Context context) throws IOException {
        String line;
        this.type = this.getType();
        Configuration conf = context.getConfiguration();
        this.N = conf.getInt("N", 0);
        this.permutedIdx = new int[this.N][];
        ElementWritable.N = this.N;
        this.position = new TripleWritable();
        this.entry = new ElementWritable();
        this.modeIdx = new int[this.N];
        this.modeLengths = new int[this.N];
        this.delim = conf.get("delim", " ");
        int i = 0;
        while (i < this.N) {
            this.modeIdx[i] = conf.getInt("i" + (i + 1), 0);
            this.modeLengths[i] = conf.getInt("I" + (i + 1), 0);
            this.permutedIdx[i] = new int[this.modeLengths[i]];
            ++i;
        }
        this.valueIdx = conf.getInt("iv", 0);
        this.M = conf.getInt("M", 0);
        Path[] localFiles = DistributedCache.getLocalCacheFiles((Configuration)conf);
        FileInputStream fstream = new FileInputStream(localFiles[0].toString());
        DataInputStream in = new DataInputStream(fstream);
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        while ((line = br.readLine()) != null) {
            String[] tokens = line.trim().split(",");
            this.permutedIdx[Integer.valueOf((String)tokens[0]).intValue()][Integer.valueOf((String)tokens[1]).intValue()] = Integer.valueOf(tokens[2]);
        }
        br.close();
    }

    public void map(LongWritable key, Text value, Mapper.Context context) throws IOException, InterruptedException {
        String[] tokens = value.toString().split(this.delim);
        int[] index = new int[this.N];
        int[] bIndex = new int[this.N];
        int i = 0;
        while (i < this.N) {
            index[i] = this.permutedIdx[i][Integer.valueOf(tokens[this.modeIdx[i]])];
            bIndex[i] = Math.min(index[i] * this.M / this.modeLengths[i], this.M - 1);
            ++i;
        }
        float val = Float.NaN;
        if (this.type != 2) {
            val = Float.valueOf(tokens[this.valueIdx]).floatValue();
        }
        boolean isTraining = this.type == 0;
        this.entry.set(index, val, isTraining);
        int i2 = 0;
        while (i2 < this.N) {
            this.position.set(bIndex[i2], i2, index[i2]);
            context.write((Object)this.position, (Object)this.entry);
            if (!isTraining) break;
            ++i2;
        }
    }

    protected abstract int getType();

    public static class QueryMapper
    extends CommonMapper {
        protected int getType() {
            return 2;
        }
    }

    public static class TestMapper
    extends CommonMapper {
        protected int getType() {
            return 1;
        }
    }

    public static class TrainingMapper
    extends CommonMapper {
        protected int getType() {
            return 0;
        }
    }
}

