/*
 * Decompiled with CFR 0.152.
 */
package sals.mr;

import java.io.IOException;
import java.net.URI;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.input.MultipleInputs;
import org.apache.hadoop.mapreduce.lib.input.TextInputFormat;
import org.apache.hadoop.mapreduce.lib.output.NullOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import sals.mr.Average;
import sals.mr.CDTFReducer;
import sals.mr.CommonMapper;
import sals.mr.CommonPartitioner;
import sals.mr.ElementWritable;
import sals.mr.GreedyRowAssignment;
import sals.mr.Output;
import sals.mr.TripleWritable;

public class CDTF
extends Configured
implements Tool {
    private boolean useBias = false;

    public CDTF(boolean useBias) {
        this.useBias = useBias;
    }

    public static void main(String[] args) throws Exception {
        int exitCode = ToolRunner.run((Tool)new CDTF(false), (String[])args);
        System.exit(exitCode);
    }

    public int run(String[] args) throws Exception {
        Configuration conf = this.getConf();
        conf.setInt("mapred.tasktracker.reduce.tasks.maximum", 1);
        conf.set("delim", ",");
        conf.setInt("waiting", 100);
        conf.setInt("seed", new Random().nextInt());
        System.out.println("========================");
        System.out.println("Start parameter check...");
        System.out.println("========================");
        String training = args[0];
        System.out.println("-training: " + training);
        conf.set("training", training);
        String outputDir = args[1];
        System.out.println("-output: " + outputDir);
        conf.set("output", outputDir);
        int M = Integer.valueOf(args[2]);
        System.out.println("-M: " + M);
        conf.setInt("M", M);
        int Tout = Integer.valueOf(args[3]);
        System.out.println("-Tout: " + Tout);
        conf.setInt("Tout", Tout);
        int Tin = Integer.valueOf(args[4]);
        System.out.println("-Tin: " + Tin);
        conf.setInt("Tin", Tin);
        int N = Integer.valueOf(args[5]);
        System.out.println("-N: " + N);
        conf.setInt("N", N);
        int K = Integer.valueOf(args[6]);
        System.out.println("-K: " + K);
        conf.setInt("K", K);
        float lambda = Float.valueOf(args[7]).floatValue();
        System.out.println("-lambda: " + lambda);
        conf.setFloat("lambda", lambda);
        boolean useWeight = Integer.valueOf(args[8]) > 0;
        System.out.println("-useWeight: " + useWeight);
        conf.setBoolean("use_weight", useWeight);
        int dim = 0;
        while (dim < N) {
            int modeLength = Integer.valueOf(args[9 + dim]);
            System.out.println("-I" + (dim + 1) + ": " + modeLength);
            conf.setInt("I" + (dim + 1), modeLength);
            conf.setInt("i" + (dim + 1), dim);
            ++dim;
        }
        conf.setInt("iv", N);
        String memory = "-Xmx" + Integer.valueOf(args[9 + N]) + "m";
        System.out.println("-memory: " + memory);
        conf.set("mapred.child.java.opts", memory);
        String test = null;
        if (args.length > 10 + N) {
            test = args[10 + N];
            System.out.println("-test: " + test);
            conf.set("test", test);
        }
        String query = null;
        if (args.length > 11 + N) {
            query = args[11 + N];
            System.out.println("-query: " + query);
            conf.set("query", query);
        }
        Output.setOutputPath(outputDir, conf);
        this.initHDFS(conf);
        if (this.useBias) {
            System.out.println("==============================");
            System.out.println("Calculate average...");
            System.out.println("==============================");
            float average = Average.run(conf);
            conf.setFloat("average", average);
            conf.setBoolean("use_bias", true);
        }
        System.out.println("==============================");
        System.out.println("Start greedy row assignment...");
        System.out.println("==============================");
        GreedyRowAssignment.run(conf);
        String method = this.useBias ? "Bias-CDTF" : "CDTF";
        System.out.println("=============");
        System.out.println("Start " + method);
        System.out.println("=============");
        System.out.println("The main process of " + method + " runs at cleanup stage which follows after reduce stage.");
        System.out.println("So, it may take several minutes (or hours depending on the data size) after reduce stage finishes.");
        DistributedCache.addCacheFile((URI)new URI(conf.get("indexmap")), (Configuration)conf);
        Job job = new Job(conf, method);
        job.setJarByClass(CDTF.class);
        job.setMapperClass(CommonMapper.class);
        job.setReducerClass(CDTFReducer.class);
        job.setInputFormatClass(TextInputFormat.class);
        job.setOutputFormatClass(NullOutputFormat.class);
        job.setMapOutputKeyClass(TripleWritable.class);
        job.setMapOutputValueClass(ElementWritable.class);
        job.setPartitionerClass(CommonPartitioner.class);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(Text.class);
        job.setNumReduceTasks(conf.getInt("M", 1));
        MultipleInputs.addInputPath((Job)job, (Path)new Path(conf.get("training", "")), TextInputFormat.class, CommonMapper.TrainingMapper.class);
        if (conf.get("test") != null) {
            MultipleInputs.addInputPath((Job)job, (Path)new Path(conf.get("test", "")), TextInputFormat.class, CommonMapper.TestMapper.class);
        }
        if (conf.get("query") != null) {
            MultipleInputs.addInputPath((Job)job, (Path)new Path(conf.get("query", "")), TextInputFormat.class, CommonMapper.QueryMapper.class);
        }
        job.waitForCompletion(true);
        System.out.println("=======================");
        System.out.println("Start writing output...");
        System.out.println("=======================");
        Output.performanceOutput(job, conf);
        return 0;
    }

    private void initHDFS(Configuration conf) throws IOException {
        Path basePath;
        int dimension = conf.getInt("N", 0);
        int Tout = conf.getInt("Tout", 0);
        int K = conf.getInt("K", 0);
        int Tin = conf.getInt("Tin", 0);
        String baseStr = conf.get("output", "");
        String logStr = String.valueOf(baseStr) + "/log";
        String dataStr = String.valueOf(baseStr) + "/data";
        FileSystem fs = null;
        fs = FileSystem.get((Configuration)conf);
        if (fs.exists(basePath = new Path(baseStr))) {
            fs.delete(basePath, true);
        }
        fs.mkdirs(basePath);
        fs.mkdirs(new Path(logStr));
        fs.mkdirs(new Path(dataStr));
        fs.mkdirs(new Path(conf.get("performance temp", "")));
        fs.mkdirs(new Path(conf.get("estimate", "")));
        fs.mkdirs(new Path(conf.get("factor_matrices", "")));
        if (conf.getBoolean("use_bias", false)) {
            fs.mkdirs(new Path(conf.get("biases", "")));
        }
        int outIter = 0;
        while (outIter < Tout) {
            fs.mkdirs(new Path(String.valueOf(dataStr) + "/" + outIter));
            fs.mkdirs(new Path(String.valueOf(logStr) + "/" + outIter));
            if (conf.getBoolean("use_bias", false)) {
                fs.mkdirs(new Path(String.valueOf(dataStr) + "/" + outIter + "/B"));
                fs.mkdirs(new Path(String.valueOf(logStr) + "/" + outIter + "/B"));
                int dim = 0;
                while (dim < dimension) {
                    fs.mkdirs(new Path(String.valueOf(dataStr) + "/" + outIter + "/B/" + dim));
                    fs.mkdirs(new Path(String.valueOf(logStr) + "/" + outIter + "/B/" + dim));
                    ++dim;
                }
            }
            int k = 0;
            while (k < K) {
                fs.mkdirs(new Path(String.valueOf(dataStr) + "/" + outIter + "/" + k));
                fs.mkdirs(new Path(String.valueOf(logStr) + "/" + outIter + "/" + k));
                int inIter = -1;
                while (inIter < Tin) {
                    fs.mkdirs(new Path(String.valueOf(dataStr) + "/" + outIter + "/" + k + "/" + inIter));
                    fs.mkdirs(new Path(String.valueOf(logStr) + "/" + outIter + "/" + k + "/" + inIter));
                    int dim = 0;
                    while (dim < dimension) {
                        fs.mkdirs(new Path(String.valueOf(dataStr) + "/" + outIter + "/" + k + "/" + inIter + "/" + dim));
                        fs.mkdirs(new Path(String.valueOf(logStr) + "/" + outIter + "/" + k + "/" + inIter + "/" + dim));
                        ++dim;
                    }
                    ++inIter;
                }
                ++k;
            }
            ++outIter;
        }
        fs.close();
    }
}

