/*
 * Decompiled with CFR 0.152.
 */
package sals.mr;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigDecimal;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.TextInputFormat;
import org.apache.hadoop.mapreduce.lib.output.NullOutputFormat;

public class Average {
    public static float run(Configuration conf) throws IOException, ClassNotFoundException, InterruptedException {
        Job job = new Job(conf, "AVERAGE");
        job.setJarByClass(Average.class);
        job.setMapperClass(AverageMapper.class);
        job.setReducerClass(AverageReducer.class);
        job.setInputFormatClass(TextInputFormat.class);
        job.setOutputFormatClass(NullOutputFormat.class);
        job.setMapOutputKeyClass(IntWritable.class);
        job.setMapOutputValueClass(DoubleWritable.class);
        job.setNumReduceTasks(1);
        FileInputFormat.addInputPath((Job)job, (Path)new Path(conf.get("training", "")));
        job.waitForCompletion(true);
        String userHome = System.getProperty("user.home");
        String tempFile = String.valueOf(userHome) + "/PEGASUS_TEMP_" + job.getJobID() + "_" + System.currentTimeMillis();
        FileSystem fs = FileSystem.get((Configuration)conf);
        fs.copyToLocalFile(true, new Path(String.valueOf(conf.get("average_path")) + "_obj"), new Path(tempFile));
        float average = 0.0f;
        ObjectInputStream os = new ObjectInputStream(new FileInputStream(tempFile));
        average = os.readFloat();
        os.close();
        fs.close();
        new File(tempFile).delete();
        return average;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AverageMapper
    extends Mapper<LongWritable, Text, IntWritable, DoubleWritable> {
        private String delim;
        private int valueIdx;
        private int count = 0;
        private double sum = 0.0;

        public void setup(Mapper.Context context) {
            Configuration conf = context.getConfiguration();
            this.delim = conf.get("delim", " ");
            this.valueIdx = conf.getInt("iv", 0);
        }

        public void map(LongWritable key, Text value, Mapper.Context context) throws IOException, InterruptedException {
            String[] tokens = value.toString().split(this.delim);
            this.sum += Double.valueOf(tokens[this.valueIdx]).doubleValue();
            ++this.count;
        }

        public void cleanup(Mapper.Context context) throws IOException, InterruptedException {
            context.write((Object)new IntWritable(this.count), (Object)new DoubleWritable(this.sum));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AverageReducer
    extends Reducer<IntWritable, DoubleWritable, NullWritable, NullWritable> {
        private int count = 0;
        private double sum = 0.0;

        public void reduce(IntWritable key, Iterable<DoubleWritable> values, Reducer.Context context) throws IOException, InterruptedException {
            this.count += key.get();
            for (DoubleWritable value : values) {
                this.sum += value.get();
            }
        }

        public void cleanup(Reducer.Context context) throws IOException, InterruptedException {
            Configuration conf = context.getConfiguration();
            String userHome = System.getProperty("user.home");
            String tempFile = String.valueOf(userHome) + "/PEGASUS_TEMP_" + context.getJobID() + "_" + System.currentTimeMillis();
            String tempFileObj = String.valueOf(userHome) + "/PEGASUS_TEMP2_" + context.getJobID() + "_" + System.currentTimeMillis();
            BufferedWriter bw = new BufferedWriter(new FileWriter(tempFile));
            bw.write(new BigDecimal(this.sum / (double)this.count).toString());
            bw.close();
            ObjectOutputStream os = new ObjectOutputStream(new FileOutputStream(tempFileObj));
            os.writeFloat((float)(this.sum / (double)this.count));
            os.close();
            FileSystem fs = FileSystem.get((Configuration)conf);
            fs.copyFromLocalFile(true, new Path(tempFile), new Path(conf.get("average_path")));
            fs.copyFromLocalFile(true, new Path(tempFileObj), new Path(String.valueOf(conf.get("average_path")) + "_obj"));
            fs.close();
        }
    }
}

