/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Random;

public class Generator {
    public static void createFactorizableTensor(int N, int I, int K, int omega, String outPath) throws IOException {
        Random random = new Random();
        float[][][] factors = new float[N][][];
        int dim = 0;
        while (dim < N) {
            factors[dim] = new float[K][I];
            int i = 0;
            while (i < I) {
                int r = 0;
                while (r < K) {
                    factors[dim][r][i] = random.nextFloat();
                    ++r;
                }
                ++i;
            }
            ++dim;
        }
        BufferedWriter bw = new BufferedWriter(new FileWriter(outPath));
        int s = 0;
        while (s < omega) {
            int[] index = new int[N];
            int dim2 = 0;
            while (dim2 < N) {
                index[dim2] = random.nextInt(I);
                ++dim2;
            }
            float sum = 0.0f;
            int r = 0;
            while (r < K) {
                float product = 1.0f;
                int dim3 = 0;
                while (dim3 < N) {
                    product *= factors[dim3][r][index[dim3]];
                    ++dim3;
                }
                sum += product;
                ++r;
            }
            sum = (float)((double)sum + Math.pow(random.nextFloat(), N));
            int dim4 = 0;
            while (dim4 < N) {
                bw.write(String.valueOf(index[dim4]) + ",");
                ++dim4;
            }
            bw.write(String.format("%f\n", (double)sum + Math.pow(random.nextFloat(), N)));
            ++s;
        }
        bw.close();
    }

    public static void main(String[] args) throws IOException {
        System.out.println("========================");
        System.out.println("Start parameter check...");
        System.out.println("========================");
        String output = args[0];
        System.out.println("-output: " + output);
        int N = Integer.valueOf(args[1]);
        System.out.println("-N: " + N);
        int I = Integer.valueOf(args[2]);
        System.out.println("-I: " + I);
        int K = Integer.valueOf(args[3]);
        System.out.println("-K: " + K);
        int omega = Integer.valueOf(args[4]);
        System.out.println("-omega: " + omega);
        System.out.println("========================");
        System.out.println("Start Writing Output...");
        System.out.println("========================");
        Generator.createFactorizableTensor(N, I, K, omega, output);
    }
}

