/*
 * TutorInterface.java
 *
 * Created on April 23, 2003, 12:06 PM
 */

import java.io.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.util.*;
import DORMIN.trace;

/**
 *
 * @author  mike, jonbrown
 */
public class TutorInterface extends pact.DorminWidgets.TutorWindow {
    
        private File audioFile = new File ("/home/jonbrown/sphinx2/share/sphinx2/model/lm/current/current.16k");
        private File hypFile = new File ("/home/jonbrown/sphinx2/share/sphinx2/model/lm/current/current.hyp");
        
        private String projdir = "/home/jonbrown/Sphinx2-CTAT/ProjectApplications/YouAreHere";
        

	/** Creates new form TutorInterface */
	public TutorInterface() {
		initComponents();
		super.initTutorWindow();
		//setSize(300, 320);
                loadNextProblem();
	}

	/** This method is called from within the constructor to
	 * initialize the form.
	 * WARNING: Do NOT modify this code. The content of this method is
	 * always regenerated by the Form Editor.
	 */
    private void initComponents() {//GEN-BEGIN:initComponents
        universalToolProxy1 = new pact.DorminWidgets.UniversalToolProxy();
        jScrollPane1 = new javax.swing.JScrollPane();
        jPanel1 = new javax.swing.JPanel();
        dorminButton2 = new pact.DorminWidgets.DorminButton();
        dorminButton1 = new pact.DorminWidgets.DorminButton();
        jButton1 = new javax.swing.JButton();
        jButton2 = new javax.swing.JButton();
        jLabel2 = new javax.swing.JLabel();
        jLabel3 = new javax.swing.JLabel();
        dorminTextArea1 = new pact.DorminWidgets.DorminTextArea();
        jLabel4 = new javax.swing.JLabel();
        pictureLabel = new javax.swing.JLabel();
        questionLabel = new javax.swing.JLabel();
        jLabel5 = new javax.swing.JLabel();
        jLabel6 = new javax.swing.JLabel();

        universalToolProxy1.setLoggingAuthToken("x");
        universalToolProxy1.setLoggingSessionID("y");
        universalToolProxy1.setLoggingUserID("z");
        universalToolProxy1.setShowAuthorMenu(true);
        universalToolProxy1.setShowDebugInfo(true);
        universalToolProxy1.setShowLoginMenu(true);

        getContentPane().setLayout(new java.awt.GridLayout(1, 0));

        setTitle("Tutor Interface");
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                exitForm(evt);
            }
        });

        jPanel1.setLayout(null);

        dorminButton2.setDorminName("Hint");
        dorminButton2.setText("Help");
        jPanel1.add(dorminButton2);
        dorminButton2.setBounds(450, 530, 90, 40);

        dorminButton1.setDorminName("Done");
        dorminButton1.setText("Done");
        jPanel1.add(dorminButton1);
        dorminButton1.setBounds(40, 530, 90, 40);

        jButton1.setIcon(new javax.swing.ImageIcon("/home/jonbrown/Sphinx2-CTAT/ProjectApplications/YouAreHere/RecordButton.png"));
        jButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton1ActionPerformed(evt);
            }
        });

        jPanel1.add(jButton1);
        jButton1.setBounds(240, 460, 60, 33);

        jButton2.setIcon(new javax.swing.ImageIcon("/home/jonbrown/Sphinx2-CTAT/ProjectApplications/YouAreHere/StopButton.png"));
        jButton2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton2ActionPerformed(evt);
            }
        });

        jPanel1.add(jButton2);
        jButton2.setBounds(360, 460, 60, 33);

        jLabel2.setFont(new java.awt.Font("Dialog", 1, 14));
        jLabel2.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        jLabel2.setText("Record");
        jPanel1.add(jLabel2);
        jLabel2.setBounds(240, 440, 60, 20);

        jLabel3.setFont(new java.awt.Font("Dialog", 1, 14));
        jLabel3.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        jLabel3.setText("Stop");
        jPanel1.add(jLabel3);
        jLabel3.setBounds(360, 440, 60, 20);

        jPanel1.add(dorminTextArea1);
        dorminTextArea1.setBounds(10, 290, 200, 230);

        jLabel4.setFont(new java.awt.Font("Dialog", 1, 14));
        jLabel4.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        jLabel4.setText("Directions");
        jPanel1.add(jLabel4);
        jLabel4.setBounds(10, 250, 180, 30);

        jPanel1.add(pictureLabel);
        pictureLabel.setBounds(220, 10, 330, 200);

        jPanel1.add(questionLabel);
        questionLabel.setBounds(230, 340, 360, 90);

        jLabel5.setText("Please select the next direction:");
        jPanel1.add(jLabel5);
        jLabel5.setBounds(230, 310, 300, 30);

        jLabel6.setIcon(new javax.swing.ImageIcon("C:\\Documents and Settings\\jonbrown\\Desktop\\717 Project\\Deliverance-Junket\\Are_Here.gif"));
        jPanel1.add(jLabel6);
        jLabel6.setBounds(0, 0, 200, 250);

        jScrollPane1.setViewportView(jPanel1);

        getContentPane().add(jScrollPane1);

        pack();
    }//GEN-END:initComponents

    private void jButton2ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton2ActionPerformed
        // Add your handling code here:
        recognizer.stopRecording();
        recognizer.doRecognize();
        String s[] = recognizer.getNBest();
            
        //get the best match for s
        String spoken = recognizer.getBestMatch(s, currentAnswerChoices);
        
        //String spoken = "Go left at the light.";
        //String spoken = currentCorrectAnswer;
        
        JTextArea innerTextArea = (JTextArea) findComponent(this, "javax.swing.JTextArea");
        
        if (lastWasError) {
            //we need to remove the last line from the text area
            String areatext = dorminTextArea1.getText();
            int endindex = areatext.lastIndexOf("\n");
            if (endindex == -1) {
                //couldn't find.  clear whole thing.
                dorminTextArea1.setText("");
            }
            else {
                //keep everything up to endindex
                dorminTextArea1.setText(areatext.substring(0, endindex));
            }                
        }
        
        if (spoken.equalsIgnoreCase(currentCorrectAnswer))
        {
            //correct answer
            lastWasError = false;
            
            //update directions box
            if (dorminTextArea1.getText().equals("")) {
                innerTextArea.setText(spoken);
            }
            else {
                innerTextArea.setText(dorminTextArea1.getText() + "\n" + spoken);
            }
            FocusEvent fe = new FocusEvent(dorminTextArea1, FocusEvent.FOCUS_LOST);
            dorminTextArea1.focusLost(fe);
            
            //load the next problem
            loadNextProblem();
        }
        else
        {
            //they spoke one of the incorrect answers or was not understood
            lastWasError = true;
            
            if (dorminTextArea1.getText().equals("")) {
                innerTextArea.setText(spoken);
            }
            else {
                innerTextArea.setText(dorminTextArea1.getText() + "\n" + spoken);
            }
            FocusEvent fe = new FocusEvent(dorminTextArea1, FocusEvent.FOCUS_LOST);
            dorminTextArea1.focusLost(fe);
        }
    }//GEN-LAST:event_jButton2ActionPerformed

    private void jButton1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton1ActionPerformed
        // Add your handling code here:
        recognizer = new Recognizer(audioFile, hypFile);
        
        recognizer.startRecording();
    }//GEN-LAST:event_jButton1ActionPerformed

    private void loadNextProblem() {
        String question = "";
        currentAnswerChoices = new Vector();
        
        try {
            BufferedReader br = new BufferedReader(new FileReader(projdir + "/Problem" + questionCount + ".txt"));
            String s = "";
            boolean first = true;
            while ( (s=br.readLine()) != null )
            {
                if (first)
                {
                    first = false;
                    question = "<html>" + s;
                    currentAnswerChoices.add(s);
                }
                else
                {
                    if (s.startsWith("//"))
                    {
                        //we found the answer
                        currentCorrectAnswer = s.substring(2);
                    }
                    else
                    {
                        question = question + " <br> " + s;
                        currentAnswerChoices.add(s);
                    }
                }
            }
            
            question = question + "</html>";
            questionLabel.setText(question);

            ImageIcon ii = new ImageIcon(projdir + "/Image" + questionCount + ".gif");
            int newHeight = 275;
            ii = new ImageIcon(ii.getImage().getScaledInstance(-1, newHeight, Image.SCALE_DEFAULT));
            pictureLabel.setSize(ii.getIconWidth(), ii.getIconHeight());
            pictureLabel.setIcon(ii);        

            questionCount++;
        }
        catch (Exception e)
        {
            System.out.println(e.toString());
        }       
    }
    
    private Component findComponent(Container c, String className) {
        Component[] all = c.getComponents();
        
        for (int i=0; i<all.length; i++) {
            Component inner = all[i];
            if (inner.getClass().getName().equals(className)) {
                return inner;
            }
            else if (inner instanceof Container) {
                Component c2 = findComponent(((Container)inner), className);
                if (c2 != null) {
                    return c2;
                }                    
            }
        }
        
        return null;
    }
    
	/** Exit the Application */
	private void exitForm(
		java.awt.event.WindowEvent evt) { //GEN-FIRST:event_exitForm
		System.exit(0);
	} //GEN-LAST:event_exitForm

	/**
	 * @param args the command line arguments
	 */
	public static void main(String args[]) {
		new TutorInterface().show();
	}

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private pact.DorminWidgets.DorminButton dorminButton1;
    private pact.DorminWidgets.DorminButton dorminButton2;
    private pact.DorminWidgets.DorminTextArea dorminTextArea1;
    private javax.swing.JButton jButton1;
    private javax.swing.JButton jButton2;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JLabel pictureLabel;
    private javax.swing.JLabel questionLabel;
    private pact.DorminWidgets.UniversalToolProxy universalToolProxy1;
    // End of variables declaration//GEN-END:variables

    private Recognizer recognizer = null; 
    private int questionCount = 1;
    private String currentCorrectAnswer = "";
    private Vector currentAnswerChoices;
    private boolean lastWasError = false;
}
